<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Controller\BaseController;

// Helper & model
$com_helper = JPATH_BASE . '/components/com_spbooking/helpers/helper.php';

if (file_exists($com_helper))
{
	require_once $com_helper;
}
else
{
	echo '<p class="alert alert-warning">' . Text::_('COM_SPBOOKING_COMPONENT_NOT_INSTALLED_OR_MISSING_FILE') . '</p>';

	return;
}

HTMLHelper::_('jquery.framework');
$doc = Factory::getDocument();

// Include CSS files
$doc->addStylesheet(Uri::root() . 'components/com_spbooking/assets/css/spbooking-structure.css');
$doc->addStylesheet(Uri::root() . 'components/com_spbooking/assets/css/nouislider.min.css');
$doc->addStylesheet(Uri::root() . 'components/com_spbooking/assets/css/style.css');
$doc->addStylesheet(Uri::root() . 'administrator/components/com_spbooking/assets/css/font-awesome.min.css');

if (JVERSION < 4)
{
	$doc->addStylesheet(Uri::root() . 'administrator/components/com_spbooking/assets/css/font-awesome-5.min.css');
	$doc->addStyleSheet(Uri::root(true) . '/administrator/components/com_spbooking/assets/css/font-awesome-v4-shims.css');
}

$doc->addStylesheet(Uri::root() . 'components/com_spbooking/assets/css/flatpickr.theme.materialGreen.css');

// Include owl carousel
$doc->addStylesheet(Uri::root() . 'components/com_spbooking/assets/css/owl.carousel.min.css');
$doc->addStylesheet(Uri::root() . 'components/com_spbooking/assets/css/owl.theme.green.css');
$doc->addStylesheet(Uri::root() . 'administrator/components/com_spbooking/assets/css/icomoon.css');


// Include js
$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/spbooking.js');
$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/owl.carousel.min.js');
$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/nouislider.min.js');
$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/flatpickr.min.js');
$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/spvalidate.js');


$doc->addScriptDeclaration("var rooturl = '" . Uri::root() . "';");

$cParams = ComponentHelper::getParams('com_spbooking');
$currency = $cParams->get('currency', 'USD:$');
$currency_position = $cParams->get('currency_position', 'left');
$currency = explode(':', $currency, 2)[1];

$doc->addScriptDeclaration("var gCurrency = '" . $currency . "';");
$doc->addScriptDeclaration("var gCurrency_position = '" . $currency_position . "';");

$controller = BaseController::getInstance('Spbooking');
$input 		= Factory::getApplication()->input;
$view 		= $input->getCmd('view', 'default');
$input->set('view', $view);
$controller->execute($input->getCmd('task'));
$controller->redirect();
