<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Component\Router\RouterView;
use Joomla\CMS\Component\Router\Rules\MenuRules;
use Joomla\CMS\Component\Router\Rules\NomenuRules;
use Joomla\CMS\Component\Router\Rules\StandardRules;
use Joomla\CMS\Component\Router\RouterViewConfiguration;

class SpbookingRouter extends RouterView
{
	protected $noIDs = false;

	public function __construct($app = null, $menu = null)
	{
		$params = ComponentHelper::getParams('com_spbooking');
		$this->noIDs = (bool) $params->get('sef_ids', 1);

		// Register accommodations view
		$accommodations = new RouterViewConfiguration("accomodations");
		$this->registerView($accommodations);
		$accommodation	= new RouterViewConfiguration("accomodation");
		$accommodation->setKey('id')->setParent($accommodations);
		$this->registerView($accommodation);

		// Register your Packages view
		$packages = new RouterViewConfiguration("packages");
		$this->registerView($packages);
		$package	= new RouterViewConfiguration("package");
		$package->setKey('id')->setParent($packages);
		$this->registerView($package);

		// Register your invoices view
		$invoices = new RouterViewConfiguration("invoices");
		$this->registerView($invoices);
		$invoice	= new RouterViewConfiguration("invoice");
		$invoice->setKey('id')->setParent($invoices);
		$this->registerView($invoice);

		// Register your transports view
		$transports = new RouterViewConfiguration("transports");
		$this->registerView($transports);
		$transport	= new RouterViewConfiguration("transport");
		$transport->setKey('id')->setParent($transports);
		$this->registerView($transport);

		// Register your places view
		$places = new RouterViewConfiguration("places");
		$this->registerView($places);
		$place	= new RouterViewConfiguration("place");
		$place->setKey('id')->setParent($places);
		$this->registerView($place);

		// Register your checkout view
		$checkout = new RouterViewConfiguration("checkout");
		$this->registerView($checkout);

		// Register your icomoons view
		$icomoons = new RouterViewConfiguration("icomoons");
		$this->registerView($icomoons);

		// Register your icons view
		$icons = new RouterViewConfiguration("icons");
		$this->registerView($icons);

		parent::__construct($app, $menu);

		$this->attachRule(new MenuRules($this));
		$this->attachRule(new StandardRules($this));
		$this->attachRule(new NomenuRules($this));
	}

	/**
	 * Build method for URLs
	 *
	 * @param   array  &$query  Array of query elements
	 *
	 * @return  array  Array of URL segments
	 *
	 * @since   3.5
	 */
	public function build(&$query)
	{

		$view = isset($query['view']) ? $query['view'] : '';

		if ($view == 'accomodation' || $view == 'accomodations' || $view == 'transports' || $view == 'packages' || $view == 'places')
		{
			unset($query['view_style']);
			unset($query['package_type']);
			unset($query['m_country']);
		}

		$segments = array();

		// Process the parsed variables based on custom defined rules
		foreach ($this->rules as $rule)
		{
			$rule->build($query, $segments);
		}

		return $segments;
	}

	private function getAlias($tbl, $id)
	{
		$db = Factory::getDbo();
		$dbquery = $db->getQuery(true);
		$dbquery->select($db->quoteName('alias'))
			->from($db->quoteName($tbl))
			->where($db->quoteName('id') . ' = ' . $db->quote($id));
		$db->setQuery($dbquery);

		return $db->loadResult();
	}

	private function getId($tbl, $alias)
	{
		$db = Factory::getDbo();
		$dbquery = $db->getQuery(true);
		$dbquery->select($db->quoteName('id'))
			->from($db->quoteName($tbl))
			->where($db->quoteName('alias') . ' = ' . $db->quote($alias));
		$db->setQuery($dbquery);

		return $db->loadResult();
	}

	// Handling accommodation methods
	public function getAccomodationSegment($id, $query)
	{
		if (!strpos($id, ':'))
		{
			$id .= ':' . $this->getAlias('#__spbooking_accomodations', $id);
		}

		if ($this->noIDs)
		{
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}

		return array((int) $id => $id);
	}

	public function getAccomodationsSegment($id, $query)
	{
		$this->getAccomodationSegment($id, $query);
	}

	public function getAccomodationId($segment, $query)
	{
		if ($this->noIDs)
		{
			return (int) $this->getId('#__spbooking_accomodations', $segment);
		}

		return (int) $segment;
	}

	public function getAccomodationsId($segment, $query)
	{
		$this->getAccomodationId($segment, $query);
	}

	// Handling packages methods
	public function getPackageSegment($id, $query)
	{
		if (!strpos($id, ':'))
		{
			$id .= ':' . $this->getAlias('#__spbooking_packages', $id);
		}

		if ($this->noIDs)
		{
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}

		return array((int) $id => $id);
	}

	public function getPackagesSegment($id, $query)
	{
		$this->getPackageSegment($id, $query);
	}

	public function getPackageId($segment, $query)
	{
		if ($this->noIDs)
		{
			return (int) $this->getId('#__spbooking_packages', $segment);
		}

		return (int) $segment;
	}

	public function getPackagesId($segment, $query)
	{
		$this->getPackageId($segment, $query);
	}

	// Handle transports methods
	public function getTransportSegment($id, $query)
	{
		if (!strpos($id, ':'))
		{
			$id .= ':' . $this->getAlias('#__spbooking_transports', $id);
		}

		if ($this->noIDs)
		{
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}

		return array((int) $id => $id);
	}

	public function getTransportsSegment($id, $query)
	{
		$this->getTransportSegment($id, $query);
	}

	public function getTransportId($segment, $query)
	{
		if ($this->noIDs)
		{
			return (int) $this->getId('#__spbooking_transports', $segment);
		}

		return (int) $segment;
	}

	public function getTransportsId($segment, $query)
	{
		$this->getTransportId($segment, $query);
	}

	// Handle places methods
	public function getPlaceSegment($id, $query)
	{
		if (!strpos($id, ':'))
		{
			$id .= ':' . $this->getAlias('#__spbooking_places', $id);
		}

		if ($this->noIDs)
		{
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}

		return array((int) $id => $id);
	}

	public function getPlacesSegment($id, $query)
	{
		$this->getPlaceSegment($id, $query);
	}

	public function getPlaceId($segment, $query)
	{
		if ($this->noIDs)
		{
			return (int) $this->getId('#__spbooking_places', $segment);
		}

		return (int) $segment;
	}

	public function getPlacesId($segment, $query)
	{
		$this->getPlaceId($segment, $query);
	}

	// Handle places methods
	// public function getInvoiceSegment($id, $query)
	// {
	// 	if (!strpos($id, ':')) {
	// 		$id .= ':' . $this->getAlias('#__spbooking_bookings', $id);
	// 	}

	// 	if ($this->noIDs) {
	// 		list($void, $segment) = explode(':', $id, 2);
	// 		return array($void => $segment);
	// 	}

	// 	return array((int)$id => $id);
	// }

	// Public function getInvoicesSegment($id, $query)
	// {
	// 	$this->getPlaceSegment($id, $query);
	// }

	// Public function getInvoiceId($segment, $query)
	// {
	// 	if ($this->noIDs) {
	// 		return (int)$this->getId('#__spbooking_bookings', $segment);
	// 	}

	// 	return (int)$segment;
	// }

	// Public function getInvoicesId($segment, $query)
	// {
	// 	$this->getPlaceId($segment, $query);
	// }
}

function spbookingBuildRoute(&$query)
{
	$app = Factory::getApplication();
	$router = new SpbookingRouter($app, $app->getMenu());

	return $router->build($query);
}

function spbookingParseRoute($segments)
{
	$app = Factory::getApplication();
	$router = new SpbookingRouter($app, $app->getMenu());

	return $router->parse($segments);
}
