<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingModelTransports extends ListModel
{

	protected function populateState($ordering = null, $direction = null)
	{
		$app = Factory::getApplication('site');
		$this->setState('list.start', $app->input->get('limitstart', 0, 'uint'));
		$this->setState('filter.language', Multilanguage::isEnabled());
		$cParams = ComponentHelper::getParams('com_spbooking');
		$limit = $cParams->get('transports_limit', 6);
		$this->setState('list.limit', $limit);
	}

	protected function getListQuery()
	{

		$input  = Factory::getApplication()->input;

		// Get POST data
		$searching 		= $input->get('searching', null, 'INT');
		$keyword 		= $input->get('keyword', null, 'STRING');
		$sdate 			= $input->get('sdate', null, 'STRING');
		$feature 		= $input->get('feature', null, 'STRING');
		$category_id 	= $input->get('category', null, 'INT');
		$min_price 		= $input->get('min-price', 0, 'INT');
		$max_price 		= $input->get('max-price', 99999, 'INT');
		$id 			= $input->get('transport_id', '', 'INT');
		$country 		= $input->get('country', '', 'STRING');
		$state 			= $input->get('state', '', 'STRING');
		$city	 		= $input->get('city', '', 'STRING');

		$checkin 		= $input->get('checkin', '', 'STRING');
		$checkout 		= $input->get('checkout', '', 'STRING');
		$transport 		= $input->get('transport', '', 'INT');

		$excluded_ids = $this->getAvailableTransports($checkin, $checkout);

		// Check is valid date
		$pattern = "/^[0-9]{4}\-[0-9]{2}\-[0-9]{2}$/";

		if (!empty($checkin))
		{
			preg_match($pattern, $checkin, $matches);

			if (empty($matches))
			{
				$checkin = '';
			}
		}

		if (!empty($checkout))
		{
			preg_match($pattern, $checkout, $matches);

			if (empty($matches))
			{
				$checkout = '';
			}
		}

		// Database query
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select('a.*');
		$query->select($db->quoteName('b.title', 'category_name'));
		$query->from($db->quoteName('#__spbooking_transports', 'a'));
		$query->join('LEFT', $db->quoteName('#__spbooking_categories', 'b') . ' ON (' . $db->quoteName('a.category_id') . ' = ' . $db->quoteName('b.id') . ')');
		$query->where($db->quoteName('a.published') . ' = ' . $db->quote('1'));

		// Filter by package id
		if (!empty($id))
		{
			$query->where($db->quoteName('a.id') . ' = ' . $db->quote($id));
		}

		// Filter by country
		if (!empty($country))
		{
			$query->where($db->quoteName('a.country') . ' = ' . $db->quote(base64_decode($country)));
		}

		// Filter by city
		if (!empty($city))
		{
			$query->where($db->quoteName('a.city') . ' = ' . $db->quote(base64_decode($city)));
		}

		// Filter by state
		if (!empty($state))
		{
			$conditions[] = $db->quoteName('a.state') . ' = ' . $db->quote(base64_decode($state));
		}

		if (!empty($transport))
		{
			$query->where($db->quoteName('a.id') . ' = ' . $transport);
		}

		if (!empty($excluded_ids))
		{
			$query->where($db->quoteName('a.id') . ' NOT IN (' . implode(',', $excluded_ids) . ')');
		}

		if (isset($min_price) && isset($max_price) && $max_price != 0)
		{
			$query->where($db->quoteName('a.price') . ' >= ' . (int) $min_price);
			$query->where($db->quoteName('a.price') . ' <= ' . (int) $max_price);
		}

		if ($this->getState('filter.language'))
		{
			$query->where($db->quoteName('a.language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		return $query;
	}


	private function getAvailableTransports($begin, $end)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('transport_id')->from($db->quoteName('#__spbooking_bookings'));

		if (!empty($begin))
		{
			$query->where($db->quoteName('checkin') . ' <= ' . $db->quote($begin));
			$query->where($db->quoteName('checkout') . ' >= ' . $db->quote($begin));
		}

		if (!empty($end))
		{
			$query->where($db->quoteName('checkin') . ' <= ' . $db->quote($end));
			$query->where($db->quoteName('checkout') . ' >= ' . $db->quote($end));
		}

		$query->where($db->quoteName('booking_for') . ' = ' . $db->quote('transport'));
		$query->where($db->quoteName('published') . ' = 1');

		$db->setQuery($query);

		return (empty($bgin) && empty($end)) ? array() : $db->loadColumn();

	}

}

