<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingModelPlaces extends ListModel
{

	protected function populateState($ordering = null, $direction = null)
	{
		$app = Factory::getApplication('site');
		$this->setState('list.start', $app->input->get('limitstart', 0, 'uint'));
		$this->setState('filter.language', Multilanguage::isEnabled());
		$menu = $app->getMenu()->getActive();
		$mParams = $menu->getParams();
		$cParams = ComponentHelper::getParams('com_spbooking');
		$limit = $cParams->get('places_limit', 6);

		$this->setState('list.limit', $limit);
	}

	protected function getListQuery()
	{

		$input  = Factory::getApplication()->input;

		// Get POST data
		$searching 		= $input->get('searching', null, 'INT');
		$keyword 		= $input->get('keyword', null, 'STRING');
		$tags 			= $input->get('tags', '', 'STRING');
		$categories 	= $input->get('categories', '', 'STRING');
		$m_country 		= $input->get('m_country', '', 'STRING');

		$place 			= $input->get('place', '', 'INT');
		$city 			= $input->get('city', '', 'STRING');
		$state 			= $input->get('state', '', 'STRING');
		$country 		= $input->get('country', '', 'STRING');

		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select('a.*');
		$query->select($db->quoteName('b.title', 'category_name'));
		$query->from($db->quoteName('#__spbooking_places', 'a'));
		$query->join('LEFT', $db->quoteName('#__spbooking_categories', 'b') . ' ON (' . $db->quoteName('a.category_id') . ' = ' . $db->quoteName('b.id') . ')');

		if (!empty($keyword))
		{
			if (ltrim($keyword))
			{
				$keyword = preg_replace('#\xE3\x80\x80#s', " ", trim($keyword));
				$keyword_array = explode(" ", $keyword);
				$query_string = implode("|", $keyword_array);
				$query->where("(" . $db->quoteName('a.title') . ' REGEXP ' . $db->quote($query_string) . ' OR ' . $db->quoteName('a.description') . ' REGEXP ' . $db->quote($query_string) . ' OR ' . $db->quoteName('a.country') . ' REGEXP ' . $db->quote($query_string) . ' OR ' . $db->quoteName('a.city') . ' REGEXP ' . $db->quote($query_string) . ")");
			}
		}

		if (!empty($place))
		{
			$query->where($db->quoteName('a.id') . ' = ' . $db->quote($place));
		}

		if (!empty($city))
		{
			$query->where($db->quoteName('a.city') . ' = ' . $db->quote(base64_decode($city)));
		}

		if (!empty($state))
		{
			$query->where($db->quoteName('a.state') . ' = ' . $db->quote(base64_decode($state)));
		}

		if (!empty($country))
		{
			$query->where($db->quoteName('a.country') . ' = ' . $db->quote(base64_decode($country)));
		}

		$query->where($db->quoteName('a.published') . ' = ' . $db->quote('1'));

		if ($this->getState('filter.language'))
		{
			$query->where($db->quoteName('a.language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		if (!empty($m_country))
		{
			$query->where($db->quoteName('a.country') . ' = ' . $db->quote($m_country));
		}

		return $query;
	}
}

