<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ItemModel;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingModelPayment extends ItemModel
{
	protected $_context = 'com_spbooking.accomodation';

	protected function populateState()
	{
		$app = Factory::getApplication('site');
		$itemId = $app->input->getInt('id');
		$this->setState('payment.id', $itemId);
		$this->setState('filter.language', Multilanguage::isEnabled());
	}

	public function getItem( $itemId = null )
	{
		$input = Factory::getApplication()->input;
		$booked_id = $input->get('booking_id', '', 'STRING');

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->quoteName('#__spbooking_bookings'))
			->where($db->quoteName('booked_id') . ' = ' . $db->quote($booked_id))
			->where($db->quoteName('published') . ' = 1');

		$db->setQuery($query);

		return $db->loadObject();
	}

	public function getAccomodationInfo($id)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from($db->quoteName('#__spbooking_accomodations'))
			->where($db->quoteName('id') . ' = ' . $db->quote($id))
			->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$db->setQuery($query);

		return $db->loadObject();
	}

	public function getPackageInfo($id)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from($db->quoteName('#__spbooking_packages'))
			->where($db->quoteName('id') . ' = ' . $db->quote($id))
			->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$db->setQuery($query);

		return $db->loadObject();
	}

	public function getTransportInfo($id)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from($db->quoteName('#__spbooking_transports'))
			->where($db->quoteName('id') . ' = ' . $db->quote($id))
			->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$db->setQuery($query);

		return $db->loadObject();
	}

	// Check duplicate transactions
	public function getDublicateTransaction($booked_id = '', $order_type = 'package', $txn_id ='')
	{

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'booked_id')));
		$query->from($db->quoteName('#__spbooking_bookings'));
		$query->where($db->quoteName('published') . " = 1");

		// Conditions
		$query->where($db->quoteName('booked_id') . " = " . $db->quote($booked_id));
		$query->where($db->quoteName('txn_id') . " = " . $db->quote($txn_id));

		if ($order_type)
		{
			$query->where($db->quoteName('booking_for') . " = " . $db->quote($order_type));
		}

		$query->order('ordering DESC');
		$db->setQuery($query);
		$result = $db->loadObject();

		// File_put_contents( __DIR__ .'/iteminfoa.txt', json_encode('Bookid: '.$booked_id .', itemid: ' . $itemid .', order_type: ' . $order_type. ', user_id: ' . $user_id) );

		if ($result)
		{
			return true;
		}

		return false;
	}


	// Paypal change order status
	public function storeOrder($order_info = array())
	{
		// File_put_contents( __DIR__ .'/iteminfoa.txt', json_encode($order_info));
		$params = ComponentHelper::getParams('com_spbooking');

		if ($order_info['payment_type'] == 'paypal')
		{
			if ($params->get('shop_environment') == 'sandbox')
			{
				$payment_status = 'paid';
			}
			else
			{
				$payment_status = ($order_info['payment_status'] == 'Completed') ? 'paid' : '';
			}
		}
		elseif ($order_info['payment_type'] == 'paylater')
		{
			$payment_status = 'paylater';
			$order_info['txn_id'] = '';
			$order_info['payment_amount'] = 0.00;
		}
		elseif ($order_info['payment_type'] == 'stripe')
		{
			$payment_status = 'paid';
		}
		else
		{
			$payment_status = 'pending';
		}

		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		// Fields to update.
		$fields = array(
			$db->quoteName('booking_status') . ' = ' . $db->quote($payment_status),
			$db->quoteName('txn_id') . ' = ' . $db->quote($order_info['txn_id']),
			$db->quoteName('total_paid') . ' = ' . $db->quote($order_info['payment_amount']),
			$db->quoteName('payment_type') . ' = ' . $db->quote($order_info['payment_type']),
		);

		// Conditions for which records should be updated.
		$conditions = array(
			$db->quoteName('booked_id') . ' = ' . $db->quote($order_info['booked_id']),
			$db->quoteName('id') . ' = ' . $db->quote($order_info['itemid'])
		);
		$query->update($db->quoteName('#__spbooking_bookings'))->set($fields)->where($conditions);
		$db->setQuery($query);
		$result = $db->execute();

		return true;
	}

	// Paypal refund order
	public function refundOrder($order_info)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		// Fields to update.
		$fields = array(
			$db->quoteName('published') . ' = 0',
			$db->quoteName('booking_status') . ' = ' . $db->quote('refund'),
		);

		// Conditions for which records should be updated.
		$conditions = array(
			$db->quoteName('booked_id') . ' = ' . $db->quote($order_info['booked_id']),
			$db->quoteName('id') . ' = ' . $db->quote($order_info['itemid']),
			$db->quoteName('txn_id') . ' = ' . $db->quote($order_info['txn_id'])
		);
		$query->update($db->quoteName('#__spbooking_bookings'))->set($fields)->where($conditions);
		$db->setQuery($query);
		$db->execute();

	}


}

