<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingModelPackages extends ListModel {

	protected function populateState($ordering = null, $direction = null) {
		$app = Factory::getApplication('site');
		$this->setState('list.start', $app->input->get('limitstart', 0, 'uint'));
		$this->setState('filter.language', Multilanguage::isEnabled());
		$menu = $app->getMenu()->getActive();
		$mParams = $menu->getParams();
		$cParams = ComponentHelper::getParams('com_spbooking');
		$limit = $cParams->get('packages_limit', 6);
		
		$this->setState('list.limit', $limit);
	}

	protected function getListQuery() {

		$input  = Factory::getApplication()->input;
		// Get POST data
		$searching 		= $input->get('searching', NULL, 'INT');
		$city 			= $input->get('city', NULL, 'STRING');
		$sdate 			= $input->get('sdate', NULL, 'STRING');
		$facilities 	= $input->get('facilities', '', 'STRING');
		$tags 			= $input->get('tags', '', 'STRING');
		$min_price 		= $input->get('min-price', 0, 'INT');
		$max_price 		= $input->get('max-price', 0, 'INT');
		$package_id 	= $input->get('package', '', 'INT');
		$country 		= $input->get('country', '', 'STRING');
		$state 			= $input->get('state', '', 'STRING');
		$city	 		= $input->get('city', '', 'STRING');
		$capacity 		= $input->get('capacity', '', 'INT');
		$category 		= $input->get('category', '', 'INT');
		$date_from 		= $input->get('date_from', '', 'STRING');
		$date_to 		= $input->get('date_to', '', 'STRING');
		$package_type 	= $input->get('package_type', 0, 'STRING');

		$p_state 		= $input->get('p_state', '', 'STRING');
		$p_city 		= $input->get('p_city', '', 'STRING');
		$p_country 		= $input->get('p_country', '', 'STRING');

		// check is valid date
		$pattern = "/^[0-9]{4}\-[0-9]{2}\-[0-9]{2}$/";
		if (!empty($date_from)) {
			preg_match($pattern, $date_from, $matches);

			if (empty($matches)) {
				$date_from = '';
			}
		}

		if (!empty($date_to)) {
			preg_match($pattern, $date_to, $matches);

			if (empty($matches)) {
				$date_to = '';
			}
		}
		

		// DB Query started
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select('a.*, b.title as category_name');
		$query->from($db->quoteName('#__spbooking_packages', 'a'));
		$query->join('LEFT', $db->quoteName('#__spbooking_categories', 'b') . ' ON (' . $db->quoteName('a.category_id') . ' = ' . $db->quoteName('b.id') . ')');
		  
		// filter by package id 
		if (!empty($package_id)) {
			$query->where($db->quoteName('a.id') . ' = ' . $db->quote($package_id));
		}
		
		// filter by country
		if (!empty($country)) {
			$query->where($db->quoteName('a.country') . ' = ' . $db->quote(base64_decode($country)));
		}
		
		// filter by city
		if (!empty($city)) {
			$query->where($db->quoteName('a.city') . ' = ' . $db->quote(base64_decode($city)));
		}
		
		// filter by state
		if (!empty($state)) {
			$conditions[] = $db->quoteName('a.state') . ' = ' . $db->quote(base64_decode($state));
		}

		// filter by capacity
		if (!empty($capacity)) {
			$query->where($db->quoteName('a.availability') . ' >= ' . $capacity );
		}

		// filter by category
		if (!empty($category)) {
			$query->where($db->quoteName('a.category_id') . ' = ' . $db->quote($category) );
		}
		
		// filter by country from module 
		if (!empty($p_country)) {
			$query->where($db->quoteName('a.country') . ' = ' . $db->quote($p_country));
		}
		
		// filter by city from module
		if (!empty($p_city)) {
			$query->where($db->quoteName('a.city') . ' = ' . $db->quote($p_city));
		}
		
		// filter by state from module
		if (!empty($p_state)) {
			$query->where($db->quoteName('a.state') . ' = ' . $db->quote($p_state));
		}

		// filter package type
		if (!empty($package_type)) {
			$query->where($db->quoteName('a.package_type') . ' = ' . $db->quote($package_type));
		}

		// get all the packages starts between day_from and day_to
		if (!empty($date_from)) {
			$query->where($db->quoteName('a.start_date') . ' >= ' . $db->quote($date_from));
		}
		
		if (!empty($date_to)) {
			$query->where($db->quoteName('a.start_date') . ' <= ' . $db->quote($date_to));
		}

        $query->where($db->quoteName('a.published') . ' = ' . $db->quote('1'));

        if ($this->getState('filter.language')) {
            $query->where($db->quoteName('a.language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		// if searching
		// if search city
		if($city) {
			if (ltrim($city)) {
				$city = preg_replace('#\xE3\x80\x80#s', " ", trim($city));
				$city_array = explode(" ", $city);
				$query_string = implode("|",$city_array);
				$query->where('(' . $db->quoteName('a.title') . ' REGEXP '. $db->quote($db->escape($query_string)) . ' OR ' . $db->qn('a.description') . ' REGEXP ' . $db->q($query_string) . ' OR ' . $db->qn('a.location') . ' = ' . $db->q($db->escape($city)) . ')');
			}
		}
		// if search date
		if ($sdate) {
			$query->where($db->qn('a.start_date')." = ".$db->quote($db->escape($sdate)));
		}
		// if search facility
		if(!empty($facilities)) {
			$facilities = explode(',', $facilities);
			$facility_ids = implode(' AND ', array_map(function ($entry) {
				return "a.additional_services LIKE '%\"" . $entry . "\"%'";
			}, $facilities));
			$query->where( $facility_ids );	
		}
		// if search tag
		if(!empty($tags)) {
			$tags = explode(',', $tags);
			$tag_ids = implode(' AND ', array_map(function ($entry) {
				return "a.package_tags LIKE '%\"" . $entry . "\"%'";
			}, $tags));
			$query->where( $tag_ids );
		}
		
		// if search price
		if(isset($min_price) && isset($max_price) && $max_price != 0) {
			$query->where($db->quoteName('a.price') . ' >= '. (int)$min_price);
			$query->where($db->quoteName('a.price') . ' <= '. (int)$max_price);
		}
		
		return $query;
	}

	public static function getPackageFacilities($short = true) {
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		if($short == true) {
			$query->select($db->quoteName(array('id', 'title', 'alias', 'logo')));
		} else {
			$query->select('*');
		}
		$query->from($db->quoteName('#__spbooking_additionalservices'));
		$query->where($db->quoteName('published')." = 1");
		$query->where($db->quoteName('service_for')." = ".$db->quote($db->escape('package')));

		// language filter
		if (Multilanguage::isEnabled()) {
            $query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$query->order('ordering DESC');
		$db->setQuery($query);
		$results = $db->loadObjectList();
		
		return $results;
	}

	
}
    
