<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Language\Multilanguage;

class SpbookingModelInvoices extends ListModel
{


	protected function populateState($ordering = null, $direction = null)
	{
		$app = Factory::getApplication('site');
		$this->setState('list.start', $app->input->get('limitstart', 0, 'uint'));
		$this->setState('filter.language', Multilanguage::isEnabled());
		$mParams = Factory::getApplication('site')->getMenu()->getActive()->getParams();
		$limit = $mParams->get('limit', 20);
		$this->setState('list.limit', $limit);
	}

	protected function getListQuery()
	{
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select('a.*');
		$query->from($db->quoteName('#__spbooking_bookings', 'a'));

		$input 			= Factory::getApplication()->input;
		$booking_for 	= $input->get('booking_for', '', 'STRING');
		$booking_status = $input->get('booking_status', '', 'STRING');
		$booked_id 		= $input->get('booked_id', '', 'STRING');
		$from 			= $input->get('from', '', 'STRING');
		$to 			= $input->get('to', '', 'STRING');

		$user = Factory::getUser();
		$user_id = -1;

		if ($user->id > 0)
		{
			$user_id = $user->id;
		}

		if (!empty($booking_for))
		{
			$query->where($db->quoteName('a.booking_for') . ' = ' . $db->quote($booking_for));
		}

		if (!empty($booking_status))
		{
			$query->where($db->quoteName('a.booking_status') . ' = ' . $db->quote($booking_status));
		}

		if (!empty($booked_id))
		{
			$query->where($db->quoteName('a.booked_id') . ' = ' . $db->quote($booked_id));
		}

		if (!empty($from))
		{
			$query->where($db->quoteName('a.checkin') . ' >= ' . $db->quote($from));
		}

		if (!empty($to))
		{
			$query->where($db->quoteName('a.checkin') . ' <= ' . $db->quote($to));
		}

		$query->where($db->quoteName('a.user_id') . ' = ' . $user->id);
		$query->where($db->quoteName('a.published') . ' = ' . $db->quote('1'));

		if ($this->getState('filter.language'))
		{
			$query->where($db->quoteName('a.language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		return $query;
	}

	public function getContentInfo($id, $which = 'accomodation')
	{
		$tbl_name = '#__spbooking_accomodations';

		if ($which == 'accomodation')
		{
			$tbl_name = '#__spbooking_accomodations';
		}
		elseif ($which == 'package')
		{
			$tbl_name = '#__spbooking_packages';
		}
		elseif ($which == 'transport')
		{
			$tbl_name = '#__spbooking_transports';
		}

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from($db->quoteName($tbl_name))
			->where($db->quoteName('id') . ' = ' . $db->quote($id))
			->where($db->quoteName('published') . ' = 1');
		$db->setQuery($query);

		return $db->loadObject();
	}
}

