<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ItemModel;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

class SpbookingModelCheckout extends ItemModel
{
	protected $_context = 'com_spbooking.checkout';
	protected function populateState()
	{
		$app = Factory::getApplication('site');
		$itemId = $app->input->getInt('id');
		$this->setState('checkout.id', $itemId);
		$this->setState('filter.language', Multilanguage::isEnabled());
	}

	public function getItem( $itemId = null )
	{
		$user = Factory::getUser();
		$itemId = (!empty($itemId)) ? $itemId : (int) $this->getState('checkout.id');

		$input      = Factory::getApplication()->input;
		$checkin    = $input->get('checkin', '', 'STRING');
		$checkout   = $input->get('checkout', '', 'STRING');
		$adults     = $input->get('adults', 1, 'INT');
		$children   = $input->get('children', 0, 'INT');

		$accomodations_model = BaseDatabaseModel::getInstance('Bookings', 'SpbookingModel');
		$rooms = $accomodations_model->getAvailableRooms($checkin, $checkout, $itemId, $adults, $children, null, null);

		return $rooms;
	}

	public function getAccomodationInfo($id)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from($db->quoteName('#__spbooking_accomodations'))
			->where($db->quoteName('id') . ' = ' . $db->quote($id))
			->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$db->setQuery($query);

		return $db->loadObject();
	}

	public function getPackageInfo($id)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from($db->quoteName('#__spbooking_packages'))
			->where($db->quoteName('id') . ' = ' . $db->quote($id))
			->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$db->setQuery($query);

		return $db->loadObject();
	}

	public function getTransportInfo($id)
	{
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from($db->quoteName('#__spbooking_transports'))
			->where($db->quoteName('id') . ' = ' . $db->quote($id))
			->where($db->quoteName('published') . ' = 1');

		// Language filter
		if (Multilanguage::isEnabled())
		{
			$query->where($db->quoteName('language') . ' IN (' . $db->quote(Factory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$db->setQuery($query);

		return $db->loadObject();
	}

	/**
	 * Get information of the Additional Services
	 *
	 * @param   string $additionalServicesIds
	 * @return void
	 */
	public function getAdditionalServices($additionalServicesIds)
	{

		$ids   = explode(',', str_replace(array('[',']','"'), '', $additionalServicesIds));

		$db    = Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('id,title,price,max_quantity')
			->from($db->quoteName('#__spbooking_additionalservices'))
			->whereIn($db->quoteName('id'), $ids);

		$db->setQuery($query);

		return $db->loadObjectList();
	}
}
