<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;

// Get component params
jimport('joomla.application.component.helper');
$this->cParams = ComponentHelper::getParams('com_spbooking');
$packages   = $displayData['packages'];

if (count((array) $packages))
{
	?>
<div class="spbooking-result-counter spbooking-justify-content-between spbooking-align-items-center">
	<h4 class="spbooking-col-auto"><?php // Echo $total_items; ?> <?php // Echo JText::_('COM_SPMEDICAL_TOTAL_ITEM_FOUND'); ?></h4>
	<!-- view style switcher -->
	<div class="view-style-switcher">
		<button class="btn btn-primary view-style-grid" type="button"><span class="fa fa-th"></span></button>
		<button class="btn btn-primary view-style-list" type="button"><span class="fa fa-list"></span></button>
	</div>
</div>
<div class="spbooking-row mt-10">
	<?php foreach ($packages as $package)
	{
		?>
		<div class="spbooking-packages spbooking-col-sm-4">
			<!-- <div class="specialist-wrapper spbooking-d-flex"> -->
				<div class="packages-img-wrapper">
					<a href="<?php echo $package->url; ?>" class="spbooking-btn spbooking-btn-primary">
						<img src="<?php echo $package->image; ?>" class="spbooking-person-img spbooking-img-responsive" alt="<?php echo $package->title; ?>">
					</a>
				</div> <!-- /.packages-img-wrapper -->
				<div class="packages-info-wrapper">
					<div class="packages-info-top">
						<?php if (!empty($package->price) && $package->price != 0.00)
						{
							?>
							<span class="packages-price">
								<?php echo $package->price_formated; ?>
							</span>
						<?php } ?>
					</div> <!-- /.packages-info-top -->
					<h3><a class="spbooking-package-title" href="<?php echo $package->url; ?>"><?php echo $package->title; ?></a></h3>
					<div class="packages-info-bottom">
						<div class="spbooking-package-location">
							<?php echo $package->location; ?>
						</div>
						<?php if (!empty($package->start_date) && $package->start_date != '0000-00-00')
		{
							?>
							<div class="spbooking-package-date-wrap">
								<span class="spbooking-package-start-date">
									<?php echo date('dS M', strtotime($package->start_date)); ?>
								</span>
								<?php if (!empty($package->end_date) && $package->end_date != '0000-00-00')
			{
									?>
									-
									<span class="spbooking-package-end-date">
										<?php echo date('dS M', strtotime($package->end_date)); ?>
									</span>
								<?php } ?>
							</div>
						<?php } ?>
					</div>
					
				</div> <!-- /.packages-info-wrapper -->
			<!-- </div> -->
		</div> <!-- /.spbooking-packages -->    
	<?php } ?>
</div> <!-- /.spbooking-row -->

<?php }
else
{
	?>
	<p><?php echo Text::_('COM_SPBOOKING_NO_ITEMS_FOUND'); ?></p>
<?php }
