<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;

$transport    = $displayData['transport'];
$this->helper = new SpbookingHelper;
$cParams      = ComponentHelper::getParams('com_spbooking');
$showRating   = $cParams->get('rating');

?>

<?php if (!empty($transport))
{
	?>
<div class="spbooking-package">
	<div class="spbooking-package-img-wrap">
		<a href="<?php echo $transport->url; ?>" class="full-link"></a>

		<?php if (!empty($transport->image))
	{
			?>
		<img src="<?php echo $transport->thumb; ?>" alt="">
		<?php } ?>

		<?php if (!empty($transport->sale_price) && $transport->sale_price != 0.00 && $transport->price > $transport->sale_price)
	{
			?>
		<div class="spbooking-package-discount">
			<span><?php echo Text::_('COM_SPBOOKING_COMMON_SAVE'); ?></span>
			<span
				class="only-price"><?php echo $this->helper->formatPrice($transport->price - $transport->sale_price, $transport->currency, $transport->currency_type, $transport->currency_position); ?></span>
		</div>
		<?php } ?>
	</div>
	<div class="spbooking-package-info">
		<div class="spbooking-price-wrap spbooking-d-flex">
			<?php if (!empty($transport->price) && !is_infinite($transport->price) && $transport->price != 0.00)
	{
				?>
			<span class="price">
				<small>
					<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_PRICE_FROM'); ?>
				</small>
				<?php if (!empty($transport->sale_price) && $transport->sale_price != 0.00)
		{
					?>
				<del>
					<?php echo $this->helper->formatPrice($transport->price, $transport->currency, $transport->currency_type, $transport->currency_position); ?>
				</del>
				<ins>
					<?php echo $this->helper->formatPrice($transport->sale_price, $transport->currency, $transport->currency_type, $transport->currency_position); ?>
				</ins> / <?php echo Text::_('COM_SPBOOKING_COMMON_DAY'); ?>
				<?php }
				else
		{
					?>
				<ins>
					<?php echo $this->helper->formatPrice($transport->price, $transport->currency, $transport->currency_type, $transport->currency_position); ?>
				</ins> / <?php echo Text::_('COM_SPBOOKING_COMMON_DAY'); ?>
				<?php } ?>
			</span>
			<?php } ?>
			<a href="<?php echo $transport->url; ?>" class="spbooking-btn spbooking-btn-pirmary"><?php echo Text::_('COM_SPBOOKING_PACKAGE_VIEW'); ?></a>
		</div>

		<?php if ($showRating)
	{
			?>
		<div class="content-rating mt-10">
			<?php foreach (range(1, 5) as $index)
		{
				?>
				<?php if ($index <= $transport->review['average_rating'])
			{
					?>
			<span class="fa fa-star is-filled"></span>
				<?php }
				elseif ($index > $transport->review['average_rating'] && $transport->review['average_rating'] > $index - 1)
			{
					?>
			<span class="fa fa-star-half-o is-filled"></span>
				<?php }
				else
			{
					?>
			<span class="fa fa-star-o"></span>
				<?php } ?>
			<?php } ?>
		</div>
		<?php } ?>
		
		<h3 class="title"><a href="<?php echo $transport->url; ?>"><?php echo $transport->title; ?></a></h3>
		<div class="transports-info-bottom mt-10">
			<?php if (!empty($transport->category_id) && !empty($transport->category_name))
	{
				?>
			<div class="transport-location pull-left">
				<span class="text-mute"><?php echo $transport->category_name; ?></span>
			</div>
			<?php } ?>
			<?php
			if ((!empty($transport->category_id) && !empty($transport->category_name)) && (!empty($transport->person_allowed) && $transport->person_allowed))
	{
				?>
			<span class="pull-left">&nbsp;|&nbsp;</span>
			<?php } ?>
			<?php
			if (!empty($transport->person_allowed) && $transport->person_allowed)
	{
				?>
			<div class="transport-location pull-left">
				<i class="fa fa-user-o"></i>&nbsp;<span class="text-mute"><?php echo $transport->person_allowed; ?></span>
			</div>
			<?php } ?>
		</div> <!-- /.transports-info-bottom -->
	</div> <!-- /.spbooking-layout-content -->
</div> <!-- /.spbooking-layout-component -->
<?php }
