<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

$accomodation_model = BaseDatabaseModel::getInstance('Accomodations', 'SpbookingModel');

$features   = $displayData['features'];
$categories = $displayData['categories'];

$input          = Factory::getApplication()->input;
$keyword        = $input->get('keyword', null, 'WORD');
$sdate          = $input->get('sdate', null, 'STRING');
$post_feature   = $input->get('feature', null, 'STRING');
$category_id    = $input->get('category', null, 'STRING');
$min_price      = $input->get('min-price', null, 'INT');
$max_price      = $input->get('max-price', null, 'INT');
$transport_id   = $input->get('package', '', 'INT');
$city       	= $input->get('city', '', 'STRING');
$country    	= $input->get('country', '', 'STRING');
$state	    	= $input->get('state', '', 'STRING');

$checkin 		= $input->get('checkin', '', 'STRING');
$checkout 		= $input->get('checkout', '', 'STRING');

$search_keyword = '';

if (!empty($country))
{
	$search_keyword = base64_decode($country);
}

if (!empty($city))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo(base64_decode($city), 'city', 'transport');
}

if (!empty($state))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo(base64_decode($state), 'state', 'transport');
}

if (!empty($transport_id))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo($transport_id, 'aid', 'transport');
}


// Attach documents
$doc = Factory::getDocument();
$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/topbar-search.js');
$doc->addScriptDeclaration("
    jQuery(function($){
        $('.topbar-filter').topSearch({
            topsearch_host : '" . Uri::root() . "',
			search_for: 'transport',
			checkin: '" . $checkin . "',
            checkout: '" . $checkout . "'
        });
    });
"
);

$menuItemId = SpbookingHelper::getItemId('transports');
$menuItemId = str_replace("&Itemid=", "", $menuItemId);

?>

<div class="topbar-search-options spbooking-top-filter">
	<aside class="topbar-filter">
		<h3><?php echo Text::_('COM_SPBOOKING_SEARCH_FIND_YOUR_ADVENTURE'); ?></h3>
		
		<!-- spbooking-transports-filters-form -->
		<form id="topbar-filter-form" class="spbooking-transports-filters-form spbooking-side-filters-form">
			<div class="reserve-box">
				<input type="hidden" name="option" value="com_spbooking">
				<input type="hidden" name="view" value="transports">
				<input type="hidden" name="Itemid" value="<?php echo $menuItemId; ?>">
			</div>
			<div class="spbooking-row">
				<!-- <div class="spbooking-search-keyword-wrap spbooking-input-wrap spbooking-col-lg-6 topbar-search-wrapper">
					<input id="spbooking-search-keyword-input" type="text" class="form-control" name="keyword" placeholder="Insert keyword name" value="<?php echo $keyword; ?>">
				</div> -->
				<div class="spbooking-search-keyword-wrap spbooking-input-wrap spbooking-col-lg-6 topbar-search-wrapper">
					<div class="form-groups">
						<!-- location search  -->
						<div class="topbar-search-wrapper">
							<input type="text" class="form-control search-destination" placeholder="<?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_DESTINATION'); ?>" value="<?php echo $search_keyword; ?>">
							<ul class="topbar-search-result"></ul>
							<div class="topbar-search-loading">
								<span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span>
							</div>
						</div>
						<input type="hidden" name="transport" class="topbar-accomodation-input" value="<?php echo $transport_id; ?>">
						<input type="hidden" name="city" class="topbar-city-input" value="<?php echo $city?>">
						<input type="hidden" name="country" class="topbar-country-input" value="<?php echo $country?>">
						<input type="hidden" name="state" class="topbar-state-input" value="<?php echo $state?>">
					</div>
				</div>

				<!-- filter by date -->
				<div class="spbooking-search-start-sdate-wrap spbooking-input-wrap spbooking-col-md-6 topbar-search-wrapper">
					<!-- <input type="text" id="spbooking-search-start-date" class="start-date form-control spbooking-date-picker" name="sdate" placeholder="<?php echo JText::_('COM_SPBOOKING_SELECT_SDATE'); ?>" value="<?php echo $sdate; ?>"> -->
					<input type="text" class="form-control topbar-checkin-out-range" placeholder="<?php echo Text::_('COM_SPBOOKING_TRANSPORT_AVAILABLE_IN'); ?>">
					<div class="range-icon"><span class="fa fa-calendar text-mute"></span></div>
					<input type="hidden" class="topbar-search-checkin" name="checkin" value="<?php echo $checkin; ?>" >
					<input type="hidden" class="topbar-search-checkout" name="checkout" value="<?php echo $checkout; ?>" >
				</div>

				<!-- search by price range -->
				<div class="content-price-range mt-20 spbooking-input-wrap spbooking-col-md-6 spbooking-col-lg-4 spbooking-ranger">
					<p class="price-range-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATIONS_FILTERING_PRICE_RANGE'); ?></p>
					<div id="price-range"></div>
					<input type="hidden" name="min-price" id="min-price" class="spbooking-ranger" value="<?php echo $min_price; ?>">
					<input type="hidden" name="max-price" id="max-price" class="spbooking-ranger" value="<?php echo $max_price; ?>">
				</div>

				<?php if (count((array) $features))
{
					// Facilities ?>
					<div class="spbooking-search-facilities spbooking-input-wrap spbooking-col-md-6 spbooking-col-lg-4 topbar-search-wrapper">
						<select name="feature" id="spbooking-filter-features" class="spbooking-select form-control filter-features">
							<option value="" <?php echo ($post_feature == '') ? 'selected' : ''; ?>><?php echo Text::_('COM_SPBOOKING_COMMON_SELECT_FEATURE'); ?></option>
							<?php
							foreach ($features as $key => $feature)
	{
								?>
								<?php $selected = ($post_feature == $key) ? 'selected' : ''; ?>
								<option value="<?php echo $key; ?>" <?php echo $selected; ?> ><?php echo $feature->key; ?></option>
							<?php } ?>
						</select>
					</div> <!-- //.spbooking-category-search -->
				<?php } ?>

				<?php if (count((array) $categories))
{
					// Tags ?>
					<div class="spbooking-search-tags spbooking-input-wrap spbooking-col-md-6 spbooking-col-lg-4 topbar-search-wrapper">
						<select name="category" id="spbooking-filter-tags" class="form-control spbooking-select filter-features">
							<option value="" <?php echo ($category_id == '') ? 'selected' : ''; ?>><?php echo Text::_('COM_SPBOOKING_COMMON_SELECT_CATEGORY'); ?></option>
							<?php
							foreach ($categories as $key => $category)
	{
								?>
								<?php $selected = ($category_id == $category->id) ? 'selected' : ''; ?>
								<option value="<?php echo $category->id; ?>" <?php echo $selected; ?> ><?php echo $category->title; ?></option>
							<?php } ?>
						</select>

					</div> <!-- //.spbooking-category-search -->
				<?php } ?>

				<div class="mt-10 button-wrap spbooking-input-wrap spbooking-col-sm-12">
					<button class="spbooking-btn spbooking-btn-primary topbar-filter-submit" type="submit"><?php echo Text::_('COM_SPBOOKING_ACCOMODATIONS_FILTERING_SEARCH_BTN'); ?></button>
					<a href="<?php echo Route::_('index.php?option=com_spbooking&view=transports' . SpbookingHelper::getItemId('transports')); ?>" class="spbooking-btn spbooking-btn-link"><?php echo Text::_('COM_SPBOOKING_RESET'); ?></a>
				</div>
			</div>
		</form>
	</aside>
</div>
