<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;


$place        = $displayData['place'];
$this->helper = new SpbookingHelper;
$showRating   = ComponentHelper::getParams('com_spbooking')->get('rating');
?>

<?php if (!empty($place))
{
	?>
<div class="spbooking-package">
	<div class="spbooking-package-img-wrap">
		<a href="<?php echo $place->url; ?>" class="full-link"></a>
		<?php
		if (!empty($place->image))
		{
			?>
		<img src="<?php echo $place->thumb; ?>" alt="">
		<?php } ?>
	</div>
	<div class="spbooking-package-info">

		<div class="spbooking-price-wrap spbooking-d-flex">
			<h3 class="title"><a href="<?php echo $place->url; ?>"><?php echo $place->title; ?></a></h3>
			<a href="<?php echo $place->url; ?>" class="spbooking-btn spbooking-btn-pirmary"><?php echo Text::_('COM_SPBOOKING_PACKAGE_VIEW'); ?></a>
		</div>
 
		<?php if ($showRating)
		{
			?>
		<div class="content-rating">
			<?php foreach (range(1, 5) as $index)
			{
				?>
				<?php if ($index <= $place->review['average_rating'])
				{
					?>
			<span class="fa fa-star is-filled"></span>
				<?php }
				elseif ($index > $place->review['average_rating'] && $place->review['average_rating'] > $index - 1)
			{
					?>
			<span class="fa fa-star-half-o is-filled"></span>
				<?php }
				else
			{
					?>
			<span class="fa fa-star-o"></span>
				<?php } ?>
			<?php } ?>
		</div>
		<?php } ?>
		

		<div class="spbooking-meta-data spbooking-d-flex text-mute">
			<?php if (!empty($place->category_id) && !empty($place->category_name))
	{
				?>
			<div class="place-category-name">
				<span><?php echo $place->category_name; ?></span>
			</div>
			<?php } ?>
			<?php
			if ((!empty($place->category_id) && !empty($place->category_name)) && (!empty($place->location) && $place->location))
	{
				?>
			<span>&nbsp;|&nbsp;</span>
			<?php } ?>
			<?php
			if (!empty($place->location) && $place->location)
	{
				?>
			<div class="place-location">
				<i class="fa fa-map-marker"></i>&nbsp;<span><?php echo $place->location; ?></span>
			</div>
			<?php } ?>
		</div> <!-- /.places-info-bottom -->

	</div> <!-- /.spbooking-layout-content -->
</div> <!-- /.spbooking-layout-component -->
<?php }
