<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Restricted Access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;


$accomodation_model = BaseDatabaseModel::getInstance('Accomodations', 'SpbookingModel');
$app            = Factory::getApplication();
$input          = $app->input;
$keyword        = $input->get('keyword', null, 'STRING');
$pid            = $input->get('place', '', 'INT');
$city           = $input->get('city', '', 'STRING');
$country        = $input->get('country', '', 'STRING');
$state	        = $input->get('state', '', 'STRING');

$search_keyword = '';

if (!empty($country))
{
	$search_keyword = base64_decode($country);
}

if (!empty($city))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo(base64_decode($city), 'city', 'place');
}

if (!empty($state))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo(base64_decode($state), 'state', 'place');
}

if (!empty($aid))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo($aid, 'aid', 'place');
}

// Attach documents
$doc = Factory::getDocument();
$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/topbar-search.js');

$doc->addScriptDeclaration("
    jQuery(function($){
        $('.spbooking-places-search').topSearch({
            topsearch_host : '" . Uri::root() . "',
            search_for: 'place'
        });
    });
"
);

$menuItemId = SpbookingHelper::getItemId('places');
$menuItemId = str_replace("&Itemid=", "", $menuItemId);

?>
<div class="spbooking-places-search">
	<!-- /.spbooking-places-filters-form -->
	<!-- id="topbar-filter-form spbooking-places-filters-form" -->
	<form id="topbar-filter-form" class="spbooking-places-filters-form" method="GET">
		<div class="reserve-box">
			<input type="hidden" name="option" value="com_spbooking">
			<input type="hidden" name="view" value="places">
			<input type="hidden" name="Itemid" value="<?php echo $menuItemId; ?>">
		</div>
		<h3 class=""><?php echo Text::_('COM_SPBOOKING_FILTER_CITY'); ?></h3>
		<div class="spbooking-d-flex">
			<!-- location search  -->
			<div class="spbooking-search-city-wrap spbooking-input-wrap">
				<div class="topbar-search-wrapper">
					<input type="text" class="form-control search-destination" placeholder="<?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_DESTINATION'); ?>" value="<?php echo $search_keyword; ?>">
					<ul class="topbar-search-result text-left"></ul>
					<div class="topbar-search-loading">
						<span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span>
					</div>
				</div>
				<input type="hidden" name="place" class="topbar-accomodation-input" value="<?php echo $pid; ?>">
				<input type="hidden" name="city" class="topbar-city-input" value="<?php echo $city?>">
				<input type="hidden" name="state" class="topbar-state-input" value="<?php echo $state?>">
				<input type="hidden" name="country" class="topbar-country-input" value="<?php echo $country?>">
			</div>
			<button class="spbooking-btn spbooking-btn-primary" type="submit"><?php echo Text::_('COM_SPBOOKING_ACCOMODATIONS_FILTERING_SEARCH_BTN'); ?></button>
		</div>   
	</form>
</div>

