<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

// Get query strings
$input      = Factory::getApplication()->input;
$accomodation_model = BaseDatabaseModel::getInstance('Accomodations', 'SpbookingModel');
$categories = SpbookingHelper::getCategory('package');

$aid        = $input->get('package', '', 'INT');
$city       = $input->get('city', '', 'STRING');
$country    = $input->get('country', '', 'STRING');
$state	    = $input->get('state', '', 'STRING');
$capacity   = $input->get('capacity', '', 'INT');
$category   = $input->get('category', '', 'INT');


$search_keyword = '';

if (!empty($country))
{
	$search_keyword = base64_decode($country);
}

if (!empty($city))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo(base64_decode($city), 'city', 'package');
}

if (!empty($state))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo(base64_decode($state), 'state', 'package');
}

if (!empty($aid))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo($aid, 'aid', 'package');
}




// Attach documents
$doc = Factory::getDocument();
$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/topbar-search.js');
$doc->addScriptDeclaration("
    jQuery(function($){
        $('.topbar-filter').topSearch({
            topsearch_host : '" . Uri::root() . "',
            search_for: 'package'
        });
    });
"
);

$menuItemId = SpbookingHelper::getItemId('packages');
$menuItemId = str_replace("&Itemid=", "", $menuItemId);
?>

<div class="topbar-filter">
	<h3><?php echo Text::_('COM_SPBOOKING_SEARCH_FIND_YOUR_ADVENTURE'); ?></h3>
	<form action="#" id="topbar-filter-form">
		<div class="reserve-box">
			<input type="hidden" name="option" value="com_spbooking">
			<input type="hidden" name="view" value="packages">
			<input type="hidden" name="Itemid" value="<?php echo $menuItemId; ?>">
		</div>
		<div class="spbooking-row">
			<div class="spbooking-col-md-12 spbooking-col-lg-4">
				<div class="form-groups">
					<!-- location search  -->
					<div class="topbar-search-wrapper">
						<input type="text" class="form-control search-destination" placeholder="<?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_DESTINATION'); ?>" value="<?php echo $search_keyword; ?>">
						<ul class="topbar-search-result"></ul>
						<div class="topbar-search-loading">
							<span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span>
						</div>
					</div>
					<input type="hidden" name="package" class="topbar-accomodation-input" value="<?php echo $aid; ?>">
					<input type="hidden" name="city" class="topbar-city-input" value="<?php echo $city?>">
					<input type="hidden" name="country" class="topbar-country-input" value="<?php echo $country?>">
					<input type="hidden" name="state" class="topbar-state-input" value="<?php echo $state?>">
				</div>
			</div>

			<div class="spbooking-col-md-6 spbooking-col-lg-4">
				<div class="form-groups">
					<!-- location search  -->
					<div class="topbar-search-wrapper">
						<input type="number" class="form-control search-capacity" name="capacity" placeholder="<?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_CAPACITY'); ?>" value="<?php echo $capacity; ?>">
					</div>
				</div>
			</div>

			<div class="spbooking-col-md-6 spbooking-col-lg-4">
				<div class="form-groups">
					<!-- location search  -->
					<div class="topbar-search-wrapper">
						<select class="form-control spbooking-select search-category" name="category" placeholder="<?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_CATEGORY'); ?>">
							<option value=""><?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_PACKAGE_SELECT_CATEGORY'); ?></option>
							<?php
							if (!empty($categories))
{
								?>
								<?php foreach ($categories as $cat)
	{
									?>
									<option value="<?php echo $cat->id; ?>" <?php echo $category == $cat->id ? 'selected' : ''; ?>><?php echo $cat->title; ?></option>
								<?php } ?>
							<?php } ?>
						</select>
					</div>
				</div>
			</div>
		</div>

		<div class="spbooking-row mt-10">
			<div class="spbooking-col-12 spbooking-col-md-6">
				<div class="form-groups">
					<div class="topbar-search-wrapper">
						<input class="form-control package-date-from" name="date_from" placeholder="<?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_DATE_FROM') ?>">
						<div class="range-icon"><span class="fa fa-calendar text-mute"></span></div>
					</div>
				</div>
			</div>
			<div class="spbooking-col-12 spbooking-col-md-6">
				<div class="form-groups">
					<div class="topbar-search-wrapper">
						<input class="form-control package-date-to" name="date_to" placeholder="<?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_DATE_TO') ?>">
						<div class="range-icon"><span class="fa fa-calendar text-mute"></span></div>
					</div>
				</div>
			</div>
		</div>
		<div class="mt-20">
			<button class="btn btn-success topbar-filter-submit" id="topbar-filter-submit" type="submit"><?php echo Text::_('COM_SPBOOKING_SUBMIT'); ?></button>
			<a href="<?php echo Route::_('index.php?option=com_spbooking&view=packages' . SpbookingHelper::getItemId('packages')); ?>" class="spbooking-btn spbooking-btn-link reset-button-x"><?php echo Text::_('COM_SPBOOKING_RESET'); ?></a>
		</div>
	</form>
</div>
