<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;

$package      = $displayData['package'];
$cparams      = ComponentHelper::getParams('com_spbooking');
$showRating   = $cparams->get('rating');
$this->helper = new SpbookingHelper;
?>

<?php if (!empty($package))
{
	?>
<div class="spbooking-package spbooking-d-flex">
	<div class="spbooking-package-img-wrap">
		<a href="<?php echo $package->url; ?>" class="full-link"></a>
		<?php
		if (!empty($package->image) && $package->image)
		{
			?>
		<img src="<?php echo $package->thumb; ?>" alt="<?php echo $package->title; ?>">
		<?php }?>
		<?php
		if (!empty($package->sale_price) && $package->sale_price < $package->price)
		{
			?>
		<del><?php echo SpbookingHelper::formatPrice($package->price, $package->currency, $package->currency_type, $package->currency_position); ?></del>
		<ins><?php echo SpbookingHelper::formatPrice($package->sale_price, $package->currency, $package->currency_type, $package->currency_position); ?></ins>
		<span class="person-tag">/ <?php echo Text::_('COM_SPBOOKING_PRICE_PER_PERSON'); ?></span>
		<?php }
		else
		{
			?>
			<?php if (!empty($package->price))
			{
				?>
		<ins><?php echo SpbookingHelper::formatPrice($package->price, $package->currency, $package->currency_type, $package->currency_position); ?></ins>
		<span class="person-tag">/ <?php echo Text::_('COM_SPBOOKING_PRICE_PER_PERSON'); ?></span>
			<?php } ?>
		<?php } ?>
		<ul class="package-tags">
			<?php if (!empty($package->featured))
			{
				?>
			<li><span><?php echo Text::_('COM_SPBOOKING_FEATURED_TEXT'); ?></span></li>
			<?php } ?>
		</ul>
	</div>

	<div class="spbooking-package-info">
		<div class="package-subinfo">
			<?php if ($showRating)
			{
				?>
			<div class="content-rating mt-10">
				<?php foreach (range(1, 5) as $index)
				{
					?>
					<?php if ($index <= $package->review['average_rating'])
					{
						?>
				<span class="fa fa-star is-filled"></span>
					<?php }
					elseif ($index > $package->review['average_rating'] && $package->review['average_rating'] > $index - 1)
					{
						?>
				<span class="fa fa-star-half-o is-filled"></span>
					<?php }
					else
					{
						?>
				<span class="fa fa-star-o"></span>
					<?php } ?>
				<?php } ?>
			</div>
			<?php } ?>
			
			<h3 class="title"><a href="<?php echo $package->url; ?>"><?php echo $package->title; ?></a></h3>

			<div class="spbooking-package-meta spbooking-d-flex">
				<?php if (!empty($package->location) && !empty($package->location))
				{
					?>
				<span>
					<i class="fa fa-map-marker"></i><?php echo $package->location; ?>
				</span>
				<?php }?>

				<?php if (!empty($package->start_date) && $package->start_date != '0000-00-00')
				{
					?>
				<span>
					<i class="fa fa-calendar"></i><?php echo date('dS M', strtotime($package->start_date)); ?>
					<?php
					if (!empty($package->end_date) && $package->end_date != '0000-00-00')
					{
						?>
					- <?php echo date('dS M', strtotime($package->end_date)); ?>
					<?php }?>
				</span>
				<?php }?>
			</div>
		</div>

		<div class="spbooking-price-wrap spbooking-d-flex">
			<span class="price">
				<small>
					<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_PRICE_FROM'); ?>
				</small>
				<?php if (!empty((int) $package->sale_price) && (int) $package->sale_price < (int) $package->price)
				{
					?>
				<del><?php echo SpbookingHelper::formatPrice($package->price, $package->currency, $package->currency_type, $package->currency_position); ?></del>
				<ins><?php echo SpbookingHelper::formatPrice($package->sale_price, $package->currency, $package->currency_type, $package->currency_position); ?></ins>
				<span class="person-tag">/ <?php echo Text::_('COM_SPBOOKING_PRICE_PER_PERSON'); ?></span>
				<?php }
				else
				{
					?>
					<?php if (!empty((int) $package->price))
					{
						?>
				<ins><?php echo SpbookingHelper::formatPrice($package->price, $package->currency, $package->currency_type, $package->currency_position); ?></ins>
				<span class="person-tag">/ <?php echo Text::_('COM_SPBOOKING_PRICE_PER_PERSON'); ?></span>
					<?php } ?>
				<?php } ?>
			</span>
			<a href="<?php echo $package->url; ?>" class="spbooking-btn spbooking-btn-pirmary"><?php echo Text::_('COM_SPBOOKING_PACKAGE_VIEW'); ?></a>
		</div>
	</div>
</div>
<?php }
