<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

// Get query strings
$input      = Factory::getApplication()->input;
$accomodation_model = BaseDatabaseModel::getInstance('Accomodations', 'SpbookingModel');

$aid        = $input->get('accomodation', '', 'INT');
$city       = $input->get('city', '', 'STRING');
$country    = $input->get('country', '', 'STRING');
$state	    = $input->get('state', '', 'STRING');
$checkin    = $input->get('checkin', '', 'STRING');
$checkout   = $input->get('checkout', '', 'STRING');
$rooms      = $input->get('rooms', 1, 'INT');
$adult      = $input->get('adult', 1, 'INT');
$child      = $input->get('child', 0, 'INT');

$search_keyword = '';

if (!empty($country))
{
	$search_keyword = base64_decode($country);
}

if (!empty($city))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo(base64_decode($city), 'city');
}

if (!empty($state))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo(base64_decode($state), 'state');
}

if (!empty($aid))
{
	$search_keyword = $accomodation_model->getKeywordSearchInfo($aid, 'aid');
}

// Attach documents
$doc = Factory::getDocument();
$doc->addScript(Uri::root() . 'components/com_spbooking/assets/js/topbar-search.js');
$doc->addScriptDeclaration("
    jQuery(function($){
        $('.topbar-filter').topSearch({
            topsearch_host : '" . Uri::root() . "',
            checkin: '" . $checkin . "',
            checkout: '" . $checkout . "'

        });
    });
"
);

$menuItemId = SpbookingHelper::getItemId('accomodations');
$menuItemId = str_replace("&Itemid=", "", $menuItemId);
?>

<div class="topbar-filter">
	<h3><?php echo Text::_('COM_SPBOOKING_SEARCH_FIND_YOUR_ADVENTURE'); ?></h3>
	<form action="#" id="topbar-filter-form">
		<div class="form-inlines row">

			<div class="reserve-box">
				<input type="hidden" name="option" value="com_spbooking">
				<input type="hidden" name="view" value="accomodations">
				<input type="hidden" name="Itemid" value="<?php echo $menuItemId; ?>">
			</div>

		  <div class="spbooking-col-md-12 spbooking-col-lg-4">
			<div class="form-groups">
				<!-- location search  -->
				<div class="topbar-search-wrapper">
					<input type="text" class="form-control search-destination" placeholder="<?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_DESTINATION'); ?>" value="<?php echo $search_keyword; ?>">
					<ul class="topbar-search-result"></ul>
					<div class="topbar-search-loading">
						<span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span>
					</div>
				</div>
				<input type="hidden" name="accomodation" class="topbar-accomodation-input" value="<?php echo $aid; ?>">
				<input type="hidden" name="city" class="topbar-city-input" value="<?php echo $city?>">
				<input type="hidden" name="country" class="topbar-country-input" value="<?php echo $country?>">
				<input type="hidden" name="state" class="topbar-state-input" value="<?php echo $state?>">
			  </div>
			</div>
			<div class="spbooking-col-md-6 spbooking-col-lg-4">

			<div class="topbar-range">
				<input type="text" class="form-control topbar-checkin-out-range" placeholder="<?php echo Text::_('COM_SPBOOKING_TOPBAR_SEARCH_CHECKIN_OUT'); ?>">
				<div class="range-icon"><span class="fa fa-calendar text-mute"></span></div>
				<input type="hidden" class="topbar-search-checkin" name="checkin" value="<?php echo $checkin; ?>">
				<input type="hidden" class="topbar-search-checkout" name="checkout" value="<?php echo $checkout; ?>">
			  </div>
			</div>
			<div class="spbooking-col-md-6 spbooking-col-lg-4">

			<div class="form-groups">
				<div class="topbar-search-person-wrapper">
					<div class="toggle-person-info"><?php echo $rooms . ' ' . SpbookingHelper::pluralize($rooms, 'COM_SPBOOKING_ROOM', 'COM_SPBOOKING_ROOMS') . ', ' . $adult . ' ' . SpbookingHelper::pluralize($adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS') . ', ' . $child . ' ' . SpbookingHelper::pluralize($child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?></div>
					<div class="person-caret"><span class="fa fa-caret-down"></span></div>
					<div class="person-container">
						<div class="topbar-btn-group">
							<div class="person-info-left">
								<span class="person-room-title"><?php echo Text::_('COM_SPBOOKING_ROOMS'); ?></span>
							</div>
							<div class="person-info-right">
								<button class="btn btn-danger btn-xs btn-minus" ><span class="fa fa-minus"></span></button>
								<span class="value value-holder is-room" data-min="1" data-val='<?php echo $rooms; ?>' data-singular="<?php echo Text::_('COM_SPBOOKING_ROOM'); ?>" data-plural="<?php echo Text::_('COM_SPBOOKING_ROOMS'); ?>" data-info="<?php echo $rooms . ' ' . SpbookingHelper::pluralize($rooms, 'COM_SPBOOKING_ROOM', 'COM_SPBOOKING_ROOMS'); ?>"><?php echo $rooms; ?></span>
								<button class="btn btn-success btn-xs btn-plus"><span class="fa fa-plus"></span></button>
								<input type="hidden" name="rooms" class="topbar-search-rooms" value="<?php echo $rooms; ?>">
							</div>
						</div>
						<div class="topbar-btn-group">
							<div class="person-info-left">
								<span class="person-room-title"><?php echo Text::_('COM_SPBOOKING_ADULTS'); ?></span>
							</div>
							<div class="person-info-right">
								<button class="btn btn-danger btn-xs btn-minus"><span class="fa fa-minus"></span></button>
								<span class="value value-holder is-adult" data-min="1" data-val='<?php echo $adult; ?>' data-singular="<?php echo Text::_('COM_SPBOOKING_ADULT'); ?>" data-plural="<?php echo Text::_('COM_SPBOOKING_ADULTS'); ?>" data-info="<?php echo $adult . ' ' . SpbookingHelper::pluralize($adult, 'COM_SPBOOKING_ADULT', 'COM_SPBOOKING_ADULTS'); ?>"><?php echo $adult; ?></span>
								<button class="btn btn-success btn-xs btn-plus"><span class="fa fa-plus"></span></button>
								<input type="hidden" name="adult" class="topbar-search-adults" value="<?php echo $adult; ?>">
							</div>
						</div>
						<div class="topbar-btn-group">
							<div class="person-info-left">
								<span class="person-room-title"><?php echo Text::_('COM_SPBOOKING_CHILDREN'); ?></span>
							</div>
							<div class="person-info-right">
								<button class="btn btn-danger btn-xs btn-minus"><span class="fa fa-minus"></span></button>
								<span class="value value-holder is-child" data-min="0" data-val='<?php echo $child; ?>' data-singular="<?php echo Text::_('COM_SPBOOKING_CHILD'); ?>" data-plural="<?php echo Text::_('COM_SPBOOKING_CHILDREN'); ?>" data-info="<?php echo $child . ' ' . SpbookingHelper::pluralize($child, 'COM_SPBOOKING_CHILD', 'COM_SPBOOKING_CHILDREN'); ?>"><?php echo $child; ?> </span>
								<button class="btn btn-success btn-xs btn-plus"><span class="fa fa-plus"></span></button>
								<input type="hidden" name="child" class="topbar-search-children" value="<?php echo $child; ?>">
							</div>
						</div>
					</div>
				</div>
			  </div>
			</div>
		</div>
		<button class="btn btn-success topbar-filter-submit" id="topbar-filter-submit" type="submit"><?php echo Text::_('COM_SPBOOKING_SUBMIT'); ?></button>
		<a href="<?php echo Route::_('index.php?option=com_spbooking&view=accomodations' . SpbookingHelper::getItemId('accomodations')); ?>" class="spbooking-btn spbooking-btn-link reset-button"><?php echo Text::_('COM_SPBOOKING_RESET'); ?></a>
	</form>
</div>
