<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;

$accomodation = $displayData['accomodation'];
$cparams      = ComponentHelper::getParams('com_spbooking');
$showRating   = $cparams->get('rating');

?>

<?php if (!empty($accomodation))
{
	?>
<div class="spbooking-package spbooking-d-flex">
	<div class="spbooking-package-img-wrap">
		<a href="<?php echo $accomodation->url; ?>" class="full-link"></a>
		<img src="<?php echo $accomodation->thumb; ?>" alt="">
		<?php
		if (!empty($accomodation->save_money))
	{
			?>
		<div class="spbooking-package-discount">
			<span><?php echo Text::_('COM_SPBOOKING_COMMON_SAVE'); ?></span>
			<span class="only-price"><?php echo SpbookingHelper::formatPrice($accomodation->save_money, $accomodation->currency, 'short', 'right'); ?></span>
		</div>
		<?php } ?>
		<ul class="package-tags">
			<?php if (!empty($accomodation->featured))
	{
				?>
			<li><span><?php echo Text::_('COM_SPBOOKING_FEATURED_TEXT'); ?></span></li>
			<?php } ?>
			<!-- <li><span>new</span></li> -->
		</ul>
	</div>
	<div class="spbooking-package-info">
		<div class="package-subinfo">
			<?php if ($showRating)
	{
				?>
			<div class="content-rating mt-10">
				<?php foreach (range(1, 5) as $index)
		{
					?>
					<?php if ($index <= $accomodation->review['average_rating'])
			{
						?>
				<span class="fa fa-star is-filled"></span>
					<?php }
					elseif ($index > $accomodation->review['average_rating'] && $accomodation->review['average_rating'] > $index - 1)
			{
						?>
				<span class="fa fa-star-half-o is-filled"></span>
					<?php }
					else
			{
						?>
				<span class="fa fa-star-o"></span>
					<?php } ?>
				<?php } ?>
			</div>
			<?php } ?>

			<h3 class="title"><a href="<?php echo $accomodation->url; ?>"><?php echo $accomodation->title; ?></a></h3>

			<?php if (!empty($accomodation->city) && !empty($accomodation->country))
	{
				?>
			<div class="content-location">
				<span class="text-mute"><?php echo $accomodation->city . ', ' . $accomodation->country; ?></span>
			</div>
			<?php } ?>

			<?php if (!empty($accomodation->landmark))
	{
				?>
			<div class="content-distance">
				<span><?php echo $accomodation->landmark; ?></span>
			</div>
			<?php } ?>
		</div>

		<div class="spbooking-price-wrap spbooking-d-flex">
			<?php if (!empty($accomodation->price_from))
	{
				?>
			<span class="price">
				<small>
					<?php echo Text::_('COM_SPBOOKING_ACCOMODATION_PRICE_FROM'); ?>
				</small>
				<span><?php echo SpbookingHelper::formatPrice($accomodation->price_from, $accomodation->currency, $accomodation->currency_type, $accomodation->currency_position, false, 2); ?></span>
				<span class="person-tag">
					/ <?php echo Text::_('COM_SPBOOKING_COMMON_NIGHT'); ?>
				</span>
			</span>
			<?php } ?>
			<a href="<?php echo $accomodation->url; ?>" class="spbooking-btn spbooking-btn-pirmary"><?php echo Text::_('COM_SPBOOKING_HOTEL_VIEW'); ?></a>
		</div>
	</div>
</div>
<?php }
