<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;

$menuItemId = $displayData['menuItemId'];
$facilities = $displayData['facilities'];
$tags       = $displayData['tags'];

$input          = Factory::getApplication()->input;
$view_style     = $input->get('view_style', 'grid', 'WORD');
$destination    = $input->get('destination', '', 'STRING');
$features       = $input->get('facilities', '', 'STRING');
$min_price      = $input->get('min-price', null, 'INT');
$max_price      = $input->get('max-price', null, 'INT');

if (!empty($features))
{
	$features = explode(',', $features);
}

$labels = $input->get('tags', '', 'STRING');

if (!empty($labels))
{
	$labels = explode(',', $labels);
}

$doc = Factory::getDocument();
$doc->addScript(Uri::root(true) . '/components/com_spbooking/assets/js/jquery.nicescroll.min.js');

?>
<aside class="spbooking-sidebar accomodation-filtering ">
	<!-- accomodation filtering form -->
	<form action="#" id="accomodation-filtering-form">
		<div class="reserve-box">
			<input type="hidden" name="option" value="com_spbooking">
			<input type="hidden" name="view" value="accomodations">
		</div>

		<!-- search by price range -->
		<div class="content-price-range mt-10 spbooking-input-wrap spbooking-ranger">
			<p class="price-range-title is-uppercase"><?php echo Text::_('COM_SPBOOKING_ACCOMODATIONS_FILTERING_PRICE_RANGE'); ?></p>
			<div id="price-range"></div>
			<input type="hidden" id="min-price" class="spbooking-ranger" name="min-price" value="<?php echo $min_price; ?>">
			<input type="hidden" id="max-price" class="spbooking-ranger" name="max-price" value="<?php echo $max_price; ?>">
		</div>

		<?php if (!empty($facilities))
		{
			?>
			<!-- search by facilities -->
			<div class="content-filter-facilities spbooking-input-wrap mt-10">
				<h4><?php echo Text::_('COM_SPBOOKING_PACKAGES_FILTER_FACILITIES'); ?></h4>
				<ul class="nicescrol">
					<?php foreach ($facilities as $key => $facility)
					{
						?>
						<li class="checkbox">
							<label class="custom-checkbox">
								<input type="checkbox" name="facilities[]" <?php echo (!empty($features) && in_array($facility->id, $features) ? 'checked' : ''); ?> value="<?php echo $facility->id; ?>">
								<span class="checkmark"><?php echo $facility->title; ?></span>
							</label>
						</li>
					<?php } ?>
				</ul>
			</div>
		<?php } ?>
		
		<?php if (!empty($tags))
		{
			?>
			<!-- search by tags -->
			<div class="content-filter-tags spbooking-input-wrap mt-10">
				<h4><?php echo Text::_('COM_SPBOOKING_PACKAGES_FILTER_TAGS'); ?></h4>
				<ul class="nicescrol">
					<?php foreach ($tags as $key => $tag)
					{
						?>
						<li class="checkbox">
							<label class="custom-checkbox">
								<input type="checkbox" name="tags[]" <?php echo (!empty($labels) && in_array($tag->id, $labels) ? 'checked' : ''); ?> value="<?php echo $tag->id; ?>">
								<span class="checkmark"><?php echo $tag->title; ?></span>
							</label>
						</li>
					<?php } ?>
				</ul>
			</div>
		<?php } ?>

		<input type="hidden" name="view_style" value="<?php echo $view_style; ?>">
		<input type="hidden" name="Itemid" value="<?php echo str_replace('&Itemid=', '', $menuItemId); ?>">
		<div class="mt-10 spbooking-input-wrap">
			<button class="spbooking-btn spbooking-btn-primary" type="submit"><?php echo Text::_('COM_SPBOOKING_ACCOMODATIONS_FILTERING_SEARCH_BTN'); ?></button>
			<a href="<?php echo Route::_('index.php?option=com_spbooking&view=accomodations' . $menuItemId); ?>" class="spbooking-btn spbooking-btn-link reset-button"><?php echo Text::_('COM_SPBOOKING_RESET'); ?></a>
		</div>
	</form>
</aside>
