<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

class SpbookingRouterRulesLegacy implements JComponentRouterRulesInterface
{

	public function __construct($router)
	{
		$this->router = $router;
	}

	public function preprocess(&$query)
	{
	}

	private function getAlias($id, $tbl)
	{
		$db = JFactory::getDbo();
		$dbQuery = $db->getQuery(true)
			->select('alias')
			->from($db->qn($tbl))
			->where($db->qn('id') . ' = ' . (int) $id);
		$db->setQuery($dbQuery);
		$alias = $db->loadResult();
		$id = $id . ':' . $alias;

		return $id;
	}

	private function predictAliasIdCombination($id, $tbl, $pk = 'id')
	{
		$db = JFactory::getDbo();
		$dbq = $db->getQuery(true);
		$dbq->select('id, alias, title')
			->from($db->qn($tbl))
			->where($db->qn($pk) . ' = ' . $db->q($id));
		$db->setQuery($dbq);
		$result = $db->loadObject();

		return $result;
	}

	public function build(&$query, &$segments)
	{
		$params 	= JComponentHelper::getParams('com_spbooking');
		$advanced 	= $params->get('sef_advanced_link', 0);

		if (empty($query['Itemid']))
		{
			$menuItem 	    = $this->router->menu->getActive();
			$menuItemGiven  = false;
		}
		else
		{
			$menuItem 		= $this->router->menu->getItem($query['Itemid']);
			$menuItemGiven = true;
		}

		// Check again
		if ($menuItemGiven && isset($menuItem) && $menuItem->component != 'com_spbooking')
		{
			$menuItemGiven = false;
			unset($query['Itemid']);
		}

		if (isset($query['view']))
		{
			$view = $query['view'];
		}
		else
		{
			// We need to have a view in the query or it is an invalid URL
			return;
		}

		if ($menuItem !== null
			&& isset($menuItem->query['view'], $query['view'], $menuItem->query['id'], $query['id'])
			&& $menuItem->query['view'] == $query['view']
			&& $menuItem->query['id'] == (int) $query['id'])
		{
			unset($query['view']);

			if (isset($query['layout']))
			{
				unset($query['layout']);
			}

			unset($query['id']);

			return;
		}

		if ($view == 'accomodations' || $view == 'transports' || $view == 'packages' || $view == 'places')
		{
			unset($query['view']);
		}

		if ($view == 'accomodation')
		{
			if (!$menuItemGiven)
			{
				$segments[] = $view;
			}

			unset($query['view']);

			if (isset($query['id']))
			{
				if (strpos($query['id'], ':') === false)
				{
					$query['id'] = $this->getAlias($query['id'], '#__spbooking_accomodations');
				}
			}
			else
			{
				return;
			}

			$segments[] = $query['id'];
			unset($query['id']);
		}
		elseif ($view == 'package')
		{
			if (!$menuItemGiven)
			{
				$segments[] = $view;
			}

			unset($query['view']);

			if (isset($query['id']))
			{
				if (strpos($query['id'], ':') === false)
				{
					$query['id'] = $this->getAlias($query['id'], '#__spbooking_packages');
				}
			}
			else
			{
				return;
			}

			$segments[] = $query['id'];
			unset($query['id']);
		}
		elseif ($view == 'transport')
		{
			if (!$menuItemGiven)
			{
				$segments[] = $view;
			}

			unset($query['view']);

			if (isset($query['id']))
			{
				if (strpos($query['id'], ':') === false)
				{
					$query['id'] = $this->getAlias($query['id'], '#__spbooking_transports');
				}
			}
			else
			{
				return;
			}

			$segments[] = $query['id'];
			unset($query['id']);
		}
		elseif ($view == 'place')
		{
			if (!$menuItemGiven)
			{
				$segments[] = $view;
			}

			unset($query['view']);

			if (isset($query['id']))
			{
				if (strpos($query['id'], ':') === false)
				{
					$query['id'] = $this->getAlias($query['id'], '#__spbooking_places');
				}
			}
			else
			{
				return;
			}

			$segments[] = $query['id'];
			unset($query['id']);
		}
		elseif ($view == 'invoice')
		{
			if (!$menuItemGiven)
			{
				$segments[] = $view;
			}

			unset($query['view']);
			$segments[] = $query['id'];
			unset($query['id']);
		}

		foreach ($segments as $i => &$segment)
		{
			$segment = str_replace(':', '-', $segment);
		}
	}

	public function parse(&$segments, &$vars)
	{
		$total = count($segments);

		for ($i = 0; $i < $total; $i++)
		{
			$segments[$i] = preg_replace('/-/', ':', $segments[$i], 1);
		}

		// Get the active menu item.
		$item 		= $this->router->menu->getActive();
		$params 	= JComponentHelper::getParams('com_spbooking');
		$advanced 	= $params->get('sef_advanced_link', 0);
		$db 		= JFactory::getDbo();

		// Count route segments
		$count = count($segments);

		if (!isset($item))
		{
			$vars['view'] 	= $segments[0];
			$vars['id']	= $segments[$count - 1];

			return;
		}

		if ($count > 1)
		{
			$vars['view'] = $segments[0];
			$vars['id'] = (int) $segments[1];
		}
		elseif ($count == 1)
		{
			if (strpos($segments[0], ':') !== false)
			{
				list($id, $alias) = explode(':', $segments[0], 2);
				$accomodation = $this->predictAliasIdCombination($id, '#__spbooking_accomodations', 'id');
				$package = $this->predictAliasIdCombination($id, '#__spbooking_packages', 'id');
				$transport = $this->predictAliasIdCombination($id, '#__spbooking_transports', 'id');
				$place = $this->predictAliasIdCombination($id, '#__spbooking_places', 'id');
			}

			if (!empty($accomodation) && $accomodation->alias == $alias)
			{
				$vars['view'] = 'accomodation';
				$vars['id'] = $id;
			}
			elseif (!empty($package) && $package->alias == $alias)
			{
				$vars['view'] = 'package';
				$vars['id'] = $id;
			}
			elseif (!empty($transport) && $transport->alias == $alias)
			{
						$vars['view'] = 'transport';
						$vars['id'] = $id;
			}
			elseif (!empty($place) && $place->alias == $alias)
			{
						$vars['view'] = 'place';
						$vars['id'] = $id;
			}
			else
			{
						$vars['view'] = 'invoice';
						$vars['id'] = (int) $segments[0];
			}
		}
		else
		{
			return;
		}
	}
}

