<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\FormController;

class SpbookingControllerTransports extends FormController
{

	public function __construct($config = array())
	{
		parent::__construct($config);
	}

	public function getKeywordSearch()
	{
		$output 	= array();
		$input 		= Factory::getApplication()->input;
		$keyword 	= $input->get('keyword', '', 'STRING');
		$limit 		= $input->get('limit', 5, 'INT');

		// Search by keyword from accomodation title
		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.id, a.title, a.city, a.country, a.state')->from($db->quoteName('#__spbooking_transports', 'a'))
			->where($db->quoteName('a.title') . ' REGEXP ' . $db->quote($keyword))
			->where($db->quoteName('a.published') . ' = 1')
			->order($db->quoteName('a.title') . ' ASC');

		$query->setLimit($limit);
		$db->setQuery($query);
		$packages = $db->loadObjectList();
		unset($db, $query);

		if (!empty($packages))
		{
			foreach ($packages as $v)
			{
				$output[] = "<li class='topbar-search-result-item' data-restype='transport' data-content='" .
				$v->id . "' ><p><strong>" . $v->title . "</strong>, " . $v->city . ", " . $v->country . "</p></li>";
			}
		}

		// Search by keyword from city
		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.id, a.city, a.country, a.state')->from($db->quoteName('#__spbooking_transports', 'a'))
			->where($db->quoteName('a.city') . ' REGEXP ' . $db->quote($keyword))
			->where($db->quoteName('a.published') . ' = 1')
			->group($db->quoteName('a.city'))
			->order($db->quoteName('a.city') . ' ASC');

		$query->setLimit($limit);

		$db->setQuery($query);

		$cities = $db->loadObjectList();
		unset($db, $query);

		if (!empty($cities))
		{
			foreach ($cities as $city)
			{
				$output[] = "<li class='topbar-search-result-item' data-restype='city' data-content='" . base64_encode($city->city) . "'><p><strong>" . $city->city . "</strong>, " . $city->country . "</p>";
			}
		}

		// Search by keyword from states
		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		$query->select('a.id, a.city, a.country, a.state')->from($db->quoteName('#__spbooking_transports', 'a'))
			->where($db->quoteName('a.state') . ' REGEXP ' . $db->quote($keyword))
			->where($db->quoteName('a.published') . ' = 1')
			->group($db->quoteName('a.state'))
			->order($db->quoteName('a.state') . ' ASC');

		$query->setLimit($limit);

		$db->setQuery($query);

		$states = $db->loadObjectList();
		unset($db, $query);

		if (!empty($states))
		{
			foreach ($states as $state)
			{
				$output[] = "<li class='topbar-search-result-item' data-restype='state' data-content='" . base64_encode($state->state) . "'><p><strong>" . $state->state . "</strong>, " . $state->country . "</p>";
			}
		}

		// Search by keyword from country name
		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('a.id, a.country')
			->from($db->quoteName('#__spbooking_transports', 'a'))
			->where($db->quoteName('a.country') . ' REGEXP ' . $db->quote($keyword))
			->where($db->quoteName('a.published') . ' = 1')
			->group($db->quoteName('a.country'))
			->order($db->quoteName('a.country') . ' ASC');

		$query->setLimit($limit);

		$db->setQuery($query);
		$countries = $db->loadObjectList();
		unset($db, $query);

		if (!empty($countries))
		{
			foreach ($countries as $country)
			{
				$output[] = "<li class='topbar-search-result-item' data-restype='country' data-content='" . base64_encode($country->country) . "'><p><strong>" . $country->country . "</strong></p>";
			}
		}

		$result = array();

		if (!empty($output) && count($output) > $limit)
		{
			for ($i = 0; $i < $limit; $i++)
			{
				$result[] = $output[$i];
			}
		}
		else
		{
			$result = $output;
		}

		echo implode("\n", $result);
		die();
	}
}

