<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\MVC\Controller\FormController;

class SpbookingControllerCheckout extends FormController
{

	public function getModel($name = 'Checkout', $prefix = 'SpbookingController', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);

		return $model;
	}

	public function verifyEmail()
	{
		$app = Factory::getApplication();
		$input  = $app->input;
		$email = $input->get('email', '', 'STRING');
		$token = $input->get('token', '', 'STRING');
		$return = $input->get('return', '', 'STRING');
		$today = strtotime(date('Y-m-d'));

		if (!empty($email) && !empty($token) && !empty($return))
		{
			$token = base64_decode($token);
			$return = base64_decode($return);

			// Retrieve required data
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->select('id, checkin, created')->from($db->quoteName('#__spbooking_bookings'))
				->where($db->quoteName('booked_id') . ' = ' . $db->quote($token))
				->where($db->quoteName('email') . ' = ' . $db->quote($email))
				->where($db->quoteName('booking_status') . ' = ' . $db->quote('invalid'));

			$db->setQuery($query);
			$result = $db->loadObject();
			unset($db, $query);

			if (!empty($result))
			{
				$checkin = strtotime($result->checkin);

				if ($today > $checkin)
				{
					$app->enqueueMessage(Text::_('COM_SPBOOKING_EXPIRE_DATE_MESSAGE'), 'error');
				}
				else
				{
					// Change booking status from 'invalid' to 'in_approve'
					try
					{
						$db = Factory::getDbo();
						$query = $db->getQuery(true);
						$fields = array($db->quoteName('booking_status') . ' = ' . $db->quote('in_approve'));
						$conditions = array(
							$db->quoteName('booked_id') . ' = ' . $db->quote($token),
							$db->quoteName('email') . ' = ' . $db->quote($email),
							$db->quoteName('published') . ' = 1'
						);

						$query->update($db->quoteName('#__spbooking_bookings'))
							->set($fields)
							->where($conditions);

						$db->setQuery($query);
						$db->execute();
						$app->enqueueMessage(Text::_('COM_SPBOOKING_THANKS_MESSAGE'));
						$app->redirect(JUri::root() . $return, 301);
					}
					catch (Exception $e)
					{
						$app->enqueueMessage($e->getMessage(), 'error');
					}
				}
			}
			else
			{
				$app->enqueueMessage(Text::_('COM_SPBOOKING_ERROR_MSG_INVALID_VALIDATION_REQUEST'), 'error');
			}
		}
		else
		{
			$app->enqueueMessage(Text::_('COM_SPBOOKING_ERROR_MSG_INVALID_VALIDATION_URL'), 'error');
		}
	}

	public function submitBookingDataForRooms()
	{
		$input      = Factory::getApplication()->input->post;
		$user       = Factory::getUser();
		$chk_model  = BaseDatabaseModel::getInstance('Checkout', 'SpbookingModel');
		$output = array();
		$first_name         = $input->get('first_name', '', 'STRING');
		$last_name          = $input->get('last_name', '', 'STRING');
		$email              = $input->get('email', '', 'STRING');
		$phone              = $input->get('phone', '', 'STRING');
		$customer_comment   = $input->get('customer_comment', '', 'STRING');
		$customer_address   = $input->get('customer_address', '', 'STRING');
		$booking_for        = $input->get('booking_for', '', 'STRING');
		$room_id            = $input->get('room_id', '', 'STRING');
		$number_of_rooms    = $input->get('number_of_rooms', '', 'STRING');
		$checkin            = $input->get('checkin', '', 'STRING');
		$checkout           = $input->get('checkout', '', 'STRING');
		$cartData           = $input->get('cartData', '', 'STRING');
		$tax                = $input->get('tax', '', 'INT');
		$booked_id          = date('ymdhis') . rand(1000, 9999);
		$name               = $first_name . ' ' . $last_name;
		$created            = date('Y-m-d H:i:s');
		$txn_id             = '';
		$accomodation_id    = $input->get('accomodation_id', '', 'INT');
		$additionalServices = $input->get('additionalServices', '', 'ARRAY');
		$accomodation_info  = $chk_model->getAccomodationInfo($accomodation_id);
		$return_url         = "index.php?option=com_spbooking&view=payment&payment_for=accomodation&accomodation_id=" . $accomodation_id . "&booking_id=" . $booked_id;
		$verification_url   = "index.php?option=com_spbooking&view=checkout&task=checkout.verifyEmail";

		$checkin = date('Y-m-d', strtotime($checkin));
		$checkout = date('Y-m-d', strtotime($checkout));

		// Inserting Additional Services to cartData
		$cartData = (isset($additionalServices) && $additionalServices) ? self::addServiceToCart($additionalServices, $cartData, $chk_model) : $cartData;

		$cParams = ComponentHelper::getParams('com_spbooking');
		$config = Factory::getConfig();
		$sender = array($config->get('mailfrom', 'install@install.com'), $config->get('fromname', 'travus'));

		$booking_status     = 'invalid';

		if ($user->id > 0)
		{
			$booking_status = 'in_approve';
		}

		$fields = array('booked_id', 'booking_for', 'checkin', 'checkout','number_of_rooms', 'room_id', 'name', 'email', 'phone', 'comment', 'address',  'booking_status', 'created', 'published','user_id', 'cartData', 'accomodation_id', 'txn_id','tax');
		$values = array($booked_id, $booking_for, $checkin, $checkout, $number_of_rooms, $room_id, $name, $email, $phone, $customer_comment, $customer_address, $booking_status, $created, 1, $user->id, $cartData, $accomodation_id, $txn_id, $tax);

		try
		{
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->insert($db->quoteName('#__spbooking_bookings'))
				->columns($db->quoteName($fields))
				->values(implode(',', $db->quote($values)));
			$db->setQuery($query);
			$db->execute();
			$inserted_id = $db->insertid();
		}
		catch (Exception $e)
		{
			$output['content'] = Text::_('COM_SPBOOKING_ERROR_OCCUR_SENDING_EMAIL');
			$output['status_code'] = 400;
		}

		// Sent 'New Order' mail to admin.
		$emailData = array(
			"order_id" => $inserted_id,
			"booking_type" => $booking_for,
			'user_name' => $first_name . ' ' . $last_name,
			"user_email" => $email,
			"phone" => $phone
		);
		$message = self::sendNewOrderMail($emailData);

		if ($user->id > 0)
		{
			$output['status_code'] = 202;
			$output['content'] = Uri::root() . $return_url;
			$output['message'] = Text::_('COM_SPBOOKING_THANKS_MESSAGE') . $message;
			echo json_encode($output);
			die();
		}
		else
		{
			// If mail sent to user then store the data to the database
			$mailer = Factory::getMailer();

			$subject = Text::sprintf('COM_SPBOOKING_VARIFICATION_MAIL_SUBJECT', $accomodation_info->title);

			$start = new DateTime($checkin);
			$end = new DateTime($checkout);
			$diff = $end->diff($start);
			$days = 0;

			if (!empty($diff))
			{
				$days = $diff->days;
			}

			$confirm_url = Uri::root() . $verification_url . '&email=' . $email . '&token=' . base64_encode($booked_id) . '&return=' . base64_encode($return_url);

			$body = $cParams->get('verification_mail_template', '');
			$body = nl2br($body);

			$body = str_replace("{name}", $name, $body);
			$body = str_replace("{item_title}", "<strong>" . $accomodation_info->title . "</strong>", $body);
			$body = str_replace("{days}", $days, $body);
			$body = str_replace("{checkin}", $checkin, $body);
			$body = str_replace("{checkout}", $checkout, $body);
			$body = str_replace("{order_id}", $booked_id, $body);
			$body = str_replace("{confirm_link}", "<p><a class='spbooking-btn spbooking-btn-primary' href='" . $confirm_url . "'>Confirm Booking</a></p>", $body);
			$body = str_replace("{site_name}", "<p>" . $config->get('fromname', 'travus') . "</p>", $body);

			$mailer->setSender($sender);
			$mailer->addRecipient(trim($email));
			$mailer->setSubject($subject);
			$mailer->isHTML(true);
			$mailer->Encoding = 'base64';
			$mailer->setBody($body);

			// Send email
			if ($mailer->Send())
			{
				$output['content'] = Text::sprintf('COM_SPBOOKING_AN_EMAIL_HAS_BEEN_SENT', $email);
				$output['status_code'] = 200;
			}
			else
			{
				$output['content'] = Text::_('COM_SPBOOKING_ERROR_OCCUR_SENDING_EMAIL');
				$output['status_code'] = 400;
				echo json_encode($output);
				die();
			}
		}

		echo json_encode($output);
		die();
	}

	public function submitPackageCheckoutForm()
	{
		$input  = Factory::getApplication()->input->post;
		$user   = Factory::getUser();
		$app    = Factory::getApplication();
		$chk_model = BaseDatabaseModel::getInstance('Checkout', 'SpbookingModel');
		$output = array();

		$first_name         = $input->get('first_name', '', 'STRING');
		$last_name          = $input->get('last_name', '', 'STRING');
		$email              = $input->get('email', '', 'STRING');
		$phone              = $input->get('phone', '', 'STRING');
		$customer_address   = $input->get('customer_address', '', 'STRING');
		$adult              = $input->get('adult', '', 'STRING');
		$child              = $input->get('child', '', 'STRING');
		$pickup_location    = $input->get('pickup_location', '', 'STRING');
		$pickup_date        = $input->get('pickup_date', '', 'STRING');
		$pickup_time        = $input->get('pickup_time', '', 'STRING');
		$dropoff_location   = $input->get('dropoff_location', '', 'STRING');
		$dropoff_date       = $input->get('dropoff_date', '', 'STRING');
		$dropoff_time       = $input->get('dropoff_time', '', 'STRING');
		$price              = $input->get('price', '', 'NUMBER');
		$sale_price         = $input->get('sale_price', '', 'NUMBER');
		$child_price        = $input->get('child_price', '', 'NUMBER');
		$child_sale_price   = $input->get('child_sale_price', '', 'NUMBER');
		$txn_id             = '';
		$additionalServices = $input->get('additionalServices', '', 'ARRAY');

		$contact_person_name  = $input->get('contact_person_name', '', 'STRING');
		$contact_person_phone = $input->get('contact_person_phone', '', 'STRING');

		$booking_for        = 'package';
		$booked_id          = date('ymdhis') . rand(1000, 9999);
		$name               = $first_name . ' ' . $last_name;
		$created            = date('Y-m-d H:i:s');
		$package_id         = $input->get('package_id', '', 'INT');
		$package_info       = $chk_model->getPackageInfo($package_id);
		$tax                = $input->get('tax', '', 'INT');

		$additionalServicesDetails = $chk_model->getAdditionalServices(json_encode($additionalServices));

		$return_url         = "index.php?option=com_spbooking&view=payment&layout=package&payment_for=package&package_id=" . $package_id . "&booking_id=" . $booked_id;
		$verification_url   = "index.php?option=com_spbooking&view=checkout&task=checkout.verifyEmail";

		$booking_status     = 'invalid';

		if ($user->id > 0)
		{
			$booking_status = 'in_approve';
		}

		$cParams = ComponentHelper::getParams('com_spbooking');
		$config = Factory::getConfig();
		$sender = array($config->get('mailfrom', 'install@install.com'), $config->get('fromname', 'travus'));

		$cartData = array(
			'package_id' => $package_id,
			'adult' => $adult,
			'child' => $child,
			'pickup_location' => $pickup_location,
			'pickup_date' => $pickup_date,
			'pickup_time' => $pickup_time,
			'dropoff_location' => $dropoff_location,
			'dropoff_date' => $dropoff_date,
			'dropoff_time' => $dropoff_time,
			'price' => $price,
			'sale_price' => $sale_price,
			'child_price' => $child_price,
			'child_sale_price' => $child_sale_price,
			'additionalServices' => $additionalServicesDetails
		);
		$cartData = json_encode($cartData);

		$checkin = $package_info->start_date;
		$checkout = $package_info->end_date;
		$confirm_url = Uri::root() . $verification_url . '&email=' . $email . '&token=' . base64_encode($booked_id) . '&return=' . base64_encode($return_url);

		$fields = array('booked_id', 'booking_for', 'checkin', 'checkout', 'name', 'email', 'phone', 'address', 'booking_status', 'created', 'published', 'user_id', 'cartData', 'package_id', 'contact_person_name', 'contact_person_phone', 'txn_id','tax');
		$values = array($booked_id, $booking_for, $checkin, $checkout, $name, $email, $phone, $customer_address, $booking_status, $created, 1, $user->id, $cartData, $package_id, $contact_person_name, $contact_person_phone, $txn_id, $tax);

		try
		{
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->insert($db->quoteName('#__spbooking_bookings'))
				->columns($db->quoteName($fields))
				->values(implode(',', $db->quote($values)));
			$db->setQuery($query);
			$db->execute();
			$inserted_id = $db->insertid();
		}
		catch (Exception $e)
		{
			$output['content'] = Text::_('COM_SPBOOKING_ERROR_OCCUR_SENDING_EMAIL');
			$output['status_code'] = 400;

			echo json_encode($output);
			die();
		}

		// Sent 'New Order' mail to admin.
		$emailData = array(
			"order_id" => $inserted_id,
			"booking_type" => $booking_for,
			'user_name' => $first_name . ' ' . $last_name,
			"user_email" => $email,
			"phone" => $phone
		);

		$message = self::sendNewOrderMail($emailData);

		if ($user->id > 0)
		{
			$output['status_code'] = 202;
			$output['content'] = Uri::root() . $return_url;
			$output['message'] = Text::_('COM_SPBOOKING_THANKS_MESSAGE') . $message;
			echo json_encode($output);
			die();
		}
		else
		{
			// If mail sent to user then store the data to the database
			$mailer = Factory::getMailer();
			$config = Factory::getConfig();
			$cParams = ComponentHelper::getParams('com_spbooking');
			$sender = array($config->get('mailfrom', 'install@install.com'), $config->get('fromname', 'jeetravel'));
			$subject = Text::sprintf('COM_SPBOOKING_VARIFICATION_MAIL_SUBJECT', $package_info->title);

			$start = new DateTime($checkin);
			$end = new DateTime($checkout);
			$diff = $end->diff($start);
			$days = 0;

			if (!empty($diff))
			{
				$days = $diff->days;
			}

			$body = $cParams->get('verification_mail_template', '');
			$body = nl2br($body);

			$body = str_replace("{name}", $name, $body);
			$body = str_replace("{item_title}", "<strong>" . $package_info->title . "</strong>", $body);
			$body = str_replace("{days}", $days, $body);
			$body = str_replace("{checkin}", $checkin, $body);
			$body = str_replace("{checkout}", $checkout, $body);
			$body = str_replace("{order_id}", $booked_id, $body);
			$body = str_replace("{confirm_link}", "<p><a class='spbooking-btn spbooking-btn-primary' href='" . $confirm_url . "'>Confirm Booking</a></p>", $body);
			$body = str_replace("{site_name}", "<p>" . $config->get('fromname', 'travus') . "</p>", $body);

			$mailer->setSender($sender);
			$mailer->addRecipient(trim($email));
			$mailer->setSubject($subject);
			$mailer->isHTML(true);
			$mailer->Encoding = 'base64';
			$mailer->setBody($body);

			// Send email
			if ($mailer->Send())
			{
				$output['content'] = Text::sprintf('COM_SPBOOKING_AN_EMAIL_HAS_BEEN_SENT', $email);
				$output['status_code'] = 200;
			}
			else
			{
				$output['content'] = Text::_('COM_SPBOOKING_ERROR_OCCUR_SENDING_EMAIL');
				$output['status_code'] = 400;
			}
		}

		echo json_encode($output);
		die();
	}

	public function submitTransportCheckoutForm()
	{
		$input  = Factory::getApplication()->input->post;
		$user   = Factory::getUser();
		$cParams = ComponentHelper::getParams('com_spbooking');
		$chk_model = BaseDatabaseModel::getInstance('Checkout', 'SpbookingModel');
		$output = array();
		$first_name         = $input->get('first_name', '', 'STRING');
		$last_name          = $input->get('last_name', '', 'STRING');
		$email              = $input->get('email', '', 'STRING');
		$phone              = $input->get('phone', '', 'STRING');
		$customer_address   = $input->get('customer_address', '', 'STRING');
		$adult              = $input->get('adult', '', 'STRING');
		$child              = $input->get('child', '', 'STRING');
		$pickup_location    = $input->get('pickup_location', '', 'STRING');
		$pickup_date        = $input->get('pickup_date', '', 'STRING');
		$pickup_time        = $input->get('pickup_time', '', 'STRING');
		$dropoff_location   = $input->get('dropoff_location', '', 'STRING');
		$dropoff_date       = $input->get('dropoff_date', '', 'STRING');
		$dropoff_time       = $input->get('dropoff_time', '', 'STRING');
		$price              = $input->get('price', '', 'NUMBER');
		$sale_price         = $input->get('sale_price', '', 'NUMBER');
		$child_price        = $input->get('child_price', '', 'NUMBER');
		$child_sale_price   = $input->get('child_sale_price', '', 'NUMBER');
		$txn_id             = '';
		$tax                = $input->get('tax', '', 'INT');

		$contact_person_name  = $input->get('contact_person_name', '', 'STRING');
		$contact_person_phone = $input->get('contact_person_phone', '', 'STRING');

		$booking_for        = 'transport';
		$booked_id          = date('ymdhis') . rand(1000, 9999);
		$name               = $first_name . ' ' . $last_name;
		$created            = date('Y-m-d H:i:s');
		$transport_id         = $input->get('transport_id', '', 'INT');
		$transport_info       = $chk_model->getTransportInfo($transport_id);

		$return_url         = "index.php?option=com_spbooking&view=payment&layout=transport&payment_for=transport&transport_id=" . $transport_id . "&booking_id=" . $booked_id;
		$verification_url   = "index.php?option=com_spbooking&view=checkout&task=checkout.verifyEmail";
		$confirm_url = Uri::root() . $verification_url . '&email=' . $email . '&token=' . base64_encode($booked_id) . '&return=' . base64_encode($return_url);

		$cParams = ComponentHelper::getParams('com_spbooking');
		$config = Factory::getConfig();
		$sender = array($config->get('mailfrom', 'install@install.com'), $config->get('fromname', 'travus'));

		$cartData = array(
			'transport_id' => $transport_id,
			'adult' => $adult,
			'child' => $child,
			'pickup_location' => $pickup_location,
			'pickup_date' => $pickup_date,
			'pickup_time' => $pickup_time,
			'dropoff_location' => $dropoff_location,
			'dropoff_date' => $dropoff_date,
			'dropoff_time' => $dropoff_time,
			'price' => $price,
			'sale_price' => $sale_price,
			'child_price' => $child_price,
			'child_sale_price' => $child_sale_price
		);
		$cartData = json_encode($cartData);

		$booking_status     = 'invalid';

		if ($user->id > 0)
		{
			$booking_status = 'in_approve';
		}

		$checkin = $pickup_date;
		$checkout = $dropoff_date;

		$fields = array('booked_id', 'booking_for', 'checkin', 'checkout', 'name', 'email', 'phone', 'address', 'booking_status', 'created', 'published', 'user_id', 'cartData', 'transport_id', 'txn_id','tax');
		$values = array($booked_id, $booking_for, $checkin, $checkout, $name, $email, $phone, $customer_address, $booking_status, $created, 1, $user->id, $cartData, $transport_id, $txn_id, $tax);

		try
		{
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			$query->insert($db->quoteName('#__spbooking_bookings'))
				->columns($db->quoteName($fields))
				->values(implode(',', $db->quote($values)));
			$db->setQuery($query);
			$db->execute();
			$inserted_id = $db->insertid();
		}
		catch (Exception $e)
		{
			$output['content'] = Text::_('COM_SPBOOKING_ERROR_OCCUR_SENDING_EMAIL');
			$output['status_code'] = 400;
			echo json_encode($output);
			die();
		}

		// Sent 'New Order' mail to admin.
		$emailData = array(
			"order_id" => $inserted_id,
			"booking_type" => $booking_for,
			'user_name' => $first_name . ' ' . $last_name,
			"user_email" => $email,
			"phone" => $phone
		);
		$message = self::sendNewOrderMail($emailData);

		if ($user->id > 0)
		{
			$output['status_code'] = 202;
			$output['content'] = Uri::root() . $return_url;
			$output['message'] = Text::_('COM_SPBOOKING_THANKS_MESSAGE') . ' ' . $message;
			echo json_encode($output);
			die();
		}
		else
		{
			// If mail sent to user then store the data to the database
			$mailer = Factory::getMailer();
			$config = Factory::getConfig();
			$sender = array($config->get('mailfrom', 'install@install.com'), $config->get('fromname', 'jeetravel'));
			$subject = Text::sprintf('COM_SPBOOKING_VARIFICATION_MAIL_SUBJECT', $transport_info->title);

			$start = new DateTime($checkin);
			$end = new DateTime($checkout);
			$diff = $end->diff($start);
			$days = 0;

			if (!empty($diff))
			{
				$days = $diff->days;
			}

			$body = $cParams->get('verification_mail_template', '');
			$body = nl2br($body);

			$body = str_replace("{name}", $name, $body);
			$body = str_replace("{item_title}", "<strong>" . $transport_info->title . "</strong>", $body);
			$body = str_replace("{days}", $days, $body);
			$body = str_replace("{checkin}", $checkin, $body);
			$body = str_replace("{checkout}", $checkout, $body);
			$body = str_replace("{order_id}", $booked_id, $body);
			$body = str_replace("{confirm_link}", "<p><a class='spbooking-btn spbooking-btn-primary' href='" . $confirm_url . "'>Confirm Booking</a></p>", $body);
			$body = str_replace("{site_name}", "<p>" . $config->get('fromname', 'travus') . "</p>", $body);

			$mailer->setSender($sender);
			$mailer->addRecipient(trim($email));
			$mailer->setSubject($subject);
			$mailer->isHTML(true);
			$mailer->Encoding = 'base64';
			$mailer->setBody($body);

			// Send email
			if ($mailer->Send())
			{
				$output['content'] = Text::sprintf('COM_SPBOOKING_AN_EMAIL_HAS_BEEN_SENT', $email);
				$output['status_code'] = 200;
			}
			else
			{
				$output['content'] = Text::_('COM_SPBOOKING_ERROR_OCCUR_SENDING_EMAIL');
				$output['status_code'] = 400;
			}
		}

		echo json_encode($output);
		die();
	}


	public function checkTransportsAvailability()
	{
		$input  = Factory::getApplication()->input;
		$id     = $input->get('id', 0, 'INT');
		$start  = $input->get('start', '', 'STRING');
		$end    = $input->get('end', '', 'STRING');
		$output = array();

		$db = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id')
			->from($db->quoteName('#__spbooking_bookings'))
			->where($db->quoteName('transport_id') . ' = ' . $db->quote($id))
			->where($db->quoteName('checkin') . ' <= ' . $db->quote($start))
			->where($db->quoteName('checkout') . ' >= ' . $db->quote($start))
			->where($db->quoteName('published') . ' = 1');

		$db->setQuery($query);

		$result = $db->loadResult();

		if (!empty($result))
		{
			$output['content'] = Text::sprintf('COM_SPBOOKING_TRANSPORT_NOT_AVAILABLE', $start, $end);
			$output['status_code'] = 400;
		}
		else
		{
			$output['content'] = '';
			$output['status_code'] = 200;
		}

		echo json_encode($output);
		die();
	}

	/**
	 * This function will send mail to admin after an order is booked.
	 *
	 * @param   [array]  $emailData       Email information.
	 * @return string
	 *
	 * since 2.0.2
	 */
	private function sendNewOrderMail($emailData)
	{
		$mailer  = Factory::getMailer();
		$config  = Factory::getConfig();
		$app     = Factory::getApplication();
		$sender  = array($config->get('mailfrom', 'install@install.com'), $config->get('fromname', 'travus'));
		$cParams = ComponentHelper::getParams('com_spbooking');
		$subject = Text::sprintf('COM_SPBOOKING_NEW_ORDER_SUBJECT', ucfirst($emailData['booking_type']));
		$receiver = $config->get('mailfrom', 'install@install.com');
		$msgBody = $cParams->get('new_order_mail_template', '');

		$body    = nl2br($msgBody);
		$body    = str_replace("{name}", $config->get('fromname', 'travus'), $body);
		$body    = str_replace("{booking_type}", "<strong>" . ucfirst($emailData['booking_type']) . "</strong>", $body);
		$body    = str_replace("{order_id}", "<strong>" . $emailData['order_id'] . "</strong>", $body);
		$body    = str_replace("{user_name}", "<strong>" . $emailData['user_name'] . "</strong>", $body);
		$body    = str_replace("{user_email}", "<strong>" . $emailData['user_email'] . "</strong>", $body);
		$body    = str_replace("{phone}", "<strong>" . $emailData['phone'] . "</strong>", $body);
		$body    = str_replace("{site_name}", "<p>" . $config->get('fromname', 'travus') . "</p>", $body);

		$mailer->setSender($sender);
		$mailer->addRecipient(trim($receiver));
		$mailer->setSubject($subject);
		$mailer->isHTML(true);
		$mailer->Encoding = 'base64';
		$mailer->setBody($body);

		// Send email
		if ($mailer->Send())
		{
			$app->enqueueMessage(Text::_('COM_SPBOOKING_MAIL_SEND_TO_ADMIN'), 'error');
		}
		else
		{
			$app->enqueueMessage(Text::_('COM_SPBOOKING_ERROR_OCCUR_SENDING_EMAIL'), 'error');
		}
	}

	/**
	 * Add Additional Services to CartData
	 *
	 * @param   array $additionalServices
	 * @param   string $cartData
	 * @param   CheckModel $model
	 * @return void
	 */
	private function addServiceToCart($additionalServices, $cartData, $model)
	{
		$additionalServicesDetails           = $model->getAdditionalServices(json_encode($additionalServices));
		$cartDataDecode                      = json_decode($cartData);
		$cartDataDecode->additionalServices  = $additionalServicesDetails;
		$cartData                            = json_encode($cartDataDecode);

		return $cartData;
	}
}
