<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\MVC\Controller\FormController;

class SpbookingControllerAccomodation extends FormController
{

	public function getModel($name = 'Accomodation', $prefix = 'SpbookingController', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);

		return $model;
	}

	public function submitFeedback()
	{
		$output = array();
		$rating = array();
		$app  	= Factory::getApplication();
		$input 	= $app->input;
		$accomodation_id 	= $input->get('accomodation_id', 0, 'INT');
		$package_id 		= $input->get('package_id', 0, 'INT');
		$transport_id 		= $input->get('transport_id', 0, 'INT');
		$place_id 	 		= $input->get('place_id', 0, 'INT');
		$review_for 		= $input->get('review_for', '', 'STRING');
		$review 			= $input->get('review', '', 'STRING');
		$username 			= $input->get('user_name', '', 'STRING');
		$useremail 			= $input->get('user_email', '', 'STRING');
		$userip 			= $_SERVER['REMOTE_ADDR'] ?: ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['HTTP_CLIENT_IP']);
		$comment_date		= new Date('now', $app->getCfg('offset'));
		$review_categories  = $input->get('review_categories', '', 'ARRAY');

		foreach ($review_categories as $value)
		{
			$ratingData 	= $input->get($value);
			$rating[$value] = $ratingData;
		}

		$rating = json_encode($rating);

		$db = Factory::getDbo();
		$query = $db->getQuery(true);

		$columns = array('user_ip', 'user_name', 'user_email', 'advance_rating', 'review', 'published', 'created', 'reviewed_for');
		$values = array($userip, $username, $useremail, $rating, $review, '1', $comment_date, $review_for);

		if (!empty($accomodation_id))
		{
			$columns[] = 'accomodation_id';
			$values[] = $accomodation_id;
		}

		if (!empty($package_id))
		{
			$columns[] = 'package_id';
			$values[] = $package_id;
		}

		if (!empty($transport_id))
		{
			$columns[] = 'transport_id';
			$values[] = $transport_id;
		}

		if (!empty($place_id))
		{
			$columns[] = 'place_id';
			$values[] = $place_id;
		}

		$query->insert($db->quoteName('#__spbooking_reviews'))
			->columns($db->quoteName($columns))
			->values(implode(',', $db->quote($values)));

		$db->setQuery($query);
		$db->execute();

		echo "1";
		die();
	}

}

