;(function($, window, document, undefined){
    var name = "topSearch";
    function Plugin(element, options) {
        this.element = element;
        this._defaults = $.fn.topSearch.defaults;
        this.options = $.extend({}, this._defaults, options);
        
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function() {
            this.cacheElement();
            this.dataFactory();
            this.createDOMS();
            this.generalSearchMethod();
        },
        cacheElement: function() {
            this.$element = $(this.element);
        },
        dataFactory: function() {
            this.$search_destination    = this.$element.find('.search-destination');
            this.$search_result         = this.$element.find('.topbar-search-result');
            this.$search_loading        = this.$element.find('.topbar-search-loading');
            this.$accomodation_input    = this.$element.find('.topbar-accomodation-input');
            this.$city_input            = this.$element.find('.topbar-city-input');
            this.$state_input           = this.$element.find('.topbar-state-input');
            this.$country_input         = this.$element.find('.topbar-country-input');
            this.$checkinout            = this.$element.find('.topbar-checkin-out-range');
            this.$checkin               = this.$element.find('.topbar-search-checkin');
            this.$checkout              = this.$element.find('.topbar-search-checkout');
            this.$toggle_person         = this.$element.find('.toggle-person-info');
            this.$person_container      = this.$element.find('.person-container');

            this.$topbar_search_form    = this.$element.find('#topbar-filter-form');

            this.$package_date_from     = this.$element.find('.package-date-from');
            this.$package_date_to       = this.$element.find('.package-date-to');
        },
        createDOMS: function() {

        },

        generalSearchMethod: function() {
            if (this.options.search_for == 'accomodation') {
                this.eventHandlersForAccomodation();
                this.flatpickrForAccomodation();
                this.updatePersonInfo();
            } else if (this.options.search_for == 'package') {
                this.packageKeywordSearch();
                this.flatPickrForPackage();
            } else if (this.options.search_for == 'transport') {
                this.transportKeywordSearch();
                this.flatpickrForAccomodation();
            } else if (this.options.search_for == 'place') {
                this.placeKeywordSearch();
            }
        },
        
        eventHandlersForAccomodation: function() {
            let self = this;
            this.$search_destination.on('keyup focus', function(e){
                e.preventDefault();
                let keyword = typeof($(this).val()) == 'string' && $(this).val().length > 0 ? $(this).val() : false;
                let url = 'index.php?option=com_spbooking&task=accomodations.getDestination';
                let timer;

                if (keyword) {
                    self.$search_result.empty();
                    self.$search_loading.show();

                    clearTimeout(timer);
                    timer = setTimeout(() => {
                        self.getSearchResult(url, keyword, 5).then((response) => {
                            if (!!response) {
                                self.$search_result.show();
                                self.$search_result.html(response);
                                self.$search_loading.hide();
                            }
                        });
                    }, 300);
                }
            });

            // Select a specific result
            $(document).on('click', '.topbar-search-result-item', function(e) {
                e.preventDefault();
                let restype         = typeof($(this).data('restype')) == 'string' && $(this).data('restype').length > 0 ? $(this).data('restype') : false;
                let accomodation    = false;
                let city            = false;
                let country         = false;
                let state           = false;

                if (restype) {
                    if (restype == 'accomodation') {
                        accomodation = $(this).data('content');
                    } else if (restype == 'city') {
                        city = $(this).data('content');
                    } else if (restype == 'country') {
                        country = $(this).data('content');
                    } else if (restype == 'state') {
                        state = $(this).data('content');
                    }
                }

                if (accomodation) {
                    self.$accomodation_input.val(accomodation);
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (city) {
                    self.$accomodation_input.val('');
                    self.$city_input.val(city);
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (country) {
                    self.$accomodation_input.val('');
                    self.$city_input.val('');
                    self.$country_input.val(country);
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (state) {
                    self.$accomodation_input.val('');
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val(state);
                }

                self.$search_result.hide();
            });

            // Close result div on click outside
            $(document).on('click', function(e) {
                
                if( $(e.target).closest(".topbar-search-result").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".search-destination").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".toggle-person-info").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".topbar-btn-group").length > 0 ) {
                    return false;
                }

                self.$search_result.hide();
                self.$person_container.removeClass('open');
                self.$element.find('.person-caret > span').removeClass('fa-caret-up').addClass('fa-caret-down');
            });

            // toggle person info
            this.$toggle_person.on('click', function(e) {
                e.preventDefault();
                let $person_caret       = $(this).parent().find('.person-caret > span');
                let $person_container   = $(this).parent().find('.person-container');
                if ($person_caret.hasClass('fa-caret-down')) {
                    $person_caret.removeClass('fa-caret-down').addClass('fa-caret-up');
                    $person_container.addClass('open');
                } else if ($person_caret.hasClass('fa-caret-up')) {
                    $person_caret.removeClass('fa-caret-up').addClass('fa-caret-down');
                    $person_container.removeClass('open');
                }

            });

            // increment decrement person information
            $('.btn-minus').on('click', function(e){
                e.preventDefault();
                let $value_holder = $(this).siblings('.value-holder');
                let val = $value_holder.length > 0 && typeof($value_holder.data('val')) == 'number' && $value_holder.data('val') ? parseInt($value_holder.data('val')) : 0;
                let min = $value_holder.length > 0 && typeof($value_holder.data('min')) == 'number' && $value_holder.data('min') ? parseInt($value_holder.data('min')) : 0;
                if (val > min) {
                    val--;
                    $value_holder.data('val', val);
                    let info = val + ' ' + (val > 1 ? $value_holder.data('plural') : $value_holder.data('singular'));
                    $value_holder.text(val);
                    $value_holder.data('info', info);
                    $(this).parent().find('input').val(val);
                    self.updatePersonInfo();
                }
            });
            
            $('.btn-plus').on('click', function(e){
                e.preventDefault();
                let $value_holder = $(this).siblings('.value-holder');
                let val = $value_holder.length > 0 && typeof($value_holder.data('val')) == 'number' && $value_holder.data('val') ? parseInt($value_holder.data('val')) : 0;
                
                val++;
                $value_holder.data('val', val);
                // $value_holder.text(val + ' ' + (val > 1 ? $value_holder.data('plural') : $value_holder.data('singular')));
                let info = val + ' ' + (val > 1 ? $value_holder.data('plural') : $value_holder.data('singular'));
                $value_holder.text(val);
                $value_holder.data('info', info);
                $(this).parent().find('input').val(val);
                self.updatePersonInfo();
            });
            this.submitSearch();
        },
        submitSearch: function() {
            // Submit topbar form
            let self = this;
            this.$topbar_search_form.on('submit', function(e){
                e.preventDefault();
                
                let formData    = $(this).serializeArray();
                let query       = new URLSearchParams(window.location.search);
                
                formData    = typeof(formData) == 'object' && formData instanceof Array && formData.length > 0 ? formData : false;
                query       = typeof (query) == 'object' && query ? query : false;

                if (formData) {
                    formData.map((v) => {
                        let name = typeof(v.name) == 'string' && v.name.length > 0 ? v.name : false;
                        let val = typeof(v.value) == 'string' && v.value.length > 0 ? v.value : false;
                        
                        if(name) {
                            if (val) {
                                if (query.has(name)) {
                                    query.set(name, val);
                                } else {
                                    query.append(name, val);
                                }
                            } else {
                                if (query.has(name)) {
                                    query.delete(name);
                                }
                            }
                        }
                    });
                }
                window.location.href = self.options.topsearch_host + 'index.php?' + query.toString();
            });
        },
        formatDate: function (date, goTo) {
            var d = new Date(date);
            
            if (goTo == 'nextDay') {
                d.setDate(d.getDate() + 1);
            }
            
            month = '' + (d.getMonth() + 1),
            day = '' + d.getDate(),
            year = d.getFullYear();

            if (month.length < 2) month = '0' + month;
            if (day.length < 2) day = '0' + day;

            return [year, month, day].join('-');
        },
        updatePersonInfo: function() {
            let info = '';
            let $is_room = this.$element.find('.value-holder.is-room');
            let $is_adult = this.$element.find('.value-holder.is-adult');
            let $is_child = this.$element.find('.value-holder.is-child');
            info = $is_room.data('info') + ', ' + $is_adult.data('info') + ', ' + $is_child.data('info');
            this.$toggle_person.text(info);
        },

        getSearchResult: function(url, keyword, limit) {
            return new Promise((resolve, reject) => {
                $.ajax({
                    url: this.options.topsearch_host + url,
                    type: 'post',
                    data: {
                        keyword: keyword,
                        limit: limit
                    },
                    success: function(response) {
                        resolve(response);
                    },
                    error: function(err) {
                        reject(err);
                    }
                });
            });
        },

        flatpickrForAccomodation: function() {
            let self = this;
            this.$checkinout.flatpickr({
                mode: "range",
                altInput: true,
                altFormat: 'D, j M Y',
                minDate: "today",
                dateFormat: "Y-m-d",
                defaultDate: [self.options.checkin, self.options.checkout],
                onOpen: function() {
                    let $calendar_icon = self.$checkinout.siblings('.range-icon').find('span');
                    if ($calendar_icon.hasClass('text-mute')) {
                        $calendar_icon.removeClass('text-mute').addClass('text-green');
                    }
                },
                onClose: function() {
                    let $calendar_icon = self.$checkinout.siblings('.range-icon').find('span');
                    if ($calendar_icon.hasClass('text-green')) {
                        $calendar_icon.removeClass('text-green').addClass('text-mute');
                    }
                },
                onChange: function(selectedDates, dateStr, instance) {
                    dateStr = typeof(dateStr) == 'string' && dateStr.length > 0 ? dateStr : false;

                    if (!!dateStr) {
                        dateStr = dateStr.split('to');
                        let checkin, checkout;
                        
                        checkin = typeof(dateStr[0]) == 'string' && dateStr[0].length > 0 ? dateStr[0] : false;
                        checkout = typeof(dateStr[1]) == 'string'  && dateStr[1].length > 0 ? dateStr[1] : false;
                        

                        if (!!checkin) {
                            self.$checkin.val(checkin.trim());
                            if (!!checkout) {
                                self.$checkout.val(checkout.trim());
                            } else {
                                let day = new Date(checkin);
                                checkout = new Date(day.setDate(day.getDate() + 1));
                                checkout = self.formatDate(checkout);
                                self.$checkout.val(checkout);
                            }
                        }
                    }
                }
            });
        },

        flatPickrForPackage: function() {
            let query = new URLSearchParams(window.location.search);
            let from_date = '', to_date = '';
            if (query.has('date_from')) {
                from_date = query.get('date_from');
            }
            
            if (query.has('date_to')) {
                to_date = query.get('date_to');
            }
            
            this.$package_date_from.flatpickr({
                mode: "single",
                altInput: true,
                altFormat: 'D, j M Y',
                minDate: "today",
                dateFormat: "Y-m-d",
                defaultDate: [from_date]
            });
            this.$package_date_to.flatpickr({
                mode: "single",
                altInput: true,
                altFormat: 'D, j M Y',
                minDate: "today",
                dateFormat: "Y-m-d",
                defaultDate: [to_date]
            });
        },
        
        packageKeywordSearch: function() {
            let self = this;
            // get data by typing keyword
            this.$search_destination.on('keyup focus', function(e){
                e.preventDefault();
                let keyword = typeof($(this).val()) == 'string' && $(this).val().length > 0 ? $(this).val() : false;
                let url = 'index.php?option=com_spbooking&task=packages.getKeywordSearch';
                let timer;

                if (keyword) {
                    self.$search_result.empty();
                    self.$search_loading.show();

                    clearTimeout(timer);
                    timer = setTimeout(() => {
                        self.getSearchResult(url, keyword, 5).then((response) => {
                            if (!!response) {
                                self.$search_result.show();
                                self.$search_result.html(response);
                                self.$search_loading.hide();
                            }
                        });
                    }, 300);
                }
            });

            // Select a specific result
            $(document).on('click', '.topbar-search-result-item', function(e) {
                e.preventDefault();
                let restype         = typeof($(this).data('restype')) == 'string' && $(this).data('restype').length > 0 ? $(this).data('restype') : false;
                let package_id      = false;
                let city            = false;
                let country         = false;
                let state           = false;

                if (restype) {
                    if (restype == 'package') {
                        package_id = $(this).data('content');
                    } else if (restype == 'city') {
                        city = $(this).data('content');
                    } else if (restype == 'country') {
                        country = $(this).data('content');
                    } else if (restype == 'state') {
                        state = $(this).data('content');
                    }
                }

                if (package_id) {
                    self.$accomodation_input.val(package_id);
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (city) {
                    self.$accomodation_input.val('');
                    self.$city_input.val(city);
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (country) {
                    self.$accomodation_input.val('');
                    self.$city_input.val('');
                    self.$country_input.val(country);
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (state) {
                    self.$accomodation_input.val('');
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val(state);
                }

                self.$search_result.hide();
            });

            // Close result div on click outside
            $(document).on('click', function(e) {
                
                if( $(e.target).closest(".topbar-search-result").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".search-destination").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".toggle-person-info").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".topbar-btn-group").length > 0 ) {
                    return false;
                }

                self.$search_result.hide();
            });


            // submit search data on submit button click
            this.submitSearch();
        },
        
        transportKeywordSearch: function() {
            let self = this;
            // get data by typing keyword
            this.$search_destination.on('keyup focus', function(e){
                e.preventDefault();
                let keyword = typeof($(this).val()) == 'string' && $(this).val().length > 0 ? $(this).val() : false;
                let url = 'index.php?option=com_spbooking&task=transports.getKeywordSearch';
                let timer;

                if (keyword) {
                    self.$search_result.empty();
                    self.$search_loading.show();

                    clearTimeout(timer);
                    timer = setTimeout(() => {
                        self.getSearchResult(url, keyword, 5).then((response) => {
                            if (!!response) {
                                self.$search_result.show();
                                self.$search_result.html(response);
                                self.$search_loading.hide();
                            }
                        });
                    }, 300);
                }
            });

            // Select a specific result
            $(document).on('click', '.topbar-search-result-item', function(e) {
                e.preventDefault();
                let restype         = typeof($(this).data('restype')) == 'string' && $(this).data('restype').length > 0 ? $(this).data('restype') : false;
                let transport_id    = false;
                let city            = false;
                let country         = false;
                let state           = false;

                if (restype) {
                    if (restype == 'transport') {
                        transport_id = $(this).data('content');
                    } else if (restype == 'city') {
                        city = $(this).data('content');
                    } else if (restype == 'country') {
                        country = $(this).data('content');
                    } else if (restype == 'state') {
                        state = $(this).data('content');
                    }
                }

                if (transport_id) {
                    self.$accomodation_input.val(transport_id);
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (city) {
                    self.$accomodation_input.val('');
                    self.$city_input.val(city);
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (country) {
                    self.$accomodation_input.val('');
                    self.$city_input.val('');
                    self.$country_input.val(country);
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (state) {
                    self.$accomodation_input.val('');
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val(state);
                }

                self.$search_result.hide();
            });

            // Close result div on click outside
            $(document).on('click', function(e) {
                
                if( $(e.target).closest(".topbar-search-result").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".search-destination").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".toggle-person-info").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".topbar-btn-group").length > 0 ) {
                    return false;
                }

                self.$search_result.hide();
            });


            // submit search data on submit button click
            this.submitSearch();
        }, 
        placeKeywordSearch: function() {
            let self = this;
            // get data by typing keyword
            this.$search_destination.on('keyup focus', function(e){
                e.preventDefault();
                let keyword = typeof($(this).val()) == 'string' && $(this).val().length > 0 ? $(this).val() : false;
                let url = 'index.php?option=com_spbooking&task=places.getKeywordSearch';
                let timer;

                if (keyword) {
                    self.$search_result.empty();
                    self.$search_loading.show();

                    clearTimeout(timer);
                    timer = setTimeout(() => {
                        self.getSearchResult(url, keyword, 5).then((response) => {
                            if (!!response) {
                                self.$search_result.show();
                                self.$search_result.html(response);
                                self.$search_loading.hide();
                            }
                        });
                    }, 300);
                }
            });

            // Select a specific result
            $(document).on('click', '.topbar-search-result-item', function(e) {
                e.preventDefault();
                let restype         = typeof($(this).data('restype')) == 'string' && $(this).data('restype').length > 0 ? $(this).data('restype') : false;
                let place_id        = false;
                let city            = false;
                let country         = false;
                let state           = false;

                if (restype) {
                    if (restype == 'place') {
                        place_id = $(this).data('content');
                    } else if (restype == 'city') {
                        city = $(this).data('content');
                    } else if (restype == 'country') {
                        country = $(this).data('content');
                    } else if (restype == 'state') {
                        state = $(this).data('content');
                    }
                }

                if (place_id) {
                    self.$accomodation_input.val(place_id);
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (city) {
                    self.$accomodation_input.val('');
                    self.$city_input.val(city);
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (country) {
                    self.$accomodation_input.val('');
                    self.$city_input.val('');
                    self.$country_input.val(country);
                    self.$search_destination.val($(this).text());
                    self.$state_input.val('');
                } else if (state) {
                    self.$accomodation_input.val('');
                    self.$city_input.val('');
                    self.$country_input.val('');
                    self.$search_destination.val($(this).text());
                    self.$state_input.val(state);
                }

                self.$search_result.hide();
            });

            // Close result div on click outside
            $(document).on('click', function(e) {
                
                if( $(e.target).closest(".topbar-search-result").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".search-destination").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".toggle-person-info").length > 0 ) {
                    return false;
                }
                
                if( $(e.target).closest(".topbar-btn-group").length > 0 ) {
                    return false;
                }

                self.$search_result.hide();
            });


            // submit search data on submit button click
            this.submitSearch();
        }


    });

    $.fn.topSearch = function(options) {
        this.each(function() {
            if (!$.data(this, name)) {
                $.data(this, name, new Plugin(this, options));
            }
        });
        return this;
    };

    $.fn.topSearch.defaults = {
        topsearch_host: '',
        search_for: 'accomodation',
        checkin: '',
        checkout: ''
    };
})(jQuery, window, document);