;(function($, window, document, undefined){
    var name = 'spValidate';
    function Plugin(element, options) {
        this.element = element;
        this._defaults = $.fn.spValidate.defaults;
        this.options = $.extend({}, this._defaults, options);
        // this.options.reports = $.extend({}, this.options.reports, this.options.messages);
        
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function() {
            this.cacheElement();
            this.dataCenter();
            this.check();
        },
        cacheElement: function () {
            this.$element = $(this.element);
        },
        check: function() {
            this.options.rules = typeof (this.options.rules) == 'object' && Object.keys(this.options.rules).length > 0 ? this.options.rules : false;
            this.options.messages = typeof (this.options.messages) == 'object' && Object.keys(this.options.messages).length > 0 ? this.options.messages : false;

            if (this.$element.prop('nodeName') !== 'FORM') {
                console.error('Only form allowed!');
                return false;
            }

            if (!this.options.rules) {
                console.error("No Rules found!");
                return false;
            }
            
            if (!this.options.messages) {
                console.error("No Messages found!");
                return false;
            }
        },
        dataCenter: function() {

        },

        isPassed: function() {
          
            let error_count = 0;
            let avaibility = '';

            if (this.options.rules) {
                let rules = this.options.rules;
                Object.keys(rules).map((key) => {
                    let field = this.$element.find("[name=" + key + "]");
                    
                    if ((field[0] !== undefined) && (field[0].id === 'avaibility')) {
                        avaibility = field.val();                     
                    }
                    let condition_str = false;
                    let condition_obj = false;
                    if (typeof (rules[key]) == 'string' && rules[key].length > 0) {
                        condition_str = rules[key];
                    } else if (typeof (rules[key]) == 'object' && Object.keys(rules[key]).length > 0) {
                        condition_obj = rules[key];
                    }

                    if (!!condition_str) {
                        if (rules[key] == 'required') {
                            
                            if (field.val() == '') {
                              
                                this.createErrorMessage(field, this.options.messages[key]);
                                error_count ++;
                            } else {
                                this.clearErrorMessage(field);
                            }
                        }
                        if (rules[key] == 'sum') {
                            
                            if (parseInt(field.val()) > parseInt(avaibility)) {
                                this.createErrorMessage(field, this.options.messages[key]);
                                error_count++;
                            } else {
                                this.clearErrorMessage(field);
                            }
                        }
                    } else if (!!condition_obj) {
                        // multiple rules applied
                        Object.keys(condition_obj).map((i) => {
                          
                        });
                    }
                });
            }
            if (error_count > 0) {
                return false;
            }
            return true;
        },

        createErrorMessage: function(sibling, message) {
            let err_el = sibling.siblings('.sp-validate-error-msg');
            if (err_el.length > 0) {
                return;
            } 
            let _el = document.createElement('small');
            _el.setAttribute('class', 'sp-validate-error-msg text-danger');
            _el.innerHTML = message;
            sibling.after(_el);
        },

        clearErrorMessage: function(sibling) {
            let err_el = sibling.siblings('.sp-validate-error-msg');
            if (err_el.length > 0) {
                err_el.remove();
            } 
        }
    });

    $.fn.spValidate = function(options) {
        this.each(function() {
            if (!$.data(this, name)) {
                $.data(this, name, new Plugin(this, options));
            }
        });
        return this;
    };

    $.fn.spValidate.defaults = {
        rules: {},
        messages: {}
    };
})(jQuery, window, document);