;(function($, window, document, undefined){
    var name = 'spReview';
    function Plugin(element, options) {
        this.element = element;
        this._defaults = $.fn.spReview.defaults;
        this.options = $.extend({}, this._defaults, options);

        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function() {
            this.cacheElement();
            this.dataCenter();
            this.createBasicDom();
            this.highlightStarOnHover();
            this.selectStarOnClick();
        },
        cacheElement: function () {
            this.$element = $(this.element);
        },
        dataCenter: function() {
            // Declare all the data and init here
            this.star_bars = [];
            this.selected_index = typeof(this.options.rating) == 'number' && this.options.rating ? this.options.rating: -1;
        },
        createElement: function(tag, attr, text) {
            tag     = typeof(tag)   == 'string' && tag.length > 0 ? tag : 'div';
            attr    = typeof(attr)  == 'object' && Object.keys(attr).length > 0 ? attr : false;
            text    = typeof(text)  == 'string' && text.length > 0 ? text : false;

            let _el = document.createElement(tag);

            if (attr) {
                Object.keys(attr).map((key) => {
                    _el.setAttribute(key, attr[key]);
                });
            }

            if (text) {
                _el.innerHTML = text;
            }
            return _el;
        },
        createBasicDom: function() {
            // Create review element holder @parent this.$element
            let _review_holder= this.createElement('div', {
                class: 'review-holder'
            });
            this.$element.append(_review_holder);
            this.$review_holder = $(_review_holder);

            // Create star bars @parent this.$review_holder
            
            for (let i = 0 ; i < this.options.stars; i++ ) {
                let _bar = this.createElement('span', {
                    class: 'star-bar',
                    'data-index': i
                });
                this.star_bars.push(_bar);
                this.$review_holder.append(_bar);
            }

            // Create input element @Parent this.$element
            let _input = this.createElement('input', {
                type: 'hidden',
                name: this.options.input_name
            });

            this.$element.append(_input);
            this.$input = $(_input);
        },

        highlightStarOnHover: function() {
            let self = this;
            this.$element.find('.star-bar').on('mouseenter', function(e){
                // Mouse in
                let last_index = $(this).data('index');
                for(let i = 0 ; i <= last_index; i++) {
                    let bar = self.star_bars[i];
                    $(bar).css('background', 'orange');
                }

                self.$element.find('.star-bar').on('mouseleave', function(e){
                    // Mouse out
                    let last_index = $(this).data('index');
                    for(let i = (self.selected_index+1) ; i < self.options.stars; i++) {
                        let bar = self.star_bars[i];
                        $(bar).css({
                            'background': '#e5e6e5'
                        });
                    }
                });
            });
        },
        selectStarOnClick: function() {
            let self = this;
            this.$element.find('.star-bar').on('click', function(e) {
                e.preventDefault();
                self.resetStars(); 
                self.selected_index = $(this).data('index');
                self.$input.val(self.selected_index + 1);

                for(let i = 0; i <= self.selected_index; i++ ) {
                    let bar = self.star_bars[i];
                    $(bar).css('background', 'orange');
                    $(bar).off('mouseleave');
                }
            });
        },
        resetStars: function() {
            for(let i = 0; i < this.options.stars; i++) {
                let bar = this.star_bars[i];
                $(bar).css('background', '#e5e6e5');
                
                this.selected_index = 0;
            }
        }
    });

    $.fn.spReview = function(options) {
        this.each(function() {
            if (!$.data(this, name)) {
                $.data(this, name, new Plugin(this, options));
            }
        });
        return this;
    };

    $.fn.spReview.defaults = {
        stars: 5,
        input_name: 'sprating',
        rating: 0
    };
})(jQuery, window, document);