;(function($, window, document, undefined){
    var name = 'spPayment';
    function Plugin(element, options) {
        this.element = element;
        this._defaults = $.fn.spPayment.defaults;
        this.options = $.extend({}, this._defaults, options);

        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function() {
            this.cacheElement();
            this.dataCenter();
            this.declareDOM();
            this.eventHandlers();
        },
        cacheElement: function () {
            this.$element = $(this.element);
        },
        dataCenter: function() {

        },
        
        declareDOM: function() {
            this.$form = this.$element.find('form#payment-form');
            this.$payment_type = this.$element.find('input[name=payment-method]');
            this.$paypal = this.$element.find('.payment-method-paypal');
            this.$paylater = this.$element.find('.payment-method-paylater');
            this.$stripe = this.$element.find('.payment-method-stripe')
        },
        eventHandlers: function() {
            let self = this;
            
            // on change payment type radio button
            this.$payment_type.on('change', function(e){
                let radio_val = $(this).val();
                
                if ( radio_val == 'paypal') {
                    self.$paypal.show();
                    self.$paylater.hide();
                    self.$stripe.hide();
                } else if (radio_val == 'paylater') {
                    self.$paypal.hide();
                    self.$paylater.show();
                    self.$stripe.hide();
                }
                else if (radio_val == 'stripe') {
                    self.$stripe.show();
                    self.$paypal.hide();
                    self.$paylater.hide();
                }
            });

            
            $('#payment_tac').on('click', function(e){
                if ($(this).prop('checked') == true) {
                    $('.paypal-submit-btn').prop('disabled', false);
                    $('.paylater-submit-btn').prop('disabled', false);
                    $('.stripe-submit-btn').prop('disabled', false)
                } else {
                    $('.paypal-submit-btn').prop('disabled', true);
                    $('.paylater-submit-btn').prop('disabled', true);
                    $('.stripe-submit-btn').prop('disabled', true);
                }
            });

            $('.paylater-submit-btn').on('click', function(e){
                e.preventDefault();
                let href = $(this).data('href');
                window.location.href = href;
            });

            $('.stripe-submit-btn').on('click', function (e) {               
                e.preventDefault();
                let href = $(this).data('href');
                window.location.href = href;
            })
        }
        
    });

    $.fn.spPayment = function(options) {
        this.each(function() {
            if (!$.data(this, name)) {
                $.data(this, name, new Plugin(this, options));
            }
        });
        return this;
    };

    $.fn.spPayment.defaults = {
        
    };
})(jQuery, window, document);