;(function($, window, document, undefined){
    var name = 'spMap';
    function Plugin(element, options) {
        this.element = element;
        this._defaults = $.fn.spMap.defaults;
        this.options = $.extend({}, this._defaults, options);

        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function() {
            this.cacheElement();
            this.dataCenter();
            if (this.options.maptype == 'google') {
                this.initGoogleMap();
            } else {
                this.initOpenStreetMap();
            }
        },
        cacheElement: function () {
            this.$element = $(this.element);
        },
        dataCenter: function() {
            this.googleMap = null;
        },

        initGoogleMap: function() {
            this.googleMap = new google.maps.Map(document.getElementById(this.options.google_map_id), {
                center: this.parseLocation(this.options.latlng),
                zoom: this.options.zoom
            });
            let marker = new google.maps.Marker({position: this.parseLocation(this.options.latlng), map: this.googleMap});
            let contentString = `
                <strong>${this.options.title}</strong>
            `;
            let infoWindow = new google.maps.InfoWindow({
                content: contentString
            });

            infoWindow.open(this.googleMap, marker);
            marker.addListener('click', () => {
                infoWindow.open(this.googleMap, marker);
            });
        }, 

        initOpenStreetMap: function() {
            this.osmMap  = L.map(this.options.osm_id, {
                scrollWheelZoom: false
            }).setView(this.parseLocation(this.options.latlng, 'osm'), this.options.zoom);
            L.tileLayer('https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token={accessToken}', {
                attribution: "Map data &copy; <a href=https://www.openstreetmap.org/'>OpenStreetMap</a> contributors, <a href='https://creativecommons.org/licenses/by-sa/2.0/'>CC-BY-SA</a>, Imagery © <a href='https://www.mapbox.com/'>Mapbox</a>",
                id: 'mapbox/' + this.options.tile_type,
                accessToken: this.options.mapbox_token
            }).addTo(this.osmMap);

            let marker = L.marker(this.parseLocation(this.options.latlng, 'osm')).addTo(this.osmMap);
            
            let popup = L.popup();
            let contentString = `
                <strong>${this.options.title}</strong>
            `;
            popup.setContent(contentString).setLatLng(this.parseLocation(this.options.latlng, 'osm'));
            marker.bindPopup(popup).openPopup();
        },

        parseLocation: function(latlng_str, loc_for = 'google') {
            let latlng = [];
            if (latlng_str.indexOf(',') > -1) {
                latlng = latlng_str.split(',');
            }
            let latlng_obj = {};
            let latlng_arr = [];
            if (latlng.length > 0) {
                latlng_obj.lat = parseFloat(latlng[0]);
                latlng_obj.lng = parseFloat(latlng[1]);
                latlng_arr.push(parseFloat(latlng[0]));
                latlng_arr.push(parseFloat(latlng[1]));
            }
            if (loc_for == 'google') {
                return Object.keys(latlng_obj).length > 0 ? latlng_obj : false;
            }
            return latlng_arr.length > 0 ? latlng_arr : false;

        }
    });

    $.fn.spMap = function(options) {
        this.each(function() {
            if (!$.data(this, name)) {
                $.data(this, name, new Plugin(this, options));
            }
        });
        return this;
    };

    $.fn.spMap.defaults = {
        google_map_id: 'accomodation-google-map',
        osm_id: 'accomodation-osm-map',
        latlng: '-34.397,150.644',
        title: 'Accomodation',
        zoom: 12,
        maptype: 'google',
        mapbox_token: '',
        tile_type:'streets'
        
    };
})(jQuery, window, document);