;(function($, window, document, undefined){
    var name = 'spCheckout';
    function Plugin(element, options){
        this.element = element;
        this.options = options;
        this._defaults = $.fn.spCheckout.defaults;
        this.options = $.extend({}, this._defaults, options);

        this.init();
    }
   
    $.extend(Plugin.prototype, {
        init: function() {
            this.cacheElement();
            this.elementDeclarations();
            this.dataContainer();
            this.eventHandlers();
            this.handleCartData();
            this.submitCheckoutForm();
            this.initPackageCheckout();
            this.initTransportCheckout();
        },
        dataContainer: function() {
            this.totalPrice = 0;
            this.transportCost = 2000;
            this.tax = this.options.tax; // percent
            this.subtotal = 0;
            this.acCartData = localStorage.getItem('accomodation_cart') || false;
            if (this.acCartData) {
                this.acCartData = JSON.parse(this.acCartData);
                this.acCartData = typeof(this.acCartData) == 'object' && Object.keys(this.acCartData).length > 0 ? this.acCartData : false;
            }
        },
        cacheElement: function() {
            this.$element = $(this.element);
        }, 
        elementDeclarations: function() {
            this.$customer_info = this.$element.find('.customer-information');
            this.$cart = this.$element.find('.spbooking-cart');
            this.$cart_header = this.$cart.find(".cart-header");
            this.$cart_body = this.$cart.find('.cart-body');
            this.$checkout_form = this.$element.find('#checkout-form');
            this.$message = this.$element.find('.display-compilation-message');
            this.$info_container = this.$element.find('.info-container');
            this.$additional_services = this.$element.find('.additionalServices');

            // Declaration for package checkout
            this.$package_form = this.$element.find('form#package-checkout');
            this.$customer_info = this.$package_form.find('.checkout-customer-information');
            this.$travel_info = this.$package_form.find('.checkout-travel-information');
            this.$next_to_travel = this.$package_form.find('.next-to-travel');
            this.$back_to_customer = this.$package_form.find('.back-to-customer');
            this.$package_message = this.$element.find('.email-verification-message-for-package');

            // Declaration for transport checkout
            this.$transport_form = this.$element.find('form#transport-checkout');
            this.$trans_customer_info = this.$transport_form.find('.checkout-customer-information');
            this.$trans_travel_info = this.$transport_form.find('.checkout-travel-information');
            this.$trans_next_to_travel = this.$transport_form.find('.next-to-travel');
            this.$trans_back_to_customer = this.$transport_form.find('.back-to-customer');
            this.$trans_package_message = this.$element.find('.checkout-message-for-transport');
            
        },
        eventHandlers: function() {
            let self = this;
        },
        handleCartData: function() {
            let self = this;
            if (this.acCartData) {
                Object.keys(this.acCartData).map((key)=>{
                    
                    let cartContent = `
                        <div class='spbooking-row cart-content-wrapper'>
                            <div class='spbooking-col-8'>
                                ${typeof(self.acCartData[key].room_title) != 'undefined' && self.acCartData[key].room_title ? `<span class='room-title'>${self.acCartData[key].room_title}</span><br>` : ``}
                                ${typeof(self.acCartData[key].n_rooms) != 'undefined' && self.acCartData[key].n_rooms ? `<small class='text-mute'>${self.acCartData[key].n_rooms + ' Room(s)'}</small>` : ``}
                                ${typeof(self.acCartData[key].adult) != 'undefined' && self.acCartData[key].adult && `<small class='text-mute'>${self.acCartData[key].adult + ' Adult(s)'}</small>`}
                                ${typeof(self.acCartData[key].child) != 'undefined' && self.acCartData[key].child ? `<small class='text-mute'>${self.acCartData[key].child + ' Child(ren)'}</small>` : ``}
                                ${typeof(self.acCartData[key].nights) != 'undefined' && self.acCartData[key].nights && `<small class='text-mute'> x ${self.acCartData[key].nights + ' Night(s)'}</small>`}
                            </div>
                            <div class='spbooking-col-4'>
                            
                                ${self.renderPrice(self.calculateRoomPrice(self.acCartData[key]).toMoney())}
                            </div>
                        </div>
                    `;
                    self.$cart_body.append(cartContent);
                });

                let subtotal = `
                <hr>
                <div class='spbooking-row'>
                    <div class='spbooking-col-8'>
                        <p class='spbooking-subtitle text-mute'>${this.options.additional_service}: </p>
                    </div>
                </div>
                <div class='spbooking-row spbooking-append-data'></div>
                <hr>
                <div class='spbooking-row'>
                    <div class='spbooking-col-8'>
                        <p class='spbooking-subtitle text-mute'>${this.options.subtotal_text}: </p>
                    </div>
                    <div class='spbooking-col'><p class='subtotal-price'>${this.renderPrice(this.calculateSubtotal().toMoney())}</p></div>
                </div>
                <div class='spbooking-row'>
                    <div class='spbooking-col-8'>
                        <p class='spbooking-subtitle text-mute'>${this.options.tax_text}(${this.tax + '%'}): </p>
                    </div>
                    <div class='spbooking-col'><p class='tax-price'>${this.renderPrice(this.calculateTax().toMoney())}</p></div>
                </div>
                <hr>
                <div class='spbooking-d-flex spbooking-justify-content-between total-price-wrap'>
                    <div>
                        <p class='spbooking-subtitle text-mute'>${this.options.total_text}: </p>
                    </div>
                    <div><p class='total-price'>${this.renderPrice(this.calculateTotalPrice().toMoney())}</p></div>
                </div>`;
                this.$cart_body.append(subtotal);                           
            }

            // Additional service check/uncheck
            this.$additional_services.on('click', function (e) {
                
                let additionalServicePrice, totalPrice, subtotalPrice, taxPrice, sum  = 0;
                let services, additionalServiceTitle = '';

                // Remove all the children of Additional Service
                $(".spbooking-append-data").children().remove();
 
                $.each($("input[name='additionalServices[]']:checked"), function () {
                    additionalServicePrice = $(this).attr('data-price');
                    additionalServiceTitle = $(this).attr('data-title');
                    additionalServiceID    = $(this).attr('id');
                    sum                    = sum + parseInt(additionalServicePrice);    

                    services = 
                    `<div class='spbooking-col-8'>
                        <p class='spbooking-subtitle text-mute'>${additionalServiceTitle}: </p>
                    </div>
                    <div class='spbooking-col'><p>${self.renderPrice(additionalServicePrice)}</p></div>`;    

                    //Append Selected Additional Services                         
                    $(".spbooking-append-data").append(services);    
                });
                
                subtotalPrice = self.calculateSubtotal() + sum;
                taxPrice      = self.addServiceInTaxPrice(sum);
                totalPrice    = subtotalPrice + taxPrice;

                subtotalPrice = self.renderPrice(subtotalPrice.toMoney());
                taxPrice      = self.renderPrice(taxPrice.toMoney());
                totalPrice    = self.renderPrice(totalPrice.toMoney());  
                
                $('.subtotal-price').text(subtotalPrice);
                $('.total-price').text(totalPrice);        
                $('.tax-price').text(taxPrice);       
            })
        },
  
        submitCheckoutForm: function() {
            let self = this;
            let validator = this.$checkout_form.spValidate({
                rules: {
                    "first_name": 'required',
                    "last_name": 'required',
                    "email": 'required',
                    "phone": 'required',
                    "adult": 'required',
                   
                },
                messages: {
                    'first_name': 'First Name is required',
                    'last_name': 'Last Name is required',
                    "email": 'Email is required',
                    "phone": 'Phone is required',
                    
                }
            }).data('spValidate');
            
            this.$checkout_form.on('submit', function(e){
                e.preventDefault();
                if (!validator.isPassed()) {
                    return;
                } 

                $('#spbooking-checkout-proceed').html('Processing....')

                let data = $(this).serializeArray();
                let cartData = localStorage.getItem('accomodation_cart') || false;
                if (cartData) {
                    cartData = JSON.parse(cartData);
                    cartData = typeof(cartData) == 'object' && Object.keys(cartData).length > 0 ? cartData : false;
                }               

                // prepare booking data
                if (cartData) {
                    let rooms = [];
                    let n_o_rooms = {};
                    let checkin, checkout;
                    let i = 0;
                    Object.values(cartData).map((value) => {
                        if (i == 0) {
                            checkin = value.checkin;
                            checkout = value.checkout;
                        }
                        rooms.push(value.room_id);
                        n_o_rooms['number_of_rooms' + i] = {
                            room: value.room_id,
                            norooms: value.n_rooms
                        };
                        i++;
                    });
                  
                    if (rooms.length > 0){
                        data.push({name: 'room_id', value: JSON.stringify(rooms)});
                    }
                    if (Object.keys(n_o_rooms).length > 0){
                        data.push({name: 'number_of_rooms', value: JSON.stringify(n_o_rooms)});
                    }
                    data.push({name: 'booking_for',     value: 'room'});
                    data.push({name: 'checkin',         value: checkin});
                    data.push({name: 'checkout',        value: checkout});
                    data.push({name: 'cartData',        value: JSON.stringify(cartData)});
                } else {
                    window.location.href=rooturl;
                }

                // submit data by ajax
                let url = rooturl + 'index.php?option=com_spbooking&task=checkout.submitBookingDataForRooms';
                self.sendRequest(url, data)
                .then((response) => {
                    response = typeof(response) == 'string' && response.length > 0 ? JSON.parse(response) : false;
                    if (!!response) {
                        if (response.status_code == 202) {
                            window.location.href = response.content;
                        } else if (response.status_code == 200) {
                            let message = `
                                <div class='alert alert-success alert-dismissible fade show' role='alert'>
                                    <strong>Success</strong>
                                    <p>${response.content}</p>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            `;
                            self.$info_container.hide();
                            self.$message.html(message);
                            
                            // Reset the localstorage data
                            localStorage.removeItem('accomodation_cart');
                            self.$checkout_form.trigger('reset');
                        
                        } else if (response.status_code == 400) {
                            let message = `
                                <div class='alert alert-danger alert-dismissible fade show' role='alert'>
                                    <strong>Success</strong>
                                    <p>${response.content}</p>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            `;
                            self.$message.html(message);
                        }
                    }
                });
            });
        },
        unitPrice: function(priceData) {
            priceData = typeof(priceData) == 'object' && priceData instanceof Array && priceData.length > 0 ? priceData : false;
            let price = 0;
    
            if (priceData) {
                priceData.map((priceObject) => {
                    let original_price = typeof(priceObject.original_price) == 'string' && priceObject.original_price.length > 0 ? parseInt(priceObject.original_price) : 0;
                    let special_price = typeof(priceObject.special_price) == 'string' && priceObject.special_price.length > 0 ? parseInt(priceObject.special_price) : 0;
                    let child_special_price = typeof (priceObject.child_special_price) == 'string' && priceObject.child_special_price.length > 0 ? parseInt(priceObject.child_special_price) : 0;
                    let child_price = typeof (priceObject.child_price) == 'string' && priceObject.child_price.length > 0 ? parseInt(priceObject.child_price) : 0;
                    let child_val = typeof (priceObject.child_val) == 'string' && priceObject.child_val.length > 0 ? parseInt(priceObject.child_val) : 0;
                    let total_price = (child_val) ? (original_price + child_price) : original_price;

                    
                    if ((special_price) || (child_special_price && child_val)) {
                        price += (special_price > 0 && special_price < original_price) ? special_price : original_price; 

                        if (child_val) {
                            price += (child_special_price > 0 && (child_special_price < child_price)) ? child_special_price : child_price;
                        }                                                           
                    } else {
                        price += total_price;
                    }
                });
            }
            return price;
        },
        calculateRoomPrice: function(roominfo) {
            let price = this.unitPrice(roominfo.room_price) * parseInt(roominfo.n_rooms);
            return price;
        },
        calculateSubtotal: function() {
            let sum = 0;
            Object.values(this.acCartData).map((value) => {
                sum += (this.unitPrice(value.room_price) * parseInt(value.n_rooms));
            });
            return sum;
        },
        calculateTax: function() {
            return parseFloat(this.calculateSubtotal() * (this.tax / 100));
        },
        calculateTotalPrice: function() {
            return this.calculateSubtotal() + this.calculateTax();
        },

        addServiceInTaxPrice: function (sum) {
            return parseFloat((this.calculateSubtotal() + sum) * (this.tax / 100));
        },
        renderPrice: function(price) {
            if (this.options.curr_pos == 'left') {
                return this.options.currency + price;
            }
            return price + this.options.currency;
        },
        initPackageCheckout: function() {
            let self = this;
            this.flatPickersForPackage();

            let $firstName              = this.$package_form.find('input#first_name');
            let $lastName               = this.$package_form.find('input#last_name');
            let $email                  = this.$package_form.find('input#email');
            let $phone                  = this.$package_form.find('input#phone');
            let $adult                  = this.$package_form.find('input#adult');
            let $child                  = this.$package_form.find('input#child');
            let $avaibility             = this.$package_form.find('input#avaibility');

            this.submitPackageCheckoutForm();

        },
        initTransportCheckout: function() {
            let self = this;
            this.flatPickersForPackage();

            let $firstName              = this.$transport_form.find('input#first_name');
            let $lastName               = this.$transport_form.find('input#last_name');
            let $email                  = this.$transport_form.find('input#email');
            let $phone                  = this.$transport_form.find('input#phone');
            let $adult                  = this.$transport_form.find('input#adult');
            let $child                  = this.$transport_form.find('input#child');

            this.submitTransportCheckoutForm();

        },
        submitPackageCheckoutForm: function() {
            let self = this;
            let avaibility = this.$package_form.find('input#avaibility').val();
            let validator = this.$package_form.spValidate({
                rules: {
                    "first_name": 'required',
                    "last_name": 'required',
                    "email": 'required',
                    "phone": 'required',
                    "adult": 'required',
                    "child": 'required',
                    "avaibility": '',
                    "sum": 'sum',                   
                },
                messages: {
                    'first_name': 'First Name is required',
                    'last_name': 'Last Name is required',
                    "email": 'Email is required',
                    "phone": 'Phone is required',
                    "adult": 'Adult is required',
                    "child": 'If there is no child then type 0',
                    "sum": 'This Package Availability is ' + avaibility + '. As a result the Summation of Adult and Child must be ' + avaibility
                }
            }).data('spValidate');
            this.$package_form.on('submit', function(e){
                e.preventDefault();

                if (!validator.isPassed()) {
                    return;
                }

                $('#spbooking-checkout-package').html('Processing...');

                let data = $(this).serializeArray();

                let url = rooturl + 'index.php?option=com_spbooking&task=checkout.submitPackageCheckoutForm';
                
                self.sendRequest(url, data)
                .then((response) => {
                    response = typeof(response) == 'string' && response.length > 0 ? JSON.parse(response) : false;
                    
                    if (!!response) {
                        if (response.status_code == 202) {
                            window.location.href = response.content;
                        } else if (response.status_code == 400) {
                            let message = `
                                <div class='alert alert-danger alert-dismissible fade show' role='alert'>
                                    <strong>Success</strong>
                                    <p>${response.content}</p>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            `;
                            self.$package_form.hide();
                            self.$package_message.html(message);
                        } else {
                            let message = `
                                <div class='alert alert-success alert-dismissible fade show' role='alert'>
                                    <strong>Success</strong>
                                    <p>${response.content}</p>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            `;
                            self.$package_form.hide();
                            self.$package_message.html(message);
                        }
                    }
                });
            });
        },
        submitTransportCheckoutForm: function() {
            let self = this;

            let validator = this.$transport_form.spValidate({
                rules: {
                    "first_name": 'required',
                    "last_name": 'required',
                    "email": 'required',
                    "phone": 'required',
                    "adult": 'required',
                    "pickup_date": 'required',
                    "pickup_time": 'required',
                    "dropoff_date": 'required',
                    "dropoff_time": 'required',
                    "pickup_location": 'required',
                    "dropoff_location": 'required'
                },
                messages: {
                    'first_name': 'First Name is required',
                    'last_name': 'Last Name is required',
                    "email": 'Email is required',
                    "phone": 'Phone is required',
                    "adult": 'Adult is required',
                    "pickup_date": 'Pickup date is required',
                    "pickup_time": 'Pickup time is required',
                    "dropoff_date": 'Dropoff date is required',
                    "dropoff_time": 'Dropoff time is required',
                    "pickup_location": 'Pickup Location is required',
                    "dropoff_location": 'Dropoff location is required'
                }
            }).data('spValidate');

            this.$transport_form.on('submit', function(e){
                e.preventDefault();

                if (!validator.isPassed()) {
                    return;
                }

                $('#spbooking-checkout-transport').html('Processing....')

                let data = $(this).serializeArray();
                
                let url = rooturl + 'index.php?option=com_spbooking&task=checkout.submitTransportCheckoutForm';
                
                self.sendRequest(url, data)
                .then((response) => {
                    response = typeof(response) == 'string' && response.length > 0 ? JSON.parse(response) : false;
                    if (!!response) {
                        if (response.status_code == 202) {
                            window.location.href = response.content;
                        } else if (response.status_code == 400) {
                            let message = `
                                <div class='alert alert-danger alert-dismissible fade show' role='alert'>
                                    <strong>Success</strong>
                                    <p>${response.content}</p>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            `;
                            self.$transport_form.hide();
                            self.$trans_package_message.html(message);
                        } else {
                            let message = `
                                <div class='alert alert-success alert-dismissible fade show' role='alert'>
                                    <strong>Success</strong>
                                    <p>${response.content}</p>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            `;
                            self.$transport_form.hide();
                            self.$trans_package_message.html(message);
                        }
                    }
                });
            });
        },

        sendRequest: function(url, data) {
            return new Promise((resolve, reject)=>{
                $.ajax({
                    url: url,
                    method: 'POST',
                    data: data,
                    success: function(response) {
                        resolve(response);
                    },
                    error: function(err) {
                        reject(err);
                    }
                });
            });
        },

        flatPickersForPackage: function() {
            let self = this;
            // pickup date
            $('.transport-travel #pickup_date').flatpickr({
                mode: "single",
                altInput: true,
                altFormat: 'D, j M Y',
                minDate: "today",
                dateFormat: "Y-m-d",
                onChange: function(date, dateStr, extra) {
                    // dropoff date
                    if (!!dateStr) {
                        let tomorrow = new Date(dateStr);
                        $('#dropoff_date').flatpickr({
                            mode: "single",
                            altInput: true,
                            altFormat: 'D, j M Y',
                            minDate: tomorrow.setDate(tomorrow.getDate() + 1),
                            dateFormat: "Y-m-d", 
                            onChange: function(edate, edateStr, eextra) {
                                let url = rooturl + 'index.php?option=com_spbooking&task=checkout.checkTransportsAvailability';
                                let data = {
                                    id: self.options.transport_id,
                                    start: dateStr,
                                    end: edateStr
                                }
                                self.sendRequest(url, data).then(response => {
                                    response = typeof (response) == 'string' && response.length > 0 ? JSON.parse(response) : false;
                                    if (response) {
                                        if (response.status_code == 400) {
                                            $('.transport-travel button[type=submit]').prop('disabled', true);
                                            $('.transport-travel .transport-not-available-msg').html(response.content);
                                        } else if (response.status_code == 200) {
                                            $('.transport-travel button[type=submit]').prop('disabled', false);
                                            $('.transport-travel .transport-not-available-msg').html(response.content);
                                        }
                                    }
                                });
                            }
                        });
                        
                        $('#dropoff_time').flatpickr({
                            enableTime: true,
                            noCalendar: true,
                            dateFormat: "H:i"
                        });
                    }
                }
            });

            $('.package-travel #pickup_date').flatpickr({
                mode: "single",
                altInput: true,
                altFormat: 'D, j M Y',
                minDate: "today",
                dateFormat: "Y-m-d",
                onChange: function(date, dateStr, extra) {
                    // dropoff date
                    if (!!dateStr) {
                        let tomorrow = new Date(dateStr);
                        $('#dropoff_date').flatpickr({
                            mode: "single",
                            altInput: true,
                            altFormat: 'D, j M Y',
                            minDate: tomorrow.setDate(tomorrow.getDate() + 1),
                            dateFormat: "Y-m-d"
                        });
                        
                        $('#dropoff_time').flatpickr({
                            enableTime: true,
                            noCalendar: true,
                            dateFormat: "H:i",
                        });
                    }
                }
            });

            $('#pickup_time').flatpickr({
                enableTime: true,
                noCalendar: true,
                dateFormat: "H:i",
            });
        }


    });

    Number.prototype.toMoney = function() {
        return this.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
    }

    function Spdate(date) {
        this.date = date;
    }

    Spdate.prototype.format = function(format) {
        const longMonths = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
        const shortMonths = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
        let date = typeof(this.date) == 'string' && this.date.length > 0 ? new Date(this.date) : this.date;
        format = typeof(format) == 'object' && Object.keys(format).length > 0 ? format : false;
        
        let str = date.getDay() + ' ' + longMonths[parseInt(date.getMonth())] + ', ' + date.getFullYear();
        return str;
    }

    $.fn.spCheckout = function(options) {
        this.each(function() {
            if (!$.data(this, name)) {
                $.data(this, name, new Plugin(this, options));
            }
        });
        return this;
    };

    $.fn.spCheckout.defaults = {
        currency: '$',
        curr_pos: 'left',
        total_text: 'Total',
        subtotal_text: 'Sub Total',
        additional_service: 'Additional Service(s)',
        tax: 15,
        tax_text: 'Tax',
        accomodation_id: 0,
        package_id: 0,
        transport_id: 0,
    };
})(jQuery, window, document);