jQuery(function($) {
    let $feedback_form = $('#feedback-form');
    $feedback_form.on('submit', function(e) {
        e.preventDefault();
        let data = $(this).serializeArray();
        $.ajax({
            method: 'POST',
            url: feedbackUrl,
            dataType: 'json',
            data: data,
            success: function(response) {
                response = typeof(response) == 'number' && response ? response : false;
                if (response) {
                    location.reload();
                }
            }
        })
    });

    // Adding review class to the rating section
    let list = document.querySelectorAll('.review-list-item-title');
    let inputValue, divElement = '';

    if (list && list.length > 0) {
        list.forEach(element => {
            inputValue = element.getAttribute('data-alias');

            divElement = document.createElement('div');
            divElement.classList.add(inputValue);
            divElement.style.cssText = 'width: 70%; float: left; margin: 8px;'

            element.insertAdjacentElement('afterend',divElement);

            $('.' + inputValue).spReview({
                input_name: inputValue
            });
        });
    }
});