jQuery(function($){
    var accomodation_id = $('.accomodation-available-rooms').find('.accomodation-id').val();
    var accomodation_slug = $('.accomodation-available-rooms').find('.accomodation-slug').val();

    // check a cart data already provided for this accomodation.
    // If the cart data is for this accomodation then continue, remove the cart data otherwise
    let cdata = localStorage.getItem('accomodation_cart') || false;
    let cart_checkin, cart_checkout;
    if (cdata) {
        cdata = JSON.parse(cdata);
        Object.keys(cdata).map((key) => {
            if (cdata[key].aid != accomodation_id) {
                localStorage.removeItem('accomodation_cart');
                return;
            } else {
                cart_checkin = cdata[key].checkin;
                cart_checkout = cdata[key].checkout;
                return;
            }
        });

        Object.keys(cdata).map((key) => {
            if (cdata[key].aid == accomodation_id) {
                $room_info_element = $('.rooms-info-body#room-' + cdata[key].room_id);
                if (typeof(cdata[key].adult) != 'undefined' && cdata[key].adult) {
                    $room_info_element.find('.accomodation-room-adult').val(cdata[key].adult);
                }
                if (typeof(cdata[key].child) != 'undefined' && cdata[key].child) {
                    $room_info_element.find('.accomodation-room-child').val(cdata[key].child);
                }
                if (typeof(cdata[key].n_rooms) != 'undefined' && cdata[key].n_rooms) {
                    $room_info_element.find('.select-nrooms').val(cdata[key].n_rooms);
                }
            }
        });

    }

    // render cart info at the page init
    updateCartInfo();

    // Accomodation detail page availability date range
    let $date_range = $('.accomodation-checkin-out-range');
    let today, tomorrow;
    today       = typeof($date_range.data('checkin')) == 'string' && $date_range.data('checkin').length > 0 ? $date_range.data('checkin') : false;
    tomorrow    = typeof($date_range.data('checkout')) == 'string' && $date_range.data('checkout').length > 0 ? $date_range.data('checkout') : false;

    // IF checkin not in the url but in the cart data then replaced the checkin data by cartdata
    let q = new URLSearchParams(window.location.search);
    if (!q.has('checkin')) {
        if (!!cart_checkin) {
            today = cart_checkin;
        }
    }
    if (!q.has('checkout')) {
        if (!!cart_checkout) {
            tomorrow = cart_checkout;
        }
    }
    
    let checkin     = $date_range.data('checkin');
    let checkout    = $date_range.data('checkout');
    
    $date_range.flatpickr({
        mode: "range",
        altInput: true,
        altFormat: 'D, j M Y',
        minDate: "today",
        dateFormat: "Y-m-d",
        defaultDate: [today, tomorrow],
        onChange: function(selectedDates, dateStr, instance) {
            let dates = dateStr.split(" to ");
            dates = typeof(dates) == 'object' && dates instanceof Array && dates.length > 0 ? dates: false;
            if (dates && dates.length == 2) {
                $date_range.data('checkin', dates[0]);
                $date_range.data('checkout', dates[1]);
                cdata = localStorage.getItem('accomodation_cart') || false;
                if (cdata) {
                    cdata = JSON.parse(cdata);
                    Object.keys(cdata).map((key) => {
                        cdata[key].checkin = dates[0];
                        cdata[key].checkout = dates[1];

                        let cin = new Date(dates[0]);
                        let cout = new Date(dates[1]);
                        let tDiff = Math.abs(cout.getTime() - cin.getTime());
                        let nights = Math.ceil(tDiff / (1000 * 3600 * 24));
                        cdata[key].nights = nights;
                    });
                    
                    localStorage.setItem('accomodation_cart', JSON.stringify(cdata));
                }
                updateUrl();
            }
        }
    });

    function updateUrl() {
        let query   = new URLSearchParams(window.location.search);
        
        checkin     = $date_range.data('checkin');
        checkout    = $date_range.data('checkout');

        if (query.has('checkin')) {
            query.set('checkin', checkin);
        } else {
            query.append('checkin', checkin);
        }

        if (query.has('checkout')) {
            query.set('checkout', checkout);
        } else {
            query.append('checkout', checkout);
        }
        // console.log(query.toString()); return;
        window.location.href = rooturl + 'index.php?option=com_spbooking&view=accomodation&id=' + accomodation_slug + query.toString() + "#available-rooms";
    }

    // Booknow functionality
    let $room_booknow = $('.spbooking-room-booknow');
    var accomodation_cart_data = cdata;
    $room_booknow.on('click', function(e){
        e.preventDefault();
        let $room_info      = $(this).parents('.rooms-info-body');
        let $room_adult     = $room_info.find('.accomodation-room-adult');
        let $room_child     = $room_info.find('.accomodation-room-child');
        let $n_rooms        = $room_info.find('.select-nrooms');
        let $room_id        = $room_info.find('.accomodation-room-id');
        let $room_price     = $room_info.find('.accomodation-room-price');
        let $room_title     = $room_info.find('.accomodation-room-title');
        
        let room_id_val     = typeof($room_id.val()) == 'string' && $room_id.val().length > 0 ? $room_id.val() : false;
        let room_price_val  = typeof($room_price.val()) == 'string' && $room_price.val().length > 0 ? JSON.parse(atob($room_price.val())) : false;
        let n_rooms_val     = typeof($n_rooms.val()) == 'string' && $n_rooms.val().length > 0 ? $n_rooms.val() : false;
        let room_child_val  = typeof($room_child.val()) == 'string' && $room_child.val().length > 0 ? $room_child.val() : false;
        let room_adult_val  = typeof($room_adult.val()) == 'string' && $room_adult.val().length > 0 ? $room_adult.val() : false;
        let room_title_val  = typeof($room_title.val()) == 'string' && $room_title.val().length > 0 ? $room_title.val() : false;
        let data = {};

        if (accomodation_id) {
            data.aid = accomodation_id;
        }

        if (room_id_val) {
            data.room_id = room_id_val;
        }
        
        if (room_price_val) {
            // Adding child_val in room_price_val
            room_price_val[0].child_val = room_child_val;
            data.room_price = room_price_val;
        }
        
        if (n_rooms_val) {
            data.n_rooms = n_rooms_val;
        }
        
        if (room_child_val) {
            data.child = room_child_val;
        }
        
        if (room_adult_val) {
            data.adult = room_adult_val;
        }

        if (checkin) {
            data.checkin = checkin;
        }
        
        if (checkout) {
            data.checkout = checkout;
        }

        if (room_title_val) {
            data.room_title = room_title_val;
        }

        let diffDays = 0;

        if (checkin && checkout) {
            checkin = new Date(checkin);
            checkout = new Date(checkout);
            let timeDiff = Math.abs(checkout.getTime() - checkin.getTime());
            diffDays = Math.ceil(timeDiff / (1000 * 3600 * 24)); 
        }

        if (diffDays) {
            data.nights = diffDays.toString();
        }

        if (Object.keys(data).length > 0) {
            accomodation_cart_data["room" + room_id_val] = data;
        }
        if (Object.keys(accomodation_cart_data).length > 0 && !!accomodation_id) {
            localStorage.setItem('accomodation_cart', JSON.stringify(accomodation_cart_data));
        }
        updateCartInfo();
    });


    function updateCartInfo() {
        let cartData = localStorage.getItem('accomodation_cart') || false;
        if (cartData) cartData = JSON.parse(cartData);
        
        cartData = typeof(cartData) == 'object' && Object.keys(cartData).length > 0 ? cartData : false;
        $('.accomodation-cart .cart-body').empty();
        $('.accomodation-cart .cart-header').html(`<strong>Price: ${renderPrice(calculateTotalPrice(cartData)[0]) || renderPrice(0)}</strong><br><strong>${'Rooms: ' + calculateTotalPrice(cartData)[1] || 0 }</strong>`);
        if (cartData) {
            $('.accomodation-cart').show();
            Object.keys(cartData).map((key) => {
                let cartContent = `
                    <div class='spbooking-row cart-content-wrapper'>
                        <div class='spbooking-col-8'>
                            ${typeof(cartData[key].room_title) != 'undefined' && cartData[key].room_title ? `<p class='room-title'>${cartData[key].room_title}</p>` : ``}
                            ${typeof(cartData[key].n_rooms) != 'undefined' && cartData[key].n_rooms ? `<small class='text-mute'>${cartData[key].n_rooms + ' Rooms'} x</small>` : ``}
                            ${typeof(cartData[key].nights) != 'undefined' && cartData[key].nights && `<small class='text-mute'>${cartData[key].nights + ' Nights'}</small>`}
                            <div>
                                ${typeof(cartData[key].adult) != 'undefined' && cartData[key].adult && `<small class='text-mute'>${cartData[key].adult + ' Adult'} </small>`}
                                ${typeof(cartData[key].child) != 'undefined' && cartData[key].child ? `<small class='text-mute'> x ${cartData[key].child + ' Child'}</small>` : ``}
                            </div>
                        </div>
                        <div class='spbooking-col-4'>
                            <span class="price">
                            ${renderPrice(calculateUnitPrice(cartData[key].room_price) * parseInt(cartData[key].n_rooms))}
                            </span>
                            <span class='remove-from-cart fa fa-times-circle text-red' data-key='${key}'></span>
                        </div>
                    </div>
                `;
                $('.accomodation-cart .cart-body').append(cartContent);
            });
            $('.accomodation-cart .cart-body').append(`<button class='btn btn-success btn-block continue-to-checkout' type='button'>Continue</button>`);
        } else {
            $('.accomodation-cart').hide();
            localStorage.removeItem('accomodation_cart');
            accomodation_cart_data = {};
            cdata = {};
        }
    }

    // Remove content from cart
    $(document).on('click', '.accomodation-cart .cart-body .remove-from-cart', function(e){
        e.preventDefault();
        removeFromCart($(this).data('key'));
    });

    //Continue to checkout
    $(document).on('click', '.accomodation-cart .cart-body .continue-to-checkout', function(e){
        e.preventDefault();
        let checkout_link = 'index.php?option=com_spbooking&view=checkout&checkout_for=accomodation&accomodation_id=' + accomodation_id;
        window.location.href = rooturl + checkout_link;
    });

    function removeFromCart(key) {
        let cartData = localStorage.getItem('accomodation_cart') || false;
        if (!!cartData) {
            cartData = JSON.parse(cartData);
            delete cartData[key];
            cartData = JSON.stringify(cartData);
            localStorage.setItem('accomodation_cart', cartData);
            updateCartInfo();
        }
    }

    function calculateUnitPrice(priceData) {
        priceData = typeof(priceData) == 'object' && priceData instanceof Array && priceData.length > 0 ? priceData : false;
        let price = 0;
        if (priceData) {
            priceData.map((priceObject) => {
                let original_price = typeof(priceObject.original_price) == 'string' && priceObject.original_price.length > 0 ? parseInt(priceObject.original_price) : 0;
                let special_price  = typeof(priceObject.special_price) == 'string' && priceObject.special_price.length > 0 ? parseInt(priceObject.special_price) : 0;
                let child_special_price = typeof (priceObject.child_special_price) == 'string' && priceObject.child_special_price.length > 0 ? parseInt(priceObject.child_special_price) : 0;
                let child_price    = typeof(priceObject.child_price) == 'string' && priceObject.child_price.length > 0 ? parseInt(priceObject.child_price) : 0;
                let child_val      = typeof (priceObject.child_val) == 'string' && priceObject.child_val.length > 0 ? parseInt(priceObject.child_val) : 0;
                let total_price    = (child_val) ? (original_price+child_price) : original_price;

                if ((special_price) || (child_special_price) ){
                    price += (special_price > 0 && special_price < original_price) ? special_price : original_price;
               
                    price += (child_special_price > 0 && child_special_price < child_price && child_val) ? child_special_price : (child_val) ? child_price : 0;
              
                }               
                else {
                    price += total_price;
                }
                
            });
        }
        return price;
    }

    function renderPrice(price) {
        if (curr_pos == 'left') {
            return currency + price;
        }
        return price + currency;
    }

    function calculateTotalPrice(cartData) {
        let sum = 0;
        let rooms = 0;
        Object.keys(cartData).map((key) => {
            let nightXroom = parseInt(cartData[key].n_rooms);
            sum += calculateUnitPrice(cartData[key].room_price) * nightXroom;
            rooms += parseInt(cartData[key].n_rooms);
        });
        return [sum, rooms];
    }

    // toggle cart
    $('.cart-close').on('click', function(e){
        e.preventDefault();
        let $cart = $(this).parents('.accomodation-cart');
        $cart.find('.cart-body').slideToggle();
        $cart.find('.cart-header').slideToggle();
    });



});