<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:html="http://www.w3.org/TR/REC-html40" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1" xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>XML Sitemap</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<style type="text/css">
					body {
						font-family: Helvetica, Arial, sans-serif;
						font-size: 13px;
						color: #545353;
					}
					table {
						border: none;
						border-collapse: collapse;
					}
					#sitemap tr:nth-child(odd) td {
						background-color: #eee !important;
					}
					#sitemap tbody tr:hover td {
						background-color: #ccc;
					}
					#sitemap tbody tr:hover td, #sitemap tbody tr:hover td a {
						color: #000;
					}
					#content {
						margin: 0 auto;
						width: 1000px;
					}
					.info {
						margin: 18px 3px;
						line-height: 2.0em;
					}
					.info a {
						color: #da3114;
						font-weight: 600;
					}
					.info a:visited {
						color: #da3114;
					}
					a {
						color: #000;
						text-decoration: none;
					}
					a:visited {
						color: #777;
					}
					a:hover {
						text-decoration: underline;
					}
					td {
						font-size:11px;
					}
					th {
						text-align:left;
						padding-right:30px;
						font-size:11px;
					}
					thead th {
						border-bottom: 1px solid #000;
					}
				</style>
			</head>
			<body>
				<div id="content">
					<h1>XML Sitemap</h1>
					<p class="info">
						This sitemap was generated using <a href="https://www.rsjoomla.com/joomla-extensions/joomla-seo.html" target="_blank">RSSeo!</a> <br/>
						You can find more information about XML sitemaps on <a href="http://sitemaps.org" target="_blank" rel="noopener noreferrer">sitemaps.org</a>. <br/>
						This XML Sitemap contains <strong><xsl:value-of select="count(sitemap:urlset/sitemap:url)"/></strong> URLs.
						<xsl:if test="sitemap:urlset/sitemap:url/image:image"><br /> This XML Sitemap contains <strong><xsl:value-of select="count(sitemap:urlset/sitemap:url/image:image)"/></strong> Images</xsl:if>
					</p>
					
					<table id="sitemap" cellpadding="3">
						<thead>
						<tr>
							<th width="65%">URL</th>
							<th>
								<xsl:if test="sitemap:urlset/sitemap:url/image:image">Images</xsl:if>
							</th>
							<th width="10%">Priority</th>
							<th width="10%">Change Freq.</th>
							<th width="10%">Last Mod.</th>
						</tr>
						</thead>
						<tbody>
						<xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>
						<xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
						<xsl:for-each select="sitemap:urlset/sitemap:url">
							<tr>
								<td>
									<xsl:variable name="itemURL">
										<xsl:value-of select="sitemap:loc"/>
									</xsl:variable>
									<a href="{$itemURL}">
										<xsl:value-of select="sitemap:loc"/>
									</a>
								</td>
								<td>
									<xsl:if test="current()/image:image">
										<xsl:value-of select="count(image:image)"/>
									</xsl:if>
								</td>
								<td>
									<xsl:if test="sitemap:priority &gt; 0">
										<xsl:value-of select="concat(sitemap:priority*100,'%')"/>
									</xsl:if>
								</td>
								<td>
									<xsl:value-of select="concat(translate(substring(sitemap:changefreq, 1, 1),concat($lower, $upper),concat($upper, $lower)),substring(sitemap:changefreq, 2))"/>
								</td>
								<td>
									<xsl:value-of select="concat(substring(sitemap:lastmod,0,11),concat(' ', substring(sitemap:lastmod,12,5)),concat(' ', substring(sitemap:lastmod,20,6)))"/>
								</td>
							</tr>
						</xsl:for-each>
						</tbody>
					</table>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>