<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

class RSPageBuilderViewPages extends HtmlView {

	public function display($tpl = null)
	{
		$doc				= Factory::getDocument();
		$app				= Factory::getApplication();
		$menus				= $app->getMenu();
		$menu				= $menus->getActive();
		$bootstrap_versions	= array();
		
		$this->jversion		= RSPageBuilderHelper::getJoomlaVersion();
		$this->items 		= $this->get('Items');
		$this->state		= $this->get('State');
		$this->pagination	= $this->get('Pagination');
		$this->total		= $this->get('Total');
		$this->params		= $this->state->get('params');

		if (count($this->items)) {
			foreach ($this->items as $page) {
				$bootstrap_versions[] = $page->bootstrap_version;
			}
			
			// Get the highest number of pages with the same Bootstrap version
			$this->bootstrap_version = array_search(max(array_count_values($bootstrap_versions)), array_count_values($bootstrap_versions));
			
			// Load jQuery files
			HTMLHelper::_('jquery.framework', true, null, true);

			// Load CSS files
			RSPageBuilderHelper::loadAsset('component', 'font-awesome.min.css');
			RSPageBuilderHelper::loadAsset('component', 'style-bs' . $this->bootstrap_version . '.css');
			
			// Load JS files
			$doc->addScriptDeclaration('var rspbld_jversion = '.$this->jversion.';');
			RSPageBuilderHelper::loadAsset('component', 'rspagebuilder.js');
			
			// Messages translations
			Text::script('COM_RSPAGEBUILDER_COUNTDOWN_TIMER_EXPIRED');
			
			Text::script('WARNING');
			
			// Elements fields translations
			Text::script('COM_RSPAGEBUILDER_LONG_DAY');
			Text::script('COM_RSPAGEBUILDER_LONG_DAYS');
			Text::script('COM_RSPAGEBUILDER_LONG_HOUR');
			Text::script('COM_RSPAGEBUILDER_LONG_HOURS');
			Text::script('COM_RSPAGEBUILDER_LONG_MINUTE');
			Text::script('COM_RSPAGEBUILDER_LONG_MINUTES');
			Text::script('COM_RSPAGEBUILDER_LONG_SECOND');
			Text::script('COM_RSPAGEBUILDER_LONG_SECONDS');
			Text::script('COM_RSPAGEBUILDER_SHORT_DAYS');
			Text::script('COM_RSPAGEBUILDER_SHORT_HOURS');
			Text::script('COM_RSPAGEBUILDER_SHORT_MINUTES');
			Text::script('COM_RSPAGEBUILDER_SHORT_SECONDS');
			
			// Check for errors
			if (count($errors = $this->get('Errors'))) {
				throw new \Exception(implode("\n", $errors), 500);
			}
			
			parent::display($tpl);
		} else {
			$app->enqueueMessage(Text::_('COM_RSPAGEBUILDER_NO_PAGES_FOUND'), 'warning');
		}
	}
}