<?php
/**
 * @package RSPageBuilder!
 * @copyright (C) 2016 - 2024 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

// No direct access
defined ('_JEXEC') or die ('Restricted access');

use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

class RSPageBuilderViewPage extends HtmlView {

	public function display($tpl = null) {
		$doc						= Factory::getDocument();
		$app						= Factory::getApplication();
		$menus						= $app->getMenu();
		$menu						= $menus->getActive();

		$this->jversion				= RSPageBuilderHelper::getJoomlaVersion();
		$this->page 				= $this->get('Item');
		$this->state				= $this->get('State');
		$this->pageclass_sfx		= '';
		$this->show_page_heading	= '';
		$this->page_heading			= 0;
		
		// Load Bootstrap files
		if ($this->page->bootstrap_version == 2 || $this->page->bootstrap_version == 5) {
			HTMLHelper::_('bootstrap.framework');
			HTMLHelper::_('bootstrap.loadCss', true, $doc->direction);
		}

		// Load jQuery files
		HTMLHelper::_('jquery.framework', true, null, true);

		// Load CSS files
		RSPageBuilderHelper::loadAsset('component', 'font-awesome.min.css');
		RSPageBuilderHelper::loadAsset('component', 'style-bs' . $this->page->bootstrap_version . '.css');
		
		// Load JS files
		$doc->addScriptDeclaration('var rspbld_jversion = ' . $this->jversion . ',
			rspbld_bversion = ' . $this->page->bootstrap_version . ';');
		RSPageBuilderHelper::loadAsset('component', 'rspagebuilder.js');
		
		// Messages translations
		Text::script('COM_RSPAGEBUILDER_COUNTDOWN_TIMER_EXPIRED');
		
		Text::script('WARNING');
		
		// Elements fields translations
		Text::script('COM_RSPAGEBUILDER_LONG_DAY');
		Text::script('COM_RSPAGEBUILDER_LONG_DAYS');
		Text::script('COM_RSPAGEBUILDER_LONG_HOUR');
		Text::script('COM_RSPAGEBUILDER_LONG_HOURS');
		Text::script('COM_RSPAGEBUILDER_LONG_MINUTE');
		Text::script('COM_RSPAGEBUILDER_LONG_MINUTES');
		Text::script('COM_RSPAGEBUILDER_LONG_SECOND');
		Text::script('COM_RSPAGEBUILDER_LONG_SECONDS');
		Text::script('COM_RSPAGEBUILDER_SHORT_DAYS');
		Text::script('COM_RSPAGEBUILDER_SHORT_HOURS');
		Text::script('COM_RSPAGEBUILDER_SHORT_MINUTES');
		Text::script('COM_RSPAGEBUILDER_SHORT_SECONDS');

		// Active menu item
		if ($menu) {
			$this->menu_params			= $this->state->get('parameters.menu');
			$this->pageclass_sfx 		= $this->menu_params->get('pageclass_sfx');
			$this->show_page_heading	= $this->menu_params->get('show_page_heading');
			$this->page_heading 		= $this->menu_params->get('page_heading');
		}
		
		// Check for errors
		if (count($errors = $this->get('Errors'))) {
			throw new \Exception(implode("\n", $errors), 500);
		}
		if ($this->page->access_view == false) {
			throw new \Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		// Clear search
		$app->setUserState('rspagebuilder.search', '');
		
		$this->prepareDocument();
		parent::display($tpl);
	}

	protected function prepareDocument() {
		$config						= Factory::getConfig();
		$app						= Factory::getApplication();
		$doc 						= Factory::getDocument();
		$menus						= $app->getMenu();
		$menu						= $menus->getActive();
		$this->menu_params			= $this->state->get('parameters.menu');
		$title						= ($menu ? $this->menu_params->get('page_title', '') : '');
		
		if (empty($title)) {
			$title = $this->page->title;
		}
		
		// Set page title
		$page_title = $title;
		if ($config->get('sitename_pagetitles') == 2) {
			$page_title = $title . ' | ' . $config->get('sitename');
		} elseif ($config->get('sitename_pagetitles') == 1) {
			$page_title = $config->get('sitename') . ' | ' . $title;
		}
		$doc->setTitle($page_title);
		
		// Open Graph meta tags
		$open_graph_title = $this->page->open_graph_title ? $this->page->open_graph_title : $title;
		$doc->setMetadata('og:title', $open_graph_title, 'property');
		$doc->setMetadata('og:type', 'website', 'property');
		
		if ($this->page->open_graph_image) {
			$doc->setMetadata('og:image', Uri::root() . $this->page->open_graph_image, 'property');
		}
		if ($this->page->open_graph_description) {
			$doc->setMetadata('og:description', $this->page->open_graph_description, 'property');
		}
		$doc->setMetadata('og:url', Uri::current(), 'property');
		
		if ($this->page->metadesc) {
			$doc->setDescription($this->page->metadesc);
		} else if ($menu && $this->menu_params->get('menu-meta_description')) {
			$doc->setDescription($this->menu_params->get('menu-meta_description'));
		}
		
		if ($this->page->metakey) {
			$doc->setMetadata('keywords', $this->page->metakey);
		} else if ($menu && $this->menu_params->get('menu-meta_keywords')) {
			$doc->setMetadata('keywords', $this->menu_params->get('menu-meta_keywords'));
		}
		
		if ($this->page->robots) {
			$doc->setMetadata('robots', $this->page->robots);
		} else if ($menu && $this->menu_params->get('robots')) {
			$doc->setMetadata('robots', $this->menu_params->get('robots'));
		}
	}
}