/**
 * @package   	JCE
 * @copyright 	Copyright (c) 2009-2022 Ryan Demmer. All rights reserved.
 * @license   	GNU/GPL 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * JCE is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

/* global jQuery */

(function ($) {
    var tinymce = {
        settings: {
            language: "en",
            document_base_url: ""
        },

        i18n: {},

        /**
         * Adds a language pack
         *
         * @method addI18n
         * @param {String} p Prefix for the language items. For example en.myplugin
         * @param {Object} o Name/Value collection with items to add to the language group.
         * @source TinyMCE EditorManager.js
         * @copyright Copyright 2009, Moxiecode Systems AB
         * @licence GNU / LGPL 2 - http://www.gnu.org/copyleft/lesser.html
         *
         * Modified for JQuery
         */
        addI18n: function (p, o) {
            var i18n = this.i18n;

            if ($.type(p) == 'string') {
                $.each(o, function (k, o) {
                    i18n[p + '.' + k] = o;
                });
            } else {
                $.each(p, function (lc, o) {
                    $.each(o, function (g, o) {
                        $.each(o, function (k, o) {
                            if (g == 'common') {
                                i18n[lc + '.' + k] = o;
                            } else {
                                i18n[lc + '.' + g + '.' + k] = o;
                            }
                        });

                    });

                });
            }
        },

        getLang: function (n, dv) {
            return this.i18n[this.settings.language + '.' + n] || dv;
        },

        convertURL: function (src) {
            return src;
        },

        documentBaseURI: {
            toAbsolute: function (url) {
                if (/:\/\//.test(url)) {
                    return url;
                }

                // remove leading slash
                url = url.replace(/^\//, '');

                var root = tinymce.settings.document_base_url;

                // remove trailing slash
                root = root.replace(/\/$/, '');

                // join and return
                return root + '/' + url;
            },

            toRelative: function (url) {
                if (/:\/\//.test(url)) {
                    var base = tinymce.settings.document_base_url;
                    return url.replace(new RegExp('^' + base), '');
                }

                return url;
            }
        },

        windowManager: {
            params: {
                window: window.parent,
                callback: function (selected, data) {
                    var win = window.parent, values = data[0], url = values.url;

                    var elm = win.document.getElementById(tinymce.settings.element);

                    // Joomla 3.5.x / 4.x Media Field
                    var $wrapper = win.jQuery(elm).parents('.field-media-wrapper'),
                        inst = $wrapper.data('fieldMedia') || $wrapper.get(0);

                    if (inst && inst.setValue) {
                        return inst.setValue(url);
                    }

                    win.jQuery(elm).val(url).trigger('change');
                }
            },

            // Open a modal window . This is only used from inside an existing modal, eg: Help or Image Editor
            open: function (args, params) {
                var $ = jQuery;

                args.url += '&' + tinymce.settings.token + '=1&standalone=1';

                var div = $('<div class="uk-inline-help uk-modal" />');

                var html = '' +
                    '<div class="uk-modal-dialog uk-modal-dialog-blank">' +
                    '	<button class="uk-modal-close uk-close"></button>' +
                    '	<div class="uk-modal-header"><h3><strong>' + (args.title || "") + '</strong></h3></div>' +
                    '	<iframe src="' + args.url + '" frameborder="0"></iframe>' +
                    '</div>';

                $(div).html(html).find('.uk-close').on('click', function (e) {
                    e.preventDefault();
                    $(div).removeClass('uk-open').delay(150).remove();
                });

                $(div).appendTo('body').addClass('uk-open').show();

                // store params
                tinymce.windowManager.params = params;
            },

            // Close a modal window opened using a Joomla Modal method.
            close: function () {
                var win = window.parent;

                if (win.Joomla && win.Joomla.Modal) {
                    return win.Joomla.Modal.getCurrent().close();
                }

                // legacy modal
                if (win.jModalClose) {
                    win.jModalClose();
                }

                if (win.SqueezeBox) {
                    win.SqueezeBox.close();
                }

                // Joomla 3.5.x / 4.x Media Field
                win.jQuery('.modal.in [data-dismiss]').trigger('click');
            }
        },

        getParam: function (n, dv) {
            var v = this.settings[n];
            return (typeof v !== "undefined") ? v : dv;
        }
    };

    window.tinyMCE = window.tinymce = tinymce;
})(jQuery);