<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Component\ComponentHelper;

class SpbookingViewReviews extends HtmlView
{
	protected $items;

	protected $state;

	protected $pagination;

	protected $model;

	public $filterForm, $activeFilters;

	public $cParams;

	public function display($tpl = null)
	{
		$this->items			= $this->get('Items');
		$this->state			= $this->get('State');
		$this->pagination		= $this->get('Pagination');
		$this->model			= $this->getModel('reviews');
		$this->filterForm		= $this->get('FilterForm');
		$this->activeFilters	= $this->get('ActiveFilters');
		$this->cParams 			= ComponentHelper::getParams('com_spbooking');

		SpbookingHelper::addSubmenu('reviews');

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode('<br>', $errors), 500);

			return false;
		}

		foreach ($this->items as $key => &$item)
		{
			if ($item->reviewed_for == 'accomodation')
			{
				$item->title = $this->model->getReviewFor($item->reviewed_for, $item->accomodation_id);
			}
			elseif ($item->reviewed_for == 'package')
			{
				$item->title = $this->model->getReviewFor($item->reviewed_for, $item->package_id);
			}
			elseif ($item->reviewed_for == 'transport')
			{
				$item->title = $this->model->getReviewFor($item->reviewed_for, $item->transport_id);
			}
			elseif ($item->reviewed_for == 'place')
			{
				$item->title = $this->model->getReviewFor($item->reviewed_for, $item->place_id);
			}

			$item->rating_value = $this->displayRating($this->ratingValue($item->advance_rating));
		}

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();

		return parent::display($tpl);
	}

	private function ratingValue($advance_rating)
	{
		// Advance rating system
		$result = array();

		if (!empty($advance_rating) && is_string($advance_rating))
		{
			$result = json_decode($advance_rating, true);
		}

		$avg = 0;
		$sum = 0;

		if (!empty($result))
		{
			foreach ($result as $v)
			{
				$sum += (int) $v;
			}
		}

		if (count($result) > 0)
		{
			$avg = $sum / count($result);
		}

		return $avg;
	}

	private function displayRating($rating)
	{
		$html = array();
		$html[] = "<div class='star-display-wrapper'>";

		for ($i = 1; $i <= 5; $i++)
		{
			if ($i <= $rating)
			{
				$html[] = "<span class='fa fa-star is-filled'></span>";
			}
			elseif ($i > $rating && $rating > $i - 1)
			{
				$html[] = "<span class='fa fa-star-half-o is-filled'></span>";
			}
			else
			{
				$html[] = "<span class='fa fa-star-o'></span>";
			}
		}

		$html[] = "</div>";

		return implode("\n", $html);
	}

	protected function addToolbar()
	{
		$state	= $this->get('State');
		$canDo	= SpbookingHelper::getActions('com_spbooking', 'component');
		$user	= Factory::getUser();
		$bar	= Toolbar::getInstance('toolbar');

		if ($canDo->get('core.create'))
		{
			ToolbarHelper::addNew('review.add');
		}

		if ($canDo->get('core.edit'))
		{
			ToolbarHelper::editList('review.edit');
		}

		if ($canDo->get('core.edit.state'))
		{
			ToolbarHelper::publish('reviews.publish', 'JTOOLBAR_PUBLISH', true);
			ToolbarHelper::unpublish('reviews.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			ToolbarHelper::archiveList('reviews.archive');
			ToolbarHelper::checkin('reviews.checkin');
		}

		if ($state->get('filter.published') == -2 && $canDo->get('core.delete'))
		{
			ToolbarHelper::deleteList('', 'reviews.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
		elseif ($canDo->get('core.edit.state'))
		{
			ToolbarHelper::trash('reviews.trash');
		}

		if ($canDo->get('core.admin'))
		{
			ToolbarHelper::preferences('com_spbooking');
		}

		JHtmlSidebar::setAction('index.php?option=com_spbooking&view=reviews');
		ToolbarHelper::title(Text::_('COM_SPBOOKING_REVIEWS_TITLE'), '');
	}
}

