<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class SpbookingViewPackageTypes extends HtmlView
{
	protected $items;

	protected $state;

	protected $pagination;

	protected $model;

	public $filterForm, $activeFilters;

	public function display($tpl = null)
	{
		$this->items            = $this->get('Items');
		$this->state            = $this->get('State');
		$this->pagination        = $this->get('Pagination');
		$this->filterForm        = $this->get('FilterForm');
		$this->activeFilters    = $this->get('ActiveFilters');

		SpbookingHelper::addSubmenu('packagetypes');

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode('<br>', $errors), 500);

			return false;
		}

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();

		return parent::display($tpl);
	}

	protected function addToolbar()
	{
		$state    = $this->get('State');
		$canDo    = SpbookingHelper::getActions('com_spbooking', 'component');
		$user    = Factory::getUser();
		$bar    = Toolbar::getInstance('toolbar');

		if ($canDo->get('core.create'))
		{
			ToolbarHelper::addNew('packagetype.add');
		}

		if ($canDo->get('core.edit'))
		{
			ToolbarHelper::editList('packagetype.edit');
		}

		if ($canDo->get('core.edit.state'))
		{
			ToolbarHelper::publish('packagetypes.publish', 'JTOOLBAR_PUBLISH', true);
			ToolbarHelper::unpublish('packagetypes.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			ToolbarHelper::archiveList('packagetypes.archive');
			ToolbarHelper::checkin('packagetypes.checkin');
		}

		if ($state->get('filter.published') == -2 && $canDo->get('core.delete'))
		{
			ToolbarHelper::deleteList('', 'packagetypes.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
		elseif ($canDo->get('core.edit.state'))
		{
			ToolbarHelper::trash('packagetypes.trash');
		}

		if ($canDo->get('core.admin'))
		{
			ToolbarHelper::preferences('com_spbooking');
		}

		JHtmlSidebar::setAction('index.php?option=com_spbooking&view=packagetypes');
		ToolbarHelper::title(Text::_('COM_SPBOOKING_PACKAGETYPES_TITLE'), '');
	}
}
