<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class SpbookingViewDashboard extends HtmlView
{
	protected $state;

	protected $model;

	public function display($tpl = null)
	{
		$this->state			= $this->get('State');
		$this->model			= $this->getModel('dashboard');

		SpbookingHelper::addSubmenu('dashboard');

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode('<br>', $errors), 500);

			return false;
		}

		// Get count of total published accomodations, packages, transports, places
		$this->total_accomodations 	= $this->model->getAccomodationsCount();
		$this->total_packages 		= $this->model->getPackagesCount();
		$this->total_transports 	= $this->model->getTransportsCount();
		$this->total_places 		= $this->model->getPlacesCount();

		// Get the latest reviews
		$this->latest_reviews = $this->model->getLatestReviews(8);

		if (!empty($this->latest_reviews))
		{
			foreach ($this->latest_reviews as &$ltstrvw)
			{
				if (!empty($ltstrvw->advance_rating) && is_string($ltstrvw->advance_rating))
				{
					$ltstrvw->advance_rating = json_decode($ltstrvw->advance_rating, true);

					if (!empty($ltstrvw->advance_rating) && is_array($ltstrvw->advance_rating))
					{
						$review_sum = array_sum($ltstrvw->advance_rating);
						$ltstrvw->avg_rating = (float) $review_sum / 5;
					}
				}
			}
		}

		// Get the latest booking information
		$this->latest_bookings 		= $this->model->getBookingInfo(10, 'created', 'desc');

		// Get pie chart data i.e. earning data
		$pie = $this->model->getPieData();

		// Get last 30 days all booking count
		$line_chart = array('labels' => array(), 'data' => array());

		$today = new DateTime;
		$end = new DateTime;
		$start = $end->modify('-1 month');

		$interval = DateInterval::createFromDateString('1 day');
		$period = new DatePeriod($start, $interval, $today->modify('+1 day'));

		foreach ($period as $pr)
		{
			$line_chart['labels'][] = $pr->format('Y-m-d');
			$line_chart['data'][] = $this->model->getDailyBookingCount($pr->format('Y-m-d'));
		}

		$doc = Factory::getDocument();
		HTMLHelper::_('jquery.framework');

		$doc->addScript(JUri::root(true) . '/administrator/components/com_spbooking/assets/js/Chart.bundle.min.js');
		$doc->addScript(JUri::root(true) . '/administrator/components/com_spbooking/assets/js/dashboard.js');

		// Send data to represent dougnuts graph
		$pie_chart = array();
		$pie_chart['labels'] = array(
			'Today (' . SpbookingHelper::formatPrice($pie['today']) . ')',
			'This Week (' . SpbookingHelper::formatPrice($pie['week']) . ')',
			'This Month (' . SpbookingHelper::formatPrice($pie['month']) . ')',
			'This Year (' . SpbookingHelper::formatPrice($pie['year']) . ')'
		);
		$pie_chart['data'] = array($pie['today'], $pie['week'], $pie['month'], $pie['year']);
		$pie_chart['currency'] = '$';
		$pie_chart['colors'] = array("#6D06EE", "#11D6FF", "#FFA1F7", "#FFB415");

		$doc->addScriptOptions('pie_data', $pie_chart);

		// Send data to represent line chart
		$doc->addScriptOptions('line_data', $line_chart);

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();

		return parent::display($tpl);
	}

	protected function addToolbar()
	{
		$state	= $this->get('State');
		$canDo	= SpbookingHelper::getActions('com_spbooking', 'component');
		$user	= Factory::getUser();
		$bar	= Toolbar::getInstance('toolbar');

		if ($canDo->get('core.admin'))
		{
			ToolbarHelper::preferences('com_spbooking');
		}

		JHtmlSidebar::setAction('index.php?option=com_spbooking&view=dashboard');
		ToolbarHelper::title(Text::_('COM_SPBOOKING_DASHBOARD_TITLE'), '');
	}
}

