<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;

$rowClass = SpbookingHelper::getJoomlaVersion() < 4 ? 'row-fluid' : 'row';
$colClass = SpbookingHelper::getJoomlaVersion() < 4 ? 'span' : 'col-lg-';
?>

<div class="spbooking-dashboard">
	<?php if (SpbookingHelper::getJoomlaVersion() < 4 && !empty($this->sidebar))
	{
		?>
	<div id="j-sidebar-container" class="<?php echo $colClass;?>2">
		<?php echo $this->sidebar; ?>
	</div>

	<div id="j-main-container" class="<?php echo $colClass;?>10" >
	<?php }
	else
	{
		?>
			<div id="j-main-container"></div>
	<?php } ?>

		<div class="spbooking-row <?php echo $rowClass;?>">
			<div class="<?php echo $colClass;?>8">
				<!-- last thirty days booking count chart  -->
				<div class="spbooking-row booking-count-graph">
					<div class="<?php echo $colClass;?>12">
						<div class="spbooking-box line-chart">
							<h3><?php echo Text::_('COM_SPBOOKING_BOOKING_COUNT'); ?></h3>
							<canvas id="booking-count-line-chart" style="height: 255px;"></canvas>
						</div>
					</div>
				</div>
			</div>
			<div class="<?php echo $colClass;?>4">
				<!-- accomodation, package, transport, place count -->
				<div class="spbooking-row">
					<div class="<?php echo $colClass;?>12">
						<div class="spbooking-box">
							<i class="fa fa-bed"></i>
							<span class="bold-span"><?php echo $this->total_accomodations; ?></span>
							<p><?php echo Text::_('COM_SPBOOKING_DASHBOARD_TOTAL_ACCOMODATIONS'); ?></p>
						</div>
					</div>
				</div>
				<div class="spbooking-row">
					<div class="<?php echo $colClass;?>12">
						<div class="spbooking-box">
							<i class="fa fa-briefcase"></i>
							<span class="bold-span"><?php echo $this->total_packages; ?></span>
							<p><?php echo Text::_('COM_SPBOOKING_DASHBOARD_TOTAL_PACKAGES'); ?></p>
						</div>
					</div>
				</div>
				<div class="spbooking-row">
					<div class="<?php echo $colClass;?>12">
						<div class="spbooking-box">
							<i class="fa fa-car"></i>
							<span class="bold-span"><?php echo $this->total_transports; ?></span>
							<p><?php echo Text::_('COM_SPBOOKING_DASHBOARD_TOTAL_TRANSPORTS'); ?></p>
						</div>
					</div>
				</div>
				<div class="spbooking-row">
					<div class="<?php echo $colClass;?>12">
						<div class="spbooking-box">
							<i class="fa fa-map-marker"></i>
							<span class="bold-span"><?php echo $this->total_places; ?></span>
							<p><?php echo Text::_('COM_SPBOOKING_DASHBOARD_TOTAL_PLACES'); ?></p>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<!-- user latest reviews and earning dougnuts chart  -->
		<div class="spbooking-row booking-count <?php echo $rowClass;?>">
			<div class="<?php echo $colClass;?>4">
				<div class="spbooking-box pie-box review-earning-boxes">
					<h3><?php echo Text::_('COM_SPBOOKING_EARNING_PIE_CHART'); ?></h3>
					<div class="earning-graph-wrapper" style="height: 395px;">
						<canvas id="booking-earning-pie-chart"></canvas>
					</div>
				</div>
			</div>

			<!-- user latest reviews -->
			<div class="<?php echo $colClass;?>8">
				<div class="spbooking-box review-earning-boxes">
					<h3><?php echo Text::_('COM_SPBOOKING_LATEST_REVIEWS'); ?>
						<a href="<?php echo Route::_('index.php?option=com_spbooking&view=reviews'); ?>" class="btn btn-link pull-right"><?php echo Text::_('COM_SPBOOKING_SHOW_ALL_REVIEWS'); ?></a>
					</h3>
					<?php if (!empty($this->latest_reviews))
					{
						?>
						<table class="table">
							<thead>
								<tr>
									<th>#</th>
									<th><?php echo Text::_('COM_SPBOOKING_USER_NAME'); ?></th>
									<th width="20%"><?php echo Text::_('COM_SPBOOKING_RATING'); ?></th>
									<th><?php echo Text::_('COM_SPBOOKING_COMMENT'); ?></th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($this->latest_reviews as $key => $ltrv)
								{
									?>
									<tr>
										<td><?php echo ($key + 1); ?></td>
										<td><?php echo $ltrv->user_name; ?></td>
										<td width="20%">
											<?php foreach (range(1, 5) as $key => $rating)
											{
												?>
												<?php if ($rating <= $ltrv->avg_rating)
												{
													?>
													<span class="fa fa-star is-filled"></span>
												<?php }
												elseif ($rating > $ltrv->avg_rating && $ltrv->avg_rating > $rating - 1)
												{
													?>
													<span class="fa fa-star-half-o is-filled"></span>
												<?php }
												else
												{
													?>
													<span class="fa fa-star-o"></span>
												<?php } ?>
											<?php } ?>	
										</td>
										<td><?php echo $ltrv->review; ?></td>
									</tr>
								<?php } ?>
							</tbody>
						</table>
					<?php }
					else
					{
						?>
						<h2 class="text-center not-found"><?php echo Text::_('COM_SPBOOKING_NO_REVIEW_FOUND'); ?></h2>
					<?php } ?>
				</div>
			</div>
		</div>
		
		<!-- latest booking info table -->
		<div class="<?php echo $colClass;?>12 booking-info-span">
			<div class="spbooking-box">
				<h3><?php echo Text::_('COM_SPBOOKING_LATEST_BOOKING_INFO'); ?>
					<a href="<?php echo Route::_('index.php?option=com_spbooking&view=bookings'); ?>" class="btn btn-link pull-right"><?php echo Text::_('COM_SPBOOKING_SHOW_ALL_BOOKINGS'); ?></a>
				</h3>
				<?php if (!empty($this->latest_bookings))
				{
					?>
					<table class="table">
						<thead>
							<tr>
								<th><?php echo Text::_('#'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_USER_NAME'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_BOOKING_FOR'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_CHECKIN'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_CHECKOUT'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_STATUS'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_USER_EMAIL'); ?></th>
								<th><?php echo Text::_('COM_SPBOOKING_USER_MOBILE'); ?></th>
							</tr>
						</thead>
						<tbody class="latest-booking-thead">
							<?php foreach ($this->latest_bookings as $key => $lbk)
							{
								?>
								<tr>
									<td><?php echo ($key + 1); ?></td>
									<td><?php echo !empty($lbk->name) ? $lbk->name : ''; ?></td>
									<td><?php echo !empty($lbk->booking_for) ? ucfirst($lbk->booking_for) : ''; ?></td>
									<td><?php echo !empty($lbk->checkin) ? $lbk->checkin : ''; ?></td>
									<td><?php echo !empty($lbk->checkout) ? $lbk->checkout : ''; ?></td>
									<td>
										<?php if (!empty($lbk->booking_status))
										{
											?>
											<?php if ($lbk->booking_status == 'invalid')
											{
												?>
												<span class="sp-label is-sm is-danger"><?php echo ucfirst($lbk->booking_status); ?></span>
											<?php }
											elseif ($lbk->booking_status == 'paylater')
											{
												?>
												<span class="sp-label is-sm is-info"><?php echo ucfirst($lbk->booking_status); ?></span>
											<?php }
											elseif ($lbk->booking_status == 'in_approve')
											{
												?>
												<span class="sp-label is-sm is-secondary"><?php echo 'In Approve'; ?></span>
											<?php }
											elseif ($lbk->booking_status == 'paid')
											{
												?>
												<span class="sp-label is-sm is-success"><?php echo $lbk->booking_status; ?></span>
											<?php } ?>
										<?php } ?>
									</td>
									<td><?php echo !empty($lbk->email) ? $lbk->email : ''; ?></td>
									<td><?php echo !empty($lbk->phone) ? $lbk->phone : ''; ?></td>
								</tr>
							<?php } ?>
						</tbody>
					</table>
				<?php }
				else
				{
					?>
					<h2 class="text-center not-found"><?php echo Text::_('COM_SPBOOKING_NO_BOOKING_FOUND'); ?></h2>
				<?php } ?>
			</div>
		</div>
		
	</div>
</div>
	
