<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class SpbookingViewCoupons extends HtmlView
{
	protected $items;

	protected $state;

	protected $pagination;

	protected $model;

	public $filterForm, $activeFilters;

	public function display($tpl = null)
	{
		$this->items			= $this->get('Items');
		$this->state			= $this->get('State');
		$this->pagination		= $this->get('Pagination');
		$this->model			= $this->getModel('coupons');
		$this->filterForm		= $this->get('FilterForm');
		$this->activeFilters	= $this->get('ActiveFilters');

		SpbookingHelper::addSubmenu('coupons');

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(mplode('<br>', $errors), 500);

			return false;
		}

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();

		return parent::display($tpl);
	}

	protected function addToolbar()
	{
		$state	= $this->get('State');
		$canDo	= SpbookingHelper::getActions('com_spbooking', 'component');
		$user	= Factory::getUser();
		$bar	= Toolbar::getInstance('toolbar');

		if ($canDo->get('core.create'))
		{
			ToolbarHelper::addNew('coupon.add');
		}

		if ($canDo->get('core.edit'))
		{
			ToolbarHelper::editList('coupon.edit');
		}

		if ($canDo->get('core.edit.state'))
		{
			ToolbarHelper::publish('coupons.publish', 'JTOOLBAR_PUBLISH', true);
			ToolbarHelper::unpublish('coupons.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			ToolbarHelper::archiveList('coupons.archive');
			ToolbarHelper::checkin('coupons.checkin');
		}

		if ($state->get('filter.published') == -2 && $canDo->get('core.delete'))
		{
			ToolbarHelper::deleteList('', 'coupons.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
		elseif ($canDo->get('core.edit.state'))
		{
			ToolbarHelper::trash('coupons.trash');
		}

		if ($canDo->get('core.admin'))
		{
			ToolbarHelper::preferences('com_spbooking');
		}

		JHtmlSidebar::setAction('index.php?option=com_spbooking&view=coupons');
		ToolbarHelper::title(Text::_('COM_SPBOOKING_COUPONS_TITLE'), '');
	}
}

