<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;

class SpbookingViewBookings extends HtmlView
{
	protected $items;

	protected $state;

	protected $pagination;

	protected $model;

	public $filterForm, $activeFilters;

	private function getModelInstance($name, $prefix = 'SpbookingModel')
	{
		return BaseDatabaseModel::getInstance($name, $prefix);
	}

	public function display($tpl = null)
	{
		$this->items			= $this->get('Items');
		$this->state			= $this->get('State');
		$this->pagination		= $this->get('Pagination');
		$this->model			= $this->getModel('bookings');
		$this->filterForm		= $this->get('FilterForm');
		$this->activeFilters	= $this->get('ActiveFilters');

		if (!empty($this->items))
		{
			foreach ($this->items as $item)
			{
				$item->calculated_price = 0;
				$item->title = '';

				if ($item->booking_for == 'room')
				{
					$accomodation = $this->getModelInstance('Accomodation')->getItem($item->accomodation_id);
					$item->title = $accomodation->title;
					$cartData = !empty($item->cartData) && is_string($item->cartData) ? json_decode($item->cartData) : false;

					if ($cartData)
					{
						foreach ($cartData as $key => $cdata)
						{
							if (isset($cdata->room_price))
							{
								foreach ($cdata->room_price as $cd)
								{
									$cd->special_price = (int) $cd->special_price;
									$cd->original_price = (int) $cd->original_price;

									$cd->child_special_price = (isset($cd->child_special_price)) ? (int) $cd->child_special_price : 0;
									$cd->child_price = (isset($cd->child_price)) ? (int) $cd->child_price : 0;

									if (!empty($cd->special_price))
									{
										$item->calculated_price += $cd->special_price * $cdata->n_rooms;
									}
									else
									{
										$item->calculated_price += $cd->original_price * $cdata->n_rooms;
									}

									if (isset($cdata->child))
									{
										if (!empty($cd->child_special_price))
										{
											$item->calculated_price += $cd->child_special_price * $cdata->n_rooms;
										}
										else
										{
											$item->calculated_price += $cd->child_price * $cdata->n_rooms;
										}
									}
								}
							}

							if ($key == 'additionalServices')
							{
								foreach ($cdata as  $service)
								{
									$item->calculated_price += $service->price;
								}
							}
						}
					}

					$item->calculated_price = $item->calculated_price + ($item->calculated_price * ($item->tax / 100));
					$item->calculated_price = SpbookingHelper::formatPrice($item->calculated_price, $accomodation->currency, $accomodation->currency_type, $accomodation->currency_position, false, 2);
				}
				elseif ($item->booking_for == 'package' || $item->booking_for == 'transport')
				{
					if ($item->booking_for == 'package')
					{
						$package = $this->getModelInstance('Package')->getItem($item->package_id);
						$item->title = $package->title;
					}
					else
					{
						$transport = $this->getModelInstance('Transport')->getItem($item->transport_id);
						$item->title = $transport->title;
					}

					$cartData = !empty($item->cartData) && is_string($item->cartData) ? json_decode($item->cartData) : false;

					$sale_price = (int) $cartData->sale_price;
					$price = (int) $cartData->price;
					$child_sale_price = (isset($cartData->child_sale_price)) ? (int) $cartData->child_sale_price : 0;
					$child_price 	  = (isset($cartData->child_price)) ? (int) $cartData->child_price : 0;

					// Adult
					if (!empty($sale_price))
					{
						$item->calculated_price = ($item->booking_for == 'package') ? $sale_price * $cartData->adult : $sale_price;
					}
					else
					{
								$item->calculated_price = ($item->booking_for == 'package') ? $price * $cartData->adult : $price;
					}

					// Child
					if ($cartData->child > 0)
					{
						if (!empty($child_sale_price))
						{
							$item->calculated_price += ($item->booking_for == 'package') ? $child_sale_price * $cartData->child : $child_sale_price;
						}
						else
						{
							$item->calculated_price += ($item->booking_for == 'package') ? $child_price * $cartData->child : $child_price;
						}
					}

					// Additional Services
					if (!empty($cartData->additionalServices))
					{
						foreach ($cartData->additionalServices as $service)
						{
							$item->calculated_price += $service->price;
						}
					}

					$item->calculated_price = $item->calculated_price + ($item->calculated_price * ($item->tax / 100));

					if ($item->booking_for == 'package')
					{
						$item->calculated_price = SpbookingHelper::formatPrice($item->calculated_price, $package->currency, $package->currency_type, $package->currency_position, false, 2);
					}
					else
					{
								$item->calculated_price = SpbookingHelper::formatPrice($item->calculated_price, $transport->currency, $transport->currency_type, $transport->currency_position, false, 2);
					}
				}
			}
		}

		SpbookingHelper::addSubmenu('bookings');

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode('<br>', $errors), 500);

			return false;
		}

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();

		return parent::display($tpl);
	}

	protected function addToolbar()
	{
		$state	= $this->get('State');
		$canDo	= SpbookingHelper::getActions('com_spbooking', 'component');
		$user	= Factory::getUser();
		$bar	= Toolbar::getInstance('toolbar');

		if ($canDo->get('core.create'))
		{
			ToolbarHelper::addNew('booking.add');
		}

		if ($canDo->get('core.edit'))
		{
			ToolbarHelper::editList('booking.edit');
		}

		if ($canDo->get('core.edit.state'))
		{
			ToolbarHelper::publish('bookings.publish', 'JTOOLBAR_PUBLISH', true);
			ToolbarHelper::unpublish('bookings.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			ToolbarHelper::archiveList('bookings.archive');
			ToolbarHelper::checkin('bookings.checkin');
		}

		if ($state->get('filter.published') == -2 && $canDo->get('core.delete'))
		{
			ToolbarHelper::deleteList('', 'bookings.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
		elseif ($canDo->get('core.edit.state'))
		{
			ToolbarHelper::trash('bookings.trash');
		}

		if ($canDo->get('core.admin'))
		{
			ToolbarHelper::preferences('com_spbooking');
		}

		JHtmlSidebar::setAction('index.php?option=com_spbooking&view=bookings');
		ToolbarHelper::title(Text::_('COM_SPBOOKING_BOOKINGS_TITLE'), '');
	}
}

