<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Layout\LayoutHelper;

$user 		= Factory::getUser();
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn 	= $this->escape($this->state->get('list.direction'));
$canOrder 	= $user->authorise('core.edit.state', 'com_spbooking');
$saveOrder = ($listOrder == 'a.ordering');

if ($saveOrder && !empty($this->items))
{
	if (SpbookingHelper::getJoomlaVersion() < 4)
	{
		$saveOrderingUrl = 'index.php?option=com_spbooking&task=bookings.saveOrderAjax&tmpl=component';
		$html = HTMLHelper::_('sortablelist.sortable', 'bookingList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
	}
	else
	{
		$saveOrderingUrl = 'index.php?option=com_spbooking&taks=bookings.saveOrderAjax&tmpl=component&' . Session::getFormToken() . '=1';
		HTMLHelper::_('draggablelist.draggable');
	}
}

HTMLHelper::_('jquery.framework', false);
?>

<form action="<?php echo Route::_('index.php?option=com_spbooking&view=bookings'); ?>" method="POST" name="adminForm" id="adminForm">
	<?php
	if (SpbookingHelper::getJoomlaVersion() < 4 && !empty($this->sidebar))
	:
		?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>

	<div id="j-main-container" class="span10" >
	<?php else

	:
		?>
			<div id="j-main-container"></div>
	<?php endif; ?>

		<?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
		<div class="clearfix"></div>
		<?php if (!empty($this->items))
		{
			?>
			<div class="table-responsive">
				<table class="table table-striped" id="bookingList">
					<thead>
						<tr>
							<th class="nowrap center hidden-phone" width="1%">
								<?php echo HTMLHelper::_('grid.sort', '<i class="icon-menu-2"></i>', 'a.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING'); ?>
							</th>

							<th width="1%" class="hidden-phone">
								<input type="checkbox" name="checkall-toggle" value="" title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
							</th>

							<th width="5%" class="nowrap center">
								<?php echo HTMLHelper::_('grid.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
							</th>

							<th class="nowrap ">
								<?php echo HTMLHelper::_('grid.sort', 'COM_SPBOOKING_BOOKING_ID', 'a.booked_id', $listDirn, $listOrder); ?>
							</th>
							<th class="nowrap">
								<?php echo HTMLHelper::_('grid.sort', 'COM_SPBOOKING_BOOKING_FOR', 'a.booking_for', $listDirn, $listOrder); ?>
							</th>
							
							<th class="nowrap">
								<?php echo Text::_('COM_SPBOOKING_BOOKING_TITLE'); ?>
							</th>
							
							<th class="nowrap">
								<?php echo HTMLHelper::_('grid.sort', 'COM_SPBOOKING_BOOKING_CHECKIN', 'a.checkin', $listDirn, $listOrder); ?>
							</th>
							<th class="nowrap">
								<?php echo HTMLHelper::_('grid.sort', 'COM_SPBOOKING_BOOKING_CHECKOUT', 'a.checkout', $listDirn, $listOrder); ?>
							</th>

							<th>
								<?php echo Text::_('COM_SPBOOKING_BOOKING_USER_NAME'); ?>
							</th>
							
							<th>
								<?php echo Text::_('COM_SPBOOKING_BOOKING_USER_EMAIL'); ?>
							</th>

							<th>
								<?php echo Text::_('COM_SPBOOKING_BOOKING_TOTAL_PRICE'); ?>
							</th>

							<th>
								<?php echo HTMLHelper::_('grid.sort', 'COM_SPBOOKING_BOOKING_STATUS', 'a.booking_status', $listDirn, $listOrder); ?>
							</th>
							
							<th>
								<?php echo HTMLHelper::_('grid.sort', 'COM_SPBOOKING_CREATED', 'a.created', $listDirn, $listOrder); ?>
							</th>
							
							<th>
								<?php echo HTMLHelper::_('grid.sort', 'COM_SPBOOKING_ID', 'a.id', $listDirn, $listOrder); ?>
							</th>

						</tr>
					</thead>

					<tfoot>
						<tr>
							<td colspan="14">
								<?php echo $this->pagination->getListFooter(); ?>
							</td>
						</tr>
					</tfoot>

					<?php if (SpbookingHelper::getJoomlaVersion() < 4)
					:
						?>
						<tbody>
					<?php else

					:
						?>
						<tbody <?php if ($saveOrder)
						:
							?> class="js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-dirdection="<?php echo strtolower($listDirn); ?>" data-nested="false" <?php
							   endif;?>>
					<?php endif;?>
						<?php
						foreach ($this->items as $i => $item)
						:
							?>
							<?php
							$canCheckin	= $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $user->get('id') || $item->checked_out == 0;
							$canChange		= $user->authorise('core.edit.state', 'com_spbooking') && $canCheckin;
							$canEdit		= $user->authorise('core.edit', 'com_spbooking');
							?>

							<tr class="row<?php echo $i % 2; ?>" <?php echo SpbookingHelper::getJoomlaVersion() < 4 ? 'sortable-group-id="1"' : 'data-draggable-group="1"';?>>
								<td class="order nowrap center hidden-phone">
									<?php if ($canChange)
									:
										$disableClassName = '';
										$disabledLabel = '';

										if (!$saveOrder)
										:
											$disabledLabel = Text::_('JORDERINGDISABLED');
											$disableClassName = 'inactive tip-top';
										endif;
										?>

										<span class="sortable-handler hasTooltip <?php echo $disableClassName; ?>" title="<?php echo $disabledLabel; ?>">
											<i class="icon-menu"></i>
										</span>
										<input type="text" style="display: none;" name="order[]" size="5" class="width-20 text-area-order " value="<?php echo $item->ordering; ?>" >
									<?php else

									:
										?>
										<span class="sortable-handler inactive">
											<i class="icon-menu"></i>
										</span>
									<?php endif; ?>
								</td>

								<td class="center hidden-phone">
															<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
								</td>

								<td class="nowrap center" width="5%">
														<?php if (SpbookingHelper::getJoomlaVersion() < 4)
														:
															?>
									<div class="btn-group status-container">
															<?php echo HTMLHelper::_('jgrid.published', $item->published, $i, 'bookings.', true, 'cb');?>
															<?php
															if ($canChange)
															{
																HTMLHelper::_('actionsdropdown.' . ((int) $item->published === 2 ? 'un' : '') . 'archive', 'cb' . $i, 'bookings');
																HTMLHelper::_('actionsdropdown.' . ((int) $item->published === -2 ? 'un' : '') . 'trash', 'cb' . $i, 'bookings');
																echo HTMLHelper::_('actionsdropdown.render', $this->escape($item->title));
															}
															?>
									</div>
															<?php
														else

														:
																	echo HTMLHelper::_('jgrid.published', $item->published, $i, 'bookings.', true, 'cb');
														endif;
														?>
								</td>

								<td>
									<?php if ($item->checked_out)
									:
										?>
										<?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->created_by, $item->checked_out_time, 'bookings.', $canCheckin); ?>
									<?php endif; ?>

															<?php if ($canEdit)
															:
																?>
										<a class="title" href="<?php echo Route::_('index.php?option=com_spbooking&task=booking.edit&id=' . $item->id); ?>">
																<?php echo $this->escape($item->booked_id); ?>
										</a>
															<?php else

															:
																?>
																<?php echo $this->escape($item->booked_id); ?>
															<?php endif; ?>
								</td>

								<td>
															<?php echo $item->booking_for; ?>
								</td>
								
								<td>
															<?php echo $item->title; ?>
								</td>
								
								<td>
															<?php echo $item->checkin; ?>
								</td>
								
								<td>
															<?php echo $item->checkout; ?>
								</td>

								<td>
															<?php echo $item->name; ?>
								</td>
								
								<td>
															<?php echo $item->email; ?>
								</td>

								<td>
															<?php echo $item->calculated_price; ?>
								</td>
								
								<td>
															<?php echo ucfirst($item->booking_status); ?>
								</td>

								<td>
															<?php echo HTMLHelper::_('date', $item->created, 'd M, Y'); ?>
								</td>
								
								<td>
															<?php echo $item->id; ?>
								</td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		<?php }
		else
		{
			?>
			<div class="alert alert-info">
				<span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
				<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
			</div>
		<?php } ?>

		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $lilstDirn; ?>" />
		<?php echo HTMLHelper::_('form.token'); ?>
	</div>
</form>
	
