<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;

$doc = Factory::getDocument();

if (JVERSION < 4)
{
	HTMLHelper::_('behavior.formvalidator');
	HTMLHelper::_('behavior.keepalive');
}
else
{
	$wa = $doc->getWebAssetManager();
	$wa->useScript('keepalive')
		->useScript('form.validate');
}

if (SpbookingHelper::getJoomlaVersion() < 4)
{
	HTMLHelper::_('formbehavior.chosen', 'select', null, array('disable_search_threshold' => 0));
}

$rowClass = SpbookingHelper::getJoomlaVersion() < 4 ? 'row-fluid' : 'row';
$colClass = SpbookingHelper::getJoomlaVersion() < 4 ? 'span' : 'col-lg-';
?>

<form action="<?php echo Route::_('index.php?option=com_spbooking&view=booking&layout=edit&id=' . (int) $this->item->id); ?>" name="adminForm" id="adminForm" method="post" class="form-validate">
	<?php
	if (SpbookingHelper::getJoomlaVersion() < 4 && !empty($this->sidebar))
	{
		?>
	<div id="j-sidebar-container" class="<?php echo $colClass;?>2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="<?php echo $colClass;?>10" >
	<?php }
	else
	{
		?>
			<div id="j-main-container"></div>
	<?php } ?>
	<div class="form-horizontal">
		<div class="<?php echo $rowClass;?>">
			<div class="<?php echo $colClass;?>8">
				<?php echo $this->form->renderFieldset('basic'); ?>
			</div>
			<div class="<?php echo $colClass;?>4">
				<?php echo $this->form->renderFieldset('options'); ?>
			</div>
		</div>
	</div>

	<input type="hidden" name="task" value="booking.edit" />
	<?php echo HTMLHelper::_('form.token'); ?>
	</div>
</form>

	
