<?php


/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class SpbookingViewAdditionalservice extends HtmlView
{
	protected $item;

	protected $form;

	public function display($tpl = null)
	{
		$this->item = $this->get('Item');
		$this->form = $this->get('Form');

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode('<br>', $errors), 500);

			return false;
		}

		$this->addToolbar();

		return parent::display($tpl);
	}

	protected function addToolbar()
	{
		$input = Factory::getApplication()->input;
		$input->set('hidemainmenu', true);

		$user = Factory::getUser();
		$userId = $user->get('id');
		$isNew = $this->item->id == 0;
		$canDo = SpbookingHelper::getActions('com_spbooking', 'component');

		ToolbarHelper::title(JText::_('COM_SPBOOKING_ADDITIONALSERVICE_TITLE_' . ($isNew ? 'ADD' : 'EDIT')), '');

		if ($canDo->get('core.edit'))
		{
			ToolbarHelper::apply('additionalservice.apply', 'JTOOLBAR_APPLY');
			ToolbarHelper::save('additionalservice.save', 'JTOOLBAR_SAVE');
			ToolbarHelper::save2new('additionalservice.save2new');
			ToolbarHelper::save2copy('additionalservice.save2copy');
		}

		ToolbarHelper::cancel('additionalservice.cancel', 'JTOOLBAR_CLOSE');
	}
}

