<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Application\ApplicationHelper;

class SpbookingTableTransport extends Table
{
	public function __construct(&$db)
	{
		parent::__construct('#__spbooking_transports', 'id', $db);
	}

	public function bind($src, $ignore = array())
	{

		if (isset($src['transport_tags']) && is_array($src['transport_tags']))
		{
			$src['transport_tags'] = json_encode($src['transport_tags']);
		}

		if (is_array($src['facilities']) && !empty($src['facilities']))
		{
			$src['facilities'] = json_encode($src['facilities']);
		}

		if (is_array($src['features']) && !empty($src['features']))
		{
			$src['features'] = json_encode($src['features']);
		}

		if (is_array($src['certificates']) && !empty($src['certificates']))
		{
			$src['certificates'] = json_encode($src['certificates']);
		}

		if (is_array($src['place_ids']) && !empty($src['place_ids']))
		{
			$src['place_ids'] = json_encode($src['place_ids']);
		}

		if (is_array($src['additional_reviews']) && !empty($src['additional_reviews']))
		{
			$src['additional_reviews'] = json_encode($src['additional_reviews']);
		}

		if (is_array($src['gallery']) && !empty($src['gallery']))
		{
			$src['gallery'] = json_encode($src['gallery']);
		}

		return parent::bind($src, $ignore);
	}

	public function store($updateNulls = false)
	{
		$user = Factory::getUser();
		$app  = Factory::getApplication();
		$date = new Date('now', $app->getCfg('offset'));

		if ($this->id)
		{
			$this->modified = (string) $date;
			$this->modified_by = $user->get('id');
		}

		if (empty($this->created))
		{
			$this->created = (string) $date;
		}

		if (empty($this->created_by))
		{
			$this->created_by = $user->get('id');
		}

		if (empty($this->price))
		{
			$this->price = 0.00;
		}

		if (empty($this->sale_price))
		{
			$this->sale_price = 0.00;
		}

		if (empty($this->child_price))
		{
			$this->child_price = (float) $this->child_price;
		}

		if (empty($this->child_sale_price))
		{
			$this->child_sale_price = (float) $this->child_sale_price;
		}

		if (empty($this->certificates))
		{
			$this->certificates = "";
		}

		if (empty($this->person_allowed))
		{
			$this->person_allowed = null;
		}

		$table = Table::getInstance('Transport', 'SpbookingTable');

		if ($table->load(['alias' => $this->alias]) && ($table->id != $this->id || $this->id == 0))
		{
			$this->setError(Text::_('COM_SPBOOKING_ERROR_UNIQUE_ALIAS'));

			return false;
		}

		return parent::store($updateNulls);
	}

	public function check()
	{
		if (trim($this->title) == '')
		{
			throw new UnexpectedValueException(sprintf('The title is empty'));
		}

		if (!empty($this->image))
		{
			SpbookingHelper::makeThumbs($this->image);
		}

		if (empty($this->transport_tags))
		{
			$this->transport_tags = "";
		}

		if (empty($this->place_ids))
		{
			$this->place_ids = "";
		}

		$this->handleAlias();

		return true;
	}

	private function handleAlias()
	{
		if (empty($this->alias))
		{
			$this->alias = $this->title;
		}

		$this->alias = ApplicationHelper::stringURLSafe($this->alias, $this->language);

		if (trim(str_replace('-', '', $this->alias)) == '')
		{
			$this->alias = Factory::getDate()->format('Y-m-d-H-i-s');
		}
	}

	public function publish($pks = null, $published = 1, $userId = 0)
	{
		$k = $this->_tbl_key;
		ArrayHelper::toInteger($pks);
		$published = (int) $published;

		if (empty($pks))
		{
			if ($this->$k)
			{
				$pks = array($this->$k);
			}
			else
			{
				$this->setError(Text::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));

				return false;
			}
		}

		$where = $k . '=' . implode(' OR ' . $k . ' = ', $pks);
		$query = $this->_db->getQuery(true)
			->update($this->_db->quoteName($this->_tbl))
			->set($this->_db->quoteName('published') . ' = ' . $published)
			->where($where);

		$this->_db->setQuery($query);

		try
		{
			$this->_db->execute();
		}
		catch (RuntimeException $e)
		{
			$this->setError($e->getMessage());

			return false;
		}

		if (in_array($this->$k, $pks))
		{
			$this->published = $published;
		}

		$this->setError('');

		return true;
	}
}

