<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Application\ApplicationHelper;

class SpbookingTableRoom extends Table
{
	public function __construct(&$db)
	{
		parent::__construct('#__spbooking_rooms', 'id', $db);
	}

	public function bind($src, $ignore = array())
	{
		if (isset($src['price']) && is_array($src['price']))
		{
			$default_price = $src['price']['sat'];

			foreach ($src['price'] as $key => $price)
			{
				if (empty(trim($price)) && $price != '0')
				{
					$src['price'][$key] = $default_price;
				}
			}

			$src['price'] = json_encode($src['price']);
		}

		if (isset($src['child_price']) && is_array($src['child_price']))
		{
			$default_child_price = $src['child_price']['sat'];

			foreach ($src['child_price'] as $key => $child_price)
			{
				if (empty(trim($child_price)) && $child_price != '0')
				{
					$src['child_price'][$key] = $default_child_price;
				}
			}

			$src['child_price'] = json_encode($src['child_price']);
		}

		if (isset($src['features']) && is_array($src['features']))
		{
			$src['features'] = json_encode($src['features']);
		}

		if (isset($src['special_price']) && is_array($src['special_price']))
		{
			$src['special_price'] = json_encode($src['special_price']);
		}

		if (isset($src['gallery']) && is_array($src['gallery']))
		{
			$src['gallery'] = json_encode($src['gallery']);
		}

		if (isset($src['room_tags']) && is_array($src['room_tags']))
		{
			$src['room_tags'] = json_encode($src['room_tags']);
		}

		return parent::bind($src, $ignore);
	}

	public function store($updateNulls = false)
	{
		$user = Factory::getUser();
		$app  = Factory::getApplication();
		$date = new Date('now', $app->getCfg('offset'));

		if ($this->id)
		{
			$this->modified = (string) $date;
			$this->modified_by = $user->get('id');
		}

		if (empty($this->created))
		{
			$this->created = (string) $date;
		}

		if (empty($this->created_by))
		{
			$this->created_by = $user->get('id');
		}

		$table = Table::getInstance('Room', 'SpbookingTable');

		if ($table->load(['alias' => $this->alias]) && ($table->id != $this->id || $this->id == 0))
		{
			$this->setError(Text::_('COM_SPBOOKING_ERROR_UNIQUE_ALIAS'));

			return false;
		}

		return parent::store($updateNulls);
	}

	public function check()
	{
		if (trim($this->title) == '')
		{
			throw new UnexpectedValueException(sprintf('The title is empty'));
		}

		$price = json_decode($this->price);

		if (empty($price->sat))
		{
			throw new UnexpectedValueException(sprintf('You must have to provide the price of saturday.'));
		}

		$show_child_price = $this->add_child_price;
		$child_price 	  = json_decode($this->child_price);

		if ($show_child_price && empty($child_price->sat))
		{
			throw new UnexpectedValueException(sprintf('You must have to provide the child price of saturday.'));
		}

		$this->handleAlias();

		if (!empty($this->image))
		{
			SpbookingHelper::makeThumbs($this->image);
		}

		return true;
	}

	private function handleAlias()
	{
		if (empty($this->alias))
		{
			$this->alias = $this->title;
		}

		$this->alias = ApplicationHelper::stringURLSafe($this->alias, $this->language);

		if (trim(str_replace('-', '', $this->alias)) == '')
		{
			$this->alias = Factory::getDate()->format('Y-m-d-H-i-s');
		}
	}

	public function publish($pks = null, $published = 1, $userId = 0)
	{
		$k = $this->_tbl_key;
		ArrayHelper::toInteger($pks);
		$publilshed = (int) $published;

		if (empty($pks))
		{
			if ($this->$k)
			{
				$pks = array($this->$k);
			}
			else
			{
				$this->setError(Text::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));

				return false;
			}
		}

		$where = $k . '=' . implode(' OR ' . $k . ' = ', $pks);
		$query = $this->_db->getQuery(true)
			->update($this->_db->quoteName($this->_tbl))
			->set($this->_db->quoteName('published') . ' = ' . $published)
			->where($where);

		$this->_db->setQuery($query);

		try
		{
			$this->_db->execute();
		}
		catch (RuntimeException $e)
		{
			$this->setError($e->getMessage());

			return false;
		}

		if (in_array($this->$k, $pks))
		{
			$this->published = $published;
		}

		$this->setError('');

		return true;
	}
}

