<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Application\ApplicationHelper;


class SpbookingTablePackage extends Table
{
	public function __construct(&$db)
	{
		parent::__construct('#__spbooking_packages', 'id', $db);
	}

	public function bind($src, $ignore = array())
	{
		if (isset($src['activities']) && is_array($src['activities']))
		{
			$src['activities'] = json_encode($src['activities']);
		}

		if (isset($src['overview']) && is_array($src['overview']))
		{
			$src['overview'] = json_encode($src['overview']);
		}

		if (isset($src['certificates']) && is_array($src['certificates']))
		{
			$src['certificates'] = json_encode($src['certificates']);
		}

		if (isset($src['additional_reviews']) && is_array($src['additional_reviews']))
		{
			$src['additional_reviews'] = json_encode($src['additional_reviews']);
		}

		if (isset($src['package_included']) && is_array($src['package_included']))
		{
			$src['package_included'] = json_encode($src['package_included']);
		}

		if (isset($src['package_excluded']) && is_array($src['package_excluded']))
		{
			$src['package_excluded'] = json_encode($src['package_excluded']);
		}

		if (isset($src['additional_services']) && is_array($src['additional_services']))
		{
			$src['additional_services'] = json_encode($src['additional_services']);
		}

		if (isset($src['package_tags']) && is_array($src['package_tags']))
		{
			$src['package_tags'] = json_encode($src['package_tags']);
		}

		if (isset($src['major_activities']) && is_array($src['major_activities']))
		{
			$src['major_activities'] = json_encode($src['major_activities']);
		}

		if (isset($src['custom']) && is_array($src['custom']))
		{
			$src['custom'] = json_encode($src['custom']);
		}

		return parent::bind($src, $ignore);
	}

	public function store($updateNulls = false)
	{
		$user = Factory::getUser();
		$app  = Factory::getApplication();
		$date = new Date('now', $app->getCfg('offset'));

		if ($this->id)
		{
			$this->modified = (string) $date;
			$this->modified_by = $user->get('id');
		}

		if (empty($this->created))
		{
			$this->created = (string) $date;
		}

		if (empty($this->created_by))
		{
			$this->created_by = $user->get('id');
		}

		$table = Table::getInstance('Package', 'SpbookingTable');

		if ($table->load(['alias' => $this->alias]) && ($table->id != $this->id || $this->id == 0))
		{
			$this->setError(Text::_('COM_SPBOOKING_ERROR_UNIQUE_ALIAS'));

			return false;
		}

		return parent::store($updateNulls);
	}

	public function check()
	{
		if (trim($this->title) == '')
		{
			throw new UnexpectedValueException(sprintf('The title is empty'));
		}

		$this->handleAlias();

		if (!($this->end_date > $this->start_date) && $this->show_end_date)
		{
			throw new UnexpectedValueException(sprintf(Text::_('COM_SPBOOKING_PACKAGE_END_DATE_ERROR_MESSAGE')));
		}

		if (!$this->show_end_date && $this->package_type !== 'long')
		{
			$this->end_date = "0000-00-00";
		}

		if (!empty($this->image))
		{
			SpbookingHelper::makeThumbs($this->image);
		}

		if (empty($this->sale_price))
		{
			$this->sale_price = (float) $this->sale_price;
		}

		if (empty($this->child_price))
		{
			$this->child_price = (float) $this->child_price;
		}

		if (empty($this->child_sale_price))
		{
			$this->child_sale_price = (float) $this->child_sale_price;
		}

		return true;
	}

	private function handleAlias()
	{
		if (empty($this->alias))
		{
			$this->alias = $this->title;
		}

		$this->alias = ApplicationHelper::stringURLSafe($this->alias, $this->language);

		if (trim(str_replace('-', '', $this->alias)) == '')
		{
			$this->alias = Factory::getDate()->format('Y-m-d-H-i-s');
		}
	}

	public function publish($pks = null, $published = 1, $userId = 0)
	{
		$k = $this->_tbl_key;
		ArrayHelper::toInteger($pks);
		$published = (int) $published;

		if (empty($pks))
		{
			if ($this->$k)
			{
				$pks = array($this->$k);
			}
			else
			{
				$this->setError(Text::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));

				return false;
			}
		}

		$where = $k . '=' . implode(' OR ' . $k . ' = ', $pks);
		$query = $this->_db->getQuery(true)
			->update($this->_db->quoteName($this->_tbl))
			->set($this->_db->quoteName('published') . ' = ' . $published)
			->where($where);

		$this->_db->setQuery($query);

		try
		{
			$this->_db->execute();
		}
		catch (RuntimeException $e)
		{
			$this->setError($e->getMessage());

			return false;
		}

		if (in_array($this->$k, $pks))
		{
			$this->published = $published;
		}

		$this->setError('');

		return true;
	}
}

