<?php

/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Application\ApplicationHelper;

class SpbookingTableBooking extends Table
{
	public function __construct(&$db)
	{
		parent::__construct('#__spbooking_bookings', 'id', $db);
	}

	public function bind($src, $ignore = array())
	{
		if (!empty($src['room_id']) && is_array($src['room_id']))
		{
			$src['room_id'] = json_encode($src['room_id']);
		}

		if (!empty($src['number_of_rooms']) && is_array($src['number_of_rooms']))
		{
			$src['number_of_rooms'] = json_encode($src['number_of_rooms']);
		}

		if (!empty($src['room_numbers']) && is_array($src['room_numbers']))
		{
			$src['room_numbers'] = json_encode($src['room_numbers']);
		}

		return parent::bind($src, $ignore);
	}

	public function store($updateNulls = false)
	{
		$user = Factory::getUser();
		$app  = Factory::getApplication();
		$date = new Date('now', $app->getCfg('offset'));

		if ($this->id)
		{
			$this->modified = (string) $date;
			$this->modified_by = $user->get('id');
		}

		if (empty($this->id))
		{
			$this->booked_id = date('ymdhis') . rand(1000, 9999);
		}

		if (empty($this->created))
		{
			$this->created = (string) $date;
		}

		if (empty($this->created_by))
		{
			$this->created_by = $user->get('id');
		}

		if (empty($this->checkin))
		{
			$this->checkin = (string) $date;
		}

		$table = Table::getInstance('Booking', 'SpbookingTable');

		return parent::store($updateNulls);
	}

	public function check()
	{
		if (!empty($this->total_price) && $this->booking_status == 'paid')
		{
			$this->total_paid = $this->total_price;
		}

		if (empty($this->txn_id))
		{
			$this->txn_id = "";
		}

		return true;
	}

	private function handleAlias()
	{
		if (empty($this->alias))
		{
			$this->alias = $this->title;
		}

		$this->alias = ApplicationHelper::stringURLSafe($this->alias, $this->language);

		if (trim(str_replace('-', '', $this->alias)) == '')
		{
			$this->alias = Factory::getDate()->format('Y-m-d-H-i-s');
		}
	}

	public function publish($pks = null, $published = 1, $userId = 0)
	{
		$k = $this->_tbl_key;
		ArrayHelper::toInteger($pks);
		$published = (int) $published;

		if (empty($pks))
		{
			if ($this->$k)
			{
				$pks = array($this->$k);
			}
			else
			{
				$this->setError(Text::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));

				return false;
			}
		}

		$where = $k . '=' . implode(' OR ' . $k . ' = ', $pks);
		$query = $this->_db->getQuery(true)
			->update($this->_db->quoteName($this->_tbl))
			->set($this->_db->quoteName('published') . ' = ' . $published)
			->where($where);

		$this->_db->setQuery($query);

		try
		{
			$this->_db->execute();
		}
		catch (RuntimeException $e)
		{
			$this->setError($e->getMessage());

			return false;
		}

		if (in_array($this->$k, $pks))
		{
			$this->published = $published;
		}

		$this->setError('');

		return true;
	}
}

