-- Table Structure For `#__spbooking_packagetypes`

CREATE TABLE IF NOT EXISTS `#__spbooking_packagetypes` ( 
  `id` bigint unsigned NOT NULL AUTO_INCREMENT, 
  `title` varchar(255) NOT NULL DEFAULT '', 
  `alias` varchar(400) NOT NULL DEFAULT '', 
  `published` tinyint(3) NOT NULL DEFAULT '0', 
  `language` varchar(255) NOT NULL DEFAULT '*', 
  `access` int NOT NULL DEFAULT '1', 
  `ordering` int NOT NULL DEFAULT '0', 
  `created_by` bigint NOT NULL DEFAULT '0', 
  `created` datetime NULL DEFAULT NULL, 
  `modified_by` bigint NOT NULL DEFAULT '0', 
  `modified` datetime NULL DEFAULT NULL, 
  `checked_out` bigint NOT NULL DEFAULT '0', 
  `checked_out_time` datetime NULL DEFAULT NULL, 
  PRIMARY KEY (`id`) 
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__spbooking_packagetypes`
--

INSERT INTO `#__spbooking_packagetypes`
(`id`, `title`, `alias`, `published`, `language`, `access`, `ordering`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`) 
VALUES  
(1,'Day Tour','day',1,'*',1,0,0,CURRENT_TIMESTAMP(),0,CURRENT_TIMESTAMP(),0,NULL),
(2,'Long','long',1,'*',1,0,0,CURRENT_TIMESTAMP(),0,CURRENT_TIMESTAMP(),0,NULL);

--
-- New columns for `#__spbooking_accomodations`
--

ALTER TABLE `#__spbooking_accomodations` 
ADD `others` TEXT NULL DEFAULT NULL AFTER `accomodation_tags`,
ADD `landmark` VARCHAR(255) NULL DEFAULT NULL AFTER `others`;

-- Alter Structure for #__spbooking_accomodations --
ALTER TABLE `#__spbooking_accomodations` CHANGE `created` `created` datetime NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_accomodations` CHANGE `modified` `modified` datetime NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_accomodations` CHANGE `checked_out_time` `checked_out_time` datetime NULL DEFAULT NULL;

--  Update Structure for #__spbooking_accomodations --
UPDATE `#__spbooking_accomodations` SET `created` = NULL WHERE `created` = '0000-00-00 00:00:00';
UPDATE `#__spbooking_accomodations` SET `modified` = NULL WHERE `modified` = '0000-00-00 00:00:00';
UPDATE `#__spbooking_accomodations` SET `checked_out_time` = NULL WHERE `checked_out_time` = '0000-00-00 00:00:00';

--
-- New columns for `#__spbooking_packages`
--

ALTER TABLE `#__spbooking_packages` 
ADD `major_activities` TEXT NULL DEFAULT NULL AFTER `featured`,
ADD `custom` TEXT NULL DEFAULT NULL AFTER `major_activities`,
ADD `child_price` FLOAT(8,2) NOT NULL AFTER `sale_price`, 
ADD `child_sale_price` FLOAT(8,2) NOT NULL AFTER `child_price`;

-- Alter Structure for #__spbooking_packages --
ALTER TABLE `#__spbooking_packages` CHANGE `start_date` `start_date` date NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_packages` CHANGE `end_date` `end_date` date NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_packages` CHANGE `created` `created` datetime NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_packages` CHANGE `modified` `modified` datetime NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_packages` CHANGE `checked_out_time` `checked_out_time` datetime NULL DEFAULT NULL;

--  Update Structure for #__spbooking_packages --
UPDATE `#__spbooking_packages` SET `start_date` = NULL WHERE `start_date` = '0000-00-00';
UPDATE `#__spbooking_packages` SET `end_date` = NULL WHERE `end_date` = '0000-00-00';
UPDATE `#__spbooking_packages` SET `created` = NULL WHERE `created` = '0000-00-00 00:00:00';
UPDATE `#__spbooking_packages` SET `modified` = NULL WHERE `modified` = '0000-00-00 00:00:00';
UPDATE `#__spbooking_packages` SET `checked_out_time` = NULL WHERE `checked_out_time` = '0000-00-00 00:00:00';

-- New columns for `#__spbooking_rooms`--
ALTER TABLE `#__spbooking_rooms` ADD `add_child_price` TINYINT(3) NOT NULL DEFAULT '0' AFTER `child`;
ALTER TABLE `#__spbooking_rooms` ADD `child_price` TEXT AFTER `add_child_price`;

-- Alter Structure for #__spbooking_rooms --
ALTER TABLE `#__spbooking_rooms` CHANGE `created` `created` datetime NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_rooms` CHANGE `modified` `modified` datetime NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_rooms` CHANGE `checked_out_time` `checked_out_time` datetime NULL DEFAULT NULL;

--  Update Structure for #__spbooking_rooms --
UPDATE `#__spbooking_rooms` SET `created` = NULL WHERE `created` = '0000-00-00 00:00:00';
UPDATE `#__spbooking_rooms` SET `modified` = NULL WHERE `modified` = '0000-00-00 00:00:00';
UPDATE `#__spbooking_rooms` SET `checked_out_time` = NULL WHERE `checked_out_time` = '0000-00-00 00:00:00';

--
-- New columns for `#__spbooking_transports`
--

ALTER TABLE `#__spbooking_transports` 
ADD `child_price` FLOAT(8,2) NOT NULL AFTER `sale_price`, 
ADD `child_sale_price` FLOAT(8,2) NOT NULL AFTER `child_price`;

-- Alter Structure for #__spbooking_transports --
ALTER TABLE `#__spbooking_packages` CHANGE `created` `created` datetime NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_packages` CHANGE `modified` `modified` datetime NULL DEFAULT NULL;
ALTER TABLE `#__spbooking_packages` CHANGE `checked_out_time` `checked_out_time` datetime NULL DEFAULT NULL;

--  Update Structure for #__spbooking_transports --
UPDATE `#__spbooking_packages` SET `created` = NULL WHERE `created` = '0000-00-00 00:00:00';
UPDATE `#__spbooking_packages` SET `modified` = NULL WHERE `modified` = '0000-00-00 00:00:00';
UPDATE `#__spbooking_packages` SET `checked_out_time` = NULL WHERE `checked_out_time` = '0000-00-00 00:00:00';