
-- SP Booking - by JoomShaper.com
-- author    JoomShaper http://www.joomshaper.com
-- Copyright (C) 2010 - 2019 JoomShaper.com. All Rights Reserved.
-- License - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
-- Websites: http://www.joomshaper.com


-- Create syntax for TABLE '#__spbooking_categories'
CREATE TABLE IF NOT EXISTS `#__spbooking_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) NOT NULL DEFAULT '',
  `description` text,
  `icon_image` tinyint(3) NOT NULL DEFAULT '0',
  `icon` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `category_for` varchar(255) NOT NULL DEFAULT '',
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Create syntax for TABLE '#__spbooking_accomodations'
CREATE TABLE IF NOT EXISTS `#__spbooking_accomodations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) NOT NULL DEFAULT '',
  `category_id` bigint unsigned NOT NULL,
  `description` text,
  `country` varchar(100) NOT NULL DEFAULT '',
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(50) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `web` varchar(255) DEFAULT NULL,
  `currency` varchar(50) DEFAULT 'USD:$',
  `currency_type` varchar(20) DEFAULT NULL,
  `currency_position` varchar(20) DEFAULT NULL,
  `map` varchar(100) NOT NULL DEFAULT '',
  `featured` tinyint(3) NOT NULL DEFAULT '0',
  `star_rating` varchar(100) DEFAULT NULL,
  `logo` varchar(255) NOT NULL DEFAULT '',
  `banner` varchar(255) NOT NULL DEFAULT '',
  `gallery` text,
  `extra_features` text,
  `additional_review` text,
  `certificates` text,
  `facilities` text,
  `policies` text,
  `metadata` text,
  `accomodation_tags` text,
  `others` text,
  `landmark` varchar(255) DEFAULT NULL,
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NULL DEFAULT NULL,
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NULL DEFAULT NULL,
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Create syntax for TABLE '#__spbooking_rooms'
CREATE TABLE IF NOT EXISTS `#__spbooking_rooms` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `accomodation_id` bigint unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) NOT NULL DEFAULT '',
  `adult` int(11) NOT NULL DEFAULT '0',
  `child` int(11) NOT NULL DEFAULT '0',
  `add_child_price` tinyint(3) NOT NULL DEFAULT '0',
  `child_price` text,
  `price` text,
  `features` text,
  `featured` tinyint(3) NOT NULL DEFAULT '0',
  `description` text,
  `special_price` text,
  `room_number` varchar(100) DEFAULT '',
  `image` varchar(255) DEFAULT NULL,
  `gallery` text,
  `facilities` text,
  `size` varchar(100) DEFAULT '0',
  `room_tags` text,
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NULL DEFAULT NULL,
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NULL DEFAULT NULL,
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Create syntax for TABLE '#__spbooking_coupons'
CREATE TABLE IF NOT EXISTS `#__spbooking_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) NOT NULL DEFAULT '',
  `code` varchar(255) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '0',
  `coupon_type` varchar(255) NOT NULL DEFAULT '0',
  `max_discount` int(11) DEFAULT '0',
  `valid_from` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `valid_to` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checkin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checkout` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `coupon_for` varchar(255) NOT NULL DEFAULT '0',
  `accomodation_id` text,
  `package_id` text,
  `room_id` text,
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Create syntax for TABLE '#__spbooking_additionalservices'
CREATE TABLE IF NOT EXISTS `#__spbooking_additionalservices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) NOT NULL DEFAULT '',
  `service_for` varchar(255) DEFAULT NULL,
  `price` float(8,2) DEFAULT '0.00',
  `max_quantity` int(11) DEFAULT '0',
  `logo` varchar(255) DEFAULT '',
  `description` text,
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Create syntax for TABLE '#__spbooking_packages'
CREATE TABLE IF NOT EXISTS `#__spbooking_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `package_type` varchar(50) DEFAULT 'long',
  `price` float(8,2) NOT NULL,
  `sale_price` float(8,2) NOT NULL,
  `child_price` float(8,2) NOT NULL,
  `child_sale_price` float(8,2) NOT NULL,
  `currency` varchar(50) DEFAULT NULL,
  `currency_type` varchar(20) DEFAULT NULL,
  `currency_position` varchar(20) DEFAULT NULL,
  `start_date` date NULL DEFAULT NULL,
  `show_end_date` tinyint(3) NOT NULL DEFAULT '0',
  `end_date` date NULL DEFAULT NULL,
  `description` text,
  `featured` tinyint(3) NOT NULL DEFAULT '0',
  `major_activities` text,
  `custom` text,
  `activities` text,
  `overview` text,
  `package_included` text,
  `package_excluded` text,
  `duration` varchar(255) NOT NULL DEFAULT '',
  `availability` int(11) NOT NULL DEFAULT '0',
  `country` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(50) DEFAULT NULL,
  `gallery` text,
  `package_tags` text,
  `additional_services` text,
  `additional_reviews` text,
  `certificates` text,
  `category_id` bigint NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NULL DEFAULT NULL,
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NULL DEFAULT NULL,
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Create syntax for TABLE '#__spbooking_bookings'
CREATE TABLE IF NOT EXISTS `#__spbooking_bookings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `booked_id` text,
  `booking_for` varchar(100) NOT NULL DEFAULT '',
  `checkin` date NOT NULL DEFAULT '0000-00-00',
  `checkout` date NOT NULL DEFAULT '0000-00-00',
  `number_of_rooms` text,
  `room_numbers` text,
  `room_id` text,
  `accomodation_id` text,
  `package_id` text,
  `transport_id` text,
  `user_id` bigint unsigned DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` text,
  `comment` text,
  `cartData` text,
  `tax` float(8,2) NOT NULL DEFAULT '0.00',
  `payment_type` varchar(100) NOT NULL DEFAULT '',
  `txn_id` varchar(255) NOT NULL,
  `card_number` varchar(255) DEFAULT NULL,
  `contact_person_name` varchar(255) DEFAULT NULL,
  `contact_person_phone` varchar(100) DEFAULT NULL,
  `booking_status` varchar(255) NOT NULL DEFAULT '0',
  `total_price` float(8,2) NOT NULL DEFAULT '0.00',
  `total_paid` float(8,2) NOT NULL DEFAULT '0.00',
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Create syntax for TABLE '#__spbooking_reviews'
CREATE TABLE IF NOT EXISTS `#__spbooking_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `accomodation_id` bigint NOT NULL DEFAULT '0',
  `package_id` bigint NOT NULL DEFAULT '0',
  `transport_id` bigint NOT NULL DEFAULT '0',
  `place_id` int(11) NOT NULL DEFAULT '0',
  `reviewed_for` varchar(100) NOT NULL DEFAULT '',
  `user_id` bigint unsigned DEFAULT '0',
  `user_ip` varchar(50) DEFAULT '0',
  `user_name` varchar(255) DEFAULT NULL,
  `user_email` varchar(255) DEFAULT NULL,
  `rating` int(11) unsigned NOT NULL DEFAULT '0',
  `advance_rating` text,
  `review` text,
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Create syntax for TABLE '#__spbooking_tags'
CREATE TABLE IF NOT EXISTS `#__spbooking_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `alias` varchar(400) NOT NULL DEFAULT '',
  `tag_for` varchar(100) NOT NULL DEFAULT '',
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Create syntax for TABLE `#__spbooking_transports`
CREATE TABLE IF NOT EXISTS `#__spbooking_transports` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `price` float(8,2) NOT NULL,
  `sale_price` float(8,2) NOT NULL,
  `child_price` float(8,2) NOT NULL,
  `child_sale_price` float(8,2) NOT NULL,
  `description` text,
  `featured` tinyint(3) NOT NULL DEFAULT '0',
  `category_id` bigint NOT NULL DEFAULT '0',
  `transport_tags` text NOT NULL,
  `place_ids` text NOT NULL,
  `currency` varchar(50) NOT NULL DEFAULT 'USD:$',
  `currency_type` varchar(20) NOT NULL DEFAULT '',
  `currency_position` varchar(20) NOT NULL DEFAULT '',
  `gallery` text,
  `facilities` text,
  `features` text,
  `certificates` text NOT NULL,
  `person_allowed` int DEFAULT NULL,
  `additional_reviews` text,
  `country` varchar(100) NOT NULL,
  `state` varchar(155) NOT NULL,
  `city` varchar(155) NOT NULL,
  `zip` varchar(55) NOT NULL,
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- Create syntax for TABLE `#__spbooking_transports`
CREATE TABLE IF NOT EXISTS `#__spbooking_places` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `video` text,
  `gallery` text,
  `description` text,
  `featured` tinyint(3) NOT NULL DEFAULT '0',
  `country` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `activities` text,
  `category_id` bigint NOT NULL DEFAULT '0',
  `place_tags` text,
  `gmap` varchar(255) DEFAULT '',
  `web` varchar(155) DEFAULT '',
  `email` varchar(100) DEFAULT '',
  `phone` varchar(100) DEFAULT '',
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `created_by` bigint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- Table Structure For `#__spbooking_packagetypes`

CREATE TABLE IF NOT EXISTS `#__spbooking_packagetypes` ( 
  `id` bigint unsigned NOT NULL AUTO_INCREMENT, 
  `title` varchar(255) NOT NULL DEFAULT '', 
  `alias` varchar(400) NOT NULL DEFAULT '', 
  `published` tinyint(3) NOT NULL DEFAULT '0', 
  `language` varchar(255) NOT NULL DEFAULT '*', 
  `access` int NOT NULL DEFAULT '1', 
  `ordering` int NOT NULL DEFAULT '0', 
  `created_by` bigint NOT NULL DEFAULT '0', 
  `created` datetime NULL DEFAULT NULL, 
  `modified_by` bigint NOT NULL DEFAULT '0', 
  `modified` datetime NULL DEFAULT NULL, 
  `checked_out` bigint NOT NULL DEFAULT '0', 
  `checked_out_time` datetime NULL DEFAULT NULL, 
  PRIMARY KEY (`id`) 
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;