<?php
/**
 * @package com_spbooking
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

// No Direct Access
defined('_JEXEC') or die('Resticted Aceess');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;

if (file_exists(JPATH_COMPONENT . '/vendor/autoload.php'))
{
	include JPATH_COMPONENT . '/vendor/autoload.php';
}

if (!Factory::getUser()->authorise('core.manage', 'com_spbooking'))
{
	throw new \Exception(Text::_('JERROR_ALERTNOAUTHOR'), 404);
}

if (file_exists(JPATH_COMPONENT . '/helpers/spbooking.php'))
{
	JLoader::register('SpbookingHelper', JPATH_COMPONENT . '/helpers/spbooking.php');
}

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::root(true) . '/administrator/components/com_spbooking/assets/css/style.css');
$doc->addStyleSheet(Uri::root(true) . '/administrator/components/com_spbooking/assets/css/font-awesome.min.css');

if (JVERSION < 4)
{
	$doc->addStyleSheet(Uri::root(true) . '/administrator/components/com_spbooking/assets/css/font-awesome-5.min.css');
	$doc->addStyleSheet(Uri::root(true) . '/administrator/components/com_spbooking/assets/css/font-awesome-v4-shims.css');
}

// Execute the task.
$controller = BaseController::getInstance('Spbooking');
$controller->execute(Factory::getApplication()->input->get('task'));
$controller->redirect();

